/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.SpecException;
import org.talend.bigdata.dataflow.hexpr.AvroGetter;
import org.talend.bigdata.dataflow.hexpr.AvroSetter;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.aggregate.AggregateValue;
import org.talend.bigdata.dataflow.hmap.aggregate.AggregateValueFactory;

public class AvroMapTransformer {
    private final AvroGetter mIn;
    private final AvroSetter mOut;
    private final InputStep mRootInStep;
    private final HashMap<HExpr, InputStep> mInSteps = new HashMap();
    private final HashMap<HExpr, OutputStep> mOutSteps = new HashMap();

    public AvroMapTransformer(AvroGetter in, AvroSetter out) {
        this.mIn = in;
        this.mOut = out;
        this.mRootInStep = new InputStep(this.mIn.getRootHExpr());
        this.mRootInStep.mCreateOnPrepare.add(this.mOut.getRootHExpr());
        this.mInSteps.put(this.mIn.getRootHExpr(), this.mRootInStep);
        this.mOutSteps.put(this.mOut.getRootHExpr(), new OutputStep(this.mOut.getRootHExpr()));
    }

    void addTransform(HMapSpec.TransformDef td) {
        HExpr parent;
        for (parent = td.mInput.getContainerParent(); parent != null && !this.mInSteps.containsKey(parent); parent = parent.getContainerParent()) {
            if (!parent.isArray()) continue;
            this.mInSteps.put(parent, new InputStep(parent));
        }
        for (parent = td.mOutput.getContainerParent(); parent != null && !this.mOutSteps.containsKey(parent); parent = parent.getContainerParent()) {
            if (!parent.isArray()) continue;
            this.mOutSteps.put(parent, new OutputStep(parent));
        }
        if (!td.mHintOnly) {
            this.mInSteps.get(td.mInput.getContainerParent()).addTransform(td);
        }
    }

    void build() throws SpecException {
        for (InputStep step : this.mInSteps.values()) {
            step.buildIntoSubSteps();
        }
        this.mRootInStep.build();
    }

    public void transformInput(IndexedRecord record) {
        this.mIn.setRootValue(record);
        this.mRootInStep.execute();
    }

    private void addCreateOnPrepare(InputStep inStep, HExpr outLevel) {
        OutputStep outStep = this.mOutSteps.get(outLevel);
        if (outStep == null) {
            outStep = new OutputStep(outLevel);
            this.mOutSteps.put(outLevel, outStep);
        }
    }

    private void addAggregate(HExpr outLevel, HMapSpec.TransformDef td) {
        OutputStep outStep = this.mOutSteps.get(outLevel);
        if (outStep == null) {
            outStep = new OutputStep(outLevel);
            this.mOutSteps.put(outLevel, outStep);
        }
        outStep.mToAggregate.add(td);
    }

    private void addDemotion(HExpr outLevel, HMapSpec.TransformDef td) {
        OutputStep outStep = this.mOutSteps.get(outLevel);
        if (outStep == null) {
            outStep = new OutputStep(outLevel);
            this.mOutSteps.put(outLevel, outStep);
        }
        outStep.mToDemote.add(td);
    }

    public String toExecutionPlan() {
        StringWriter sOut = new StringWriter();
        PrintWriter out = new PrintWriter(sOut);
        out.println("Transformation from " + this.mIn.getRootHExpr() + " to " + this.mOut.getRootHExpr());
        out.println("==============");
        out.println();
        out.println("In schema");
        out.println("---------");
        out.println("```");
        out.println(this.mIn.getRootSchema().toString(true));
        out.println("```");
        out.println();
        out.println("Out schema");
        out.println("----------");
        out.println("```");
        out.println(this.mOut.getRootSchema().toString(true));
        out.println("```");
        out.println();
        out.println("InputSteps");
        out.println("----------");
        this.mRootInStep.toExecutionPlan("", out);
        out.println();
        out.println("OutputSteps");
        out.println("-----------");
        for (HExpr outExpr : this.mOut) {
            OutputStep outStep = this.mOutSteps.get(outExpr);
            if (outStep == null) continue;
            outStep.toExecutionPlan("", out);
        }
        out.close();
        return sOut.toString();
    }

    private class OutputStep {
        private final HExpr mLevel;
        private final ArrayList<HMapSpec.TransformDef> mToAggregate = new ArrayList();
        private final ArrayList<HMapSpec.TransformDef> mToDemote = new ArrayList();

        OutputStep(HExpr level) {
            this.mLevel = level;
        }

        public void onCreate() {
            if (this.mLevel.getContainerParent() == null || this.mLevel.isArray()) {
                AvroMapTransformer.this.mOut.create(this.mLevel);
            }
            for (HMapSpec.TransformDef td : this.mToAggregate) {
                AvroMapTransformer.this.mOut.set(td.mOutput, AggregateValueFactory.create(td.mOp));
            }
        }

        public void onCleanup() {
            for (HMapSpec.TransformDef td : this.mToDemote) {
                AvroMapTransformer.this.mOut.set(td.mOutput, AvroMapTransformer.this.mIn.get(td.mInput));
            }
            for (HMapSpec.TransformDef td : this.mToAggregate) {
                AggregateValue value = (AggregateValue)AvroMapTransformer.this.mOut.get(td.mOutput);
                AvroMapTransformer.this.mOut.set(td.mOutput, value.compute());
            }
        }

        public void toExecutionPlan(String indent, PrintWriter out) {
            out.println(indent + "mLevel: " + this.mLevel + " ----------");
            for (HMapSpec.TransformDef td : this.mToDemote) {
                out.println(indent + "mToDemote: " + td);
            }
            for (HMapSpec.TransformDef td : this.mToAggregate) {
                out.println(indent + "mToAggregate: " + td);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + AvroMapTransformer.this.mIn.getRootHExpr().getFullyQualifiedName() + ":" + this.mLevel + "}";
        }
    }

    private class InputStep {
        private final HExpr mLevel;
        private final TreeSet<HExpr> mCreateOnPrepare = new TreeSet<HExpr>(new HExpr.FqNameComparable());
        private final ArrayList<HMapSpec.TransformDef> mToCopy = new ArrayList();
        private final ArrayList<HMapSpec.TransformDef> mToAggregate = new ArrayList();
        private final ArrayList<HMapSpec.TransformDef> mToPromote = new ArrayList();
        private final ArrayList<InputStep> mSubSteps = new ArrayList();

        InputStep(HExpr level) {
            this.mLevel = level;
        }

        void addTransform(HMapSpec.TransformDef td) {
            int inCardinality = td.mInput.getCardinalityLevel();
            int outCardinality = td.mOutput.getCardinalityLevel();
            if (td.mOp == null) {
                if (!this.mCreateOnPrepare.contains(td.mOutput.getContainerParent())) {
                    this.mCreateOnPrepare.add(td.mOutput.getContainerParent());
                    AvroMapTransformer.this.addCreateOnPrepare(this, td.mOutput.getContainerParent());
                }
                if (inCardinality == outCardinality) {
                    this.mToCopy.add(td);
                } else if (inCardinality > outCardinality) {
                    this.mToPromote.add(td);
                } else {
                    AvroMapTransformer.this.addDemotion(td.mOutput.getContainerParent(), td);
                }
            } else {
                this.mToAggregate.add(td);
                AvroMapTransformer.this.addAggregate(td.mOutput.getContainerParent(), td);
            }
        }

        private void buildIntoSubSteps() {
            HExpr containerParent = this.mLevel.getContainerParent();
            if (containerParent != null) {
                ((InputStep)((AvroMapTransformer)AvroMapTransformer.this).mInSteps.get((Object)containerParent)).mSubSteps.add(this);
            }
        }

        void build() throws SpecException {
            for (InputStep substep : this.mSubSteps) {
                substep.build();
            }
            Iterator<HExpr> i = this.mCreateOnPrepare.iterator();
            while (i.hasNext()) {
                HExpr create = i.next();
                if (this.isCreatedInStep(false, create)) {
                    i.remove();
                    continue;
                }
                for (create = create.getContainerParent(); create != null && !this.mCreateOnPrepare.contains(create) && create.getCardinalityLevel() > this.mLevel.getCardinalityLevel(); create = create.getContainerParent()) {
                    this.mCreateOnPrepare.add(create);
                    AvroMapTransformer.this.addCreateOnPrepare(this, create);
                }
            }
        }

        private boolean isCreatedInStep(boolean includeThis, HExpr outLevel) {
            if (includeThis && this.mCreateOnPrepare.contains(outLevel)) {
                return true;
            }
            for (InputStep inStep : this.mSubSteps) {
                if (!inStep.isCreatedInStep(true, outLevel)) continue;
                return true;
            }
            return false;
        }

        public void execute() {
            for (HExpr toCreate : this.mCreateOnPrepare) {
                ((OutputStep)AvroMapTransformer.this.mOutSteps.get(toCreate)).onCreate();
            }
            for (HMapSpec.TransformDef td : this.mToCopy) {
                AvroMapTransformer.this.mOut.set(td.mOutput, AvroMapTransformer.this.mIn.get(td.mInput));
            }
            for (HMapSpec.TransformDef td : this.mToPromote) {
                AvroMapTransformer.this.mOut.set(td.mOutput, AvroMapTransformer.this.mIn.get(td.mInput));
            }
            for (HMapSpec.TransformDef td : this.mToAggregate) {
                AggregateValue aggr = (AggregateValue)AvroMapTransformer.this.mOut.get(td.mOutput);
                aggr.combine(AvroMapTransformer.this.mIn.get(td.mInput));
            }
            for (InputStep step : this.mSubSteps) {
                while (AvroMapTransformer.this.mIn.hasNext(step.mLevel)) {
                    AvroMapTransformer.this.mIn.next(step.mLevel);
                    step.execute();
                }
            }
            for (HExpr toCreate : this.mCreateOnPrepare.descendingSet()) {
                ((OutputStep)AvroMapTransformer.this.mOutSteps.get(toCreate)).onCleanup();
            }
        }

        public void toExecutionPlan(String indent, PrintWriter out) {
            out.println(indent + "mLevel: " + this.mLevel + " ----------");
            for (HExpr create : this.mCreateOnPrepare) {
                out.println(indent + "mCreateOnPrepare: " + create);
            }
            for (HMapSpec.TransformDef td : this.mToCopy) {
                out.println(indent + "mToCopy: " + td);
            }
            for (HMapSpec.TransformDef td : this.mToAggregate) {
                out.println(indent + "mToAggregate: " + td);
            }
            for (HMapSpec.TransformDef td : this.mToPromote) {
                out.println(indent + "mToPromote: " + td);
            }
            for (InputStep subStep : this.mSubSteps) {
                subStep.toExecutionPlan(indent + "    ", out);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.mLevel + ":" + AvroMapTransformer.this.mOut.getRootHExpr().getFullyQualifiedName() + "}";
        }
    }
}

