/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.SpecException;
import org.talend.bigdata.dataflow.functions.FlatMapper;
import org.talend.bigdata.dataflow.hexpr.AvroGetter;
import org.talend.bigdata.dataflow.hexpr.AvroSetter;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hexpr.HExprUtil;
import org.talend.bigdata.dataflow.hmap.AvroMapTransformer;
import org.talend.bigdata.dataflow.hmap.HMapContextConfigurable;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.hmap.aggregate.AggregateOp;
import org.talend.bigdata.dataflow.hmap.filter.Condition;
import org.talend.bigdata.dataflow.serializer.KryoAvroRecordSerializer;

public class HMapSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_KEY_PREFIX = "key";
    private static final String FLATTEN_FIELD_ARRAY = "X";
    private static final int JOIN_KEY_SIZE_NOJOIN = -2;
    private static final int JOIN_KEY_SIZE_UNKNOWN = -1;
    private final List<InputDef> mInputs = new ArrayList<InputDef>();
    private final Set<InputDef> mInputsPull = new HashSet<InputDef>();
    private final Map<String, InputDef> mInputsByTag = new HashMap<String, InputDef>();
    private final List<OutputDef> mOutputs = new ArrayList<OutputDef>();
    private final List<OutputDef>[] mOutputsByType = new List[OutputType.values().length];
    private final Map<String, OutputDef> mOutputsByTag = new HashMap<String, OutputDef>();
    private final ArrayList<TransformDef> mTransformDefs = new ArrayList();
    private final HashMap<String, ArrayList<FilterDef>> mFilters = new HashMap();
    private int mJoinKeySize = -2;
    private boolean shouldBroadcastDataset = false;
    private transient HMapSpecCompiled mCompiled = new HMapSpecCompiled();

    HMapSpec() {
    }

    HMapSpec build() throws SpecException {
        for (InputDef in : this.mInputs) {
            if (this.isUsed((HExpr)this.mCompiled.mHExprRoot.get(in.getTag()))) continue;
            throw new SpecException("The input '" + in + "' is unused.");
        }
        for (OutputDef out : this.mOutputs) {
            if (this.isUsed((HExpr)this.mCompiled.mHExprRoot.get(out.getTag()))) continue;
            throw new SpecException("The output '" + out + "' is unused.");
        }
        if (this.getFirstInputNonPull() == null || this.mOutputs.isEmpty()) {
            throw new SpecException("At least one input and output needs to be declared.");
        }
        if (!this.isTransform()) {
            if (this.mJoinKeySize == -1) {
                throw new SpecException("The join key size can't be deduced and must be explicitly specified.");
            }
            for (InputDef in : this.getInputs()) {
                if (in.getJoin() != null) continue;
                throw new SpecException("The join key for '" + in + "' must be specified.");
            }
        }
        this.mCompiled.build();
        return this;
    }

    private void readObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        inStream.defaultReadObject();
        try {
            this.mCompiled = new HMapSpecCompiled();
            for (InputDef inputDef : this.mInputs) {
                inputDef.deserialize();
            }
            for (OutputDef outputDef : this.mOutputs) {
                outputDef.deserialize();
            }
            for (TransformDef transformDef : this.mTransformDefs) {
                this.transformDeserialize(transformDef);
            }
            for (Map.Entry entry : this.mFilters.entrySet()) {
                for (FilterDef fd : (ArrayList)entry.getValue()) {
                    this.filterDeserialize((String)entry.getKey(), fd);
                }
            }
            this.mCompiled.build();
        }
        catch (SpecException e) {
            throw new RuntimeException(e);
        }
    }

    void declareInput(String tag, Schema s, FlatMapper<? super IndexedRecord, ? extends IndexedRecord> pullSource) throws SpecException {
        if (this.getInput(tag) != null) {
            throw new SpecException("The input for the HMapSpec '" + tag + "' has already been specified.");
        }
        if (this.getOutput(tag) != null) {
            throw new SpecException("The input for the HMapSpec '" + tag + "' has already been specified as an output.");
        }
        int order = this.mInputs.size();
        InputDef in = new InputDef(tag, order, s, pullSource);
        this.mInputs.add(in);
        if (in.isPull()) {
            this.mInputsPull.add(in);
        }
        this.mInputsByTag.put(tag, in);
        in.deserialize();
    }

    void declareOutput(String tag, Schema s, OutputType ... outTypes) throws SpecException {
        OutputType[] outputTypeArray;
        if (this.getOutput(tag) != null) {
            throw new SpecException("The output for the HMapSpec '" + tag + "' has already been specified.");
        }
        if (this.getInput(tag) != null) {
            throw new SpecException("The output for the HMapSpec '" + tag + "' has already been specified as an input.");
        }
        if (outTypes.length == 0) {
            OutputType[] outputTypeArray2 = new OutputType[1];
            outputTypeArray = outputTypeArray2;
            outputTypeArray2[0] = OutputType.NORMAL;
        } else {
            outputTypeArray = outTypes;
        }
        OutputType[] actualOutputTypes = outputTypeArray;
        Schema actualSchema = s;
        if (Arrays.asList(actualOutputTypes).contains((Object)OutputType.FLATTEN)) {
            OutputType[] outputTypeArray3;
            if (actualOutputTypes.length == 1) {
                OutputType[] outputTypeArray4 = new OutputType[2];
                outputTypeArray4[0] = OutputType.NORMAL;
                outputTypeArray3 = outputTypeArray4;
                outputTypeArray4[1] = OutputType.FLATTEN;
            } else {
                outputTypeArray3 = actualOutputTypes;
            }
            actualOutputTypes = outputTypeArray3;
            actualSchema = Schema.createRecord((String)FLATTEN_FIELD_ARRAY, null, null, (boolean)false);
            actualSchema.setFields(Arrays.asList(new Schema.Field(FLATTEN_FIELD_ARRAY, Schema.createArray((Schema)s), null, null)));
        }
        int order = this.mOutputs.size();
        OutputDef out = new OutputDef(tag, order, actualSchema, actualOutputTypes);
        this.mOutputs.add(out);
        this.mOutputsByTag.put(tag, out);
        for (OutputType outType : actualOutputTypes) {
            List<OutputDef> outputTags = this.mOutputsByType[outType.ordinal()];
            if (outputTags == null) {
                this.mOutputsByType[outType.ordinal()] = outputTags = new ArrayList<OutputDef>();
            }
            outputTags.add(out);
        }
        out.deserialize();
    }

    void unionOutputs(String toOutTag, String ... fromOutTags) throws SpecException {
        OutputDef toOut = this.getOutput(toOutTag);
        if (toOut == null) {
            throw new SpecException("The union destination has not been declared: " + toOutTag);
        }
        if (toOut.getRedirect() != toOut) {
            throw new SpecException("The union destination has already been redirected elsewhere: " + toOutTag + " -> " + toOut.getRedirect().getTag());
        }
        Schema toSchema = toOut.getSchema();
        for (String fromOutTag : fromOutTags) {
            OutputDef fromOut = this.getOutput(fromOutTag);
            if (fromOut == null) {
                throw new SpecException("The union source has not been declared: " + fromOutTag);
            }
            if (!fromOut.getSchema().equals((Object)toSchema)) {
                throw new SpecException("Incompatible schema: " + toOutTag + " != " + fromOutTag);
            }
            fromOut.setRedirect(toOut);
        }
    }

    void postProcess(String outTag, PostProcessor<?> pp) throws SpecException {
        OutputDef out = this.getOutput(outTag);
        if (out == null) {
            throw new SpecException("The output source has not been declared: " + outTag);
        }
        if (out.getPostProcessor() != null) {
            throw new SpecException("At most one post processor is permitted: " + outTag);
        }
        out.setPostProcessor(pp);
    }

    void mapAll(String input, String output) throws SpecException {
        InputDef in = this.getInput(HExpr.getTag(input));
        if (in == null) {
            throw new SpecException("The input source has not been declared: " + input);
        }
        OutputDef out = this.getOutput(HExpr.getTag(output));
        if (out == null) {
            throw new SpecException("The output source has not been declared: " + output);
        }
        AvroGetter getter = in.getGetter();
        int inTagSize = input.length();
        HashSet<String> inAccessors = new HashSet<String>();
        for (HExpr hexpr : getter) {
            if (!hexpr.isPrimitive()) continue;
            inAccessors.add(hexpr.getFullyQualifiedName().substring(inTagSize));
        }
        AvroSetter setter = out.getSetter();
        int outTagSize = output.length();
        for (HExpr hexpr : setter) {
            String suffix;
            if (!hexpr.isPrimitive() || !inAccessors.contains(suffix = hexpr.getFullyQualifiedName().substring(outTagSize))) continue;
            this.transform(new TransformDef(input + suffix, output + suffix, null));
        }
    }

    void transform(TransformDef td) throws SpecException {
        this.mTransformDefs.add(td);
        this.transformDeserialize(td);
    }

    private void transformDeserialize(TransformDef td) throws SpecException {
        String inTag = HExpr.getTag(td.mInAccessor);
        InputDef in = this.getInput(inTag);
        if (in == null) {
            throw new SpecException("The input source has not been declared: " + inTag + "/" + td.mInAccessor);
        }
        HExpr inHExpr = in.getGetter().getHExpr(td.mInAccessor);
        if (inHExpr == null) {
            throw new SpecException("Invalid input accessor: " + inTag + "/" + td.mInAccessor);
        }
        if (!td.mHintOnly && !inHExpr.isPrimitive()) {
            throw new SpecException("Input accessor not a primitive: " + inTag + "/" + td.mInAccessor);
        }
        this.mCompiled.setAsUsed(inHExpr);
        td.mInput = inHExpr;
        String outTag = HExpr.getTag(td.mOutAccessor);
        OutputDef out = this.getOutput(outTag);
        if (out == null) {
            throw new SpecException("The output source has not been declared: " + outTag + "/" + td.mOutAccessor);
        }
        HExpr outHExpr = out.getSetter().getHExpr(td.mOutAccessor);
        if (outHExpr == null && this.getOutput(outTag).isFlattened()) {
            String outAccessor = outTag + '.' + FLATTEN_FIELD_ARRAY + td.mOutAccessor.substring(outTag.length());
            outHExpr = out.getSetter().getHExpr(outAccessor);
        }
        if (outHExpr == null) {
            throw new SpecException("Invalid output accessor: " + outTag + "/" + td.mOutAccessor);
        }
        if (!td.mHintOnly && !outHExpr.isPrimitive()) {
            throw new SpecException("Output accessor not a primitive: " + outTag + "/" + td.mOutAccessor);
        }
        this.mCompiled.setAsUsed(outHExpr);
        td.mOutput = outHExpr;
        AvroMapTransformer amt = in.getOrCreateTransformer(out);
        amt.addTransform(td);
    }

    void filter(FilterDef fd) throws SpecException {
        String tag = HExpr.getTag(fd.mAccessor);
        ArrayList<FilterDef> fdList = this.mFilters.get(tag);
        if (fdList == null) {
            fdList = new ArrayList();
            this.mFilters.put(tag, fdList);
        }
        fdList.add(fd);
        this.filterDeserialize(tag, fd);
    }

    private void filterDeserialize(String tag, FilterDef fd) throws SpecException {
        OutputDef out;
        HExpr expr = null;
        InputDef in = this.getInput(tag);
        expr = in != null ? in.getGetter().getHExpr(fd.mAccessor) : ((out = this.getOutput(tag)) != null ? out.getSetter().getHExpr(fd.mAccessor) : null);
        if (expr == null) {
            throw new SpecException("Invalid filter accessor: " + tag + "/" + fd.mAccessor);
        }
        if (fd.mCondition instanceof HMapContextConfigurable) {
            ((HMapContextConfigurable)((Object)fd.mCondition)).setHMapContext(this);
        }
        fd.mExpr = expr;
        this.mCompiled.setAsUsed(expr);
    }

    void joinKeySize(int size) throws SpecException {
        if (this.mJoinKeySize != -2 && this.mJoinKeySize != -1 && size != this.mJoinKeySize) {
            throw new SpecException("Incompatible join key size:" + size + " != " + this.mJoinKeySize);
        }
        this.mJoinKeySize = size;
    }

    void shouldBroadcastDataset(boolean condition) {
        this.shouldBroadcastDataset = condition;
    }

    void joinKey(JoinDef jd, PostProcessor<? extends IndexedRecord> joinKeyProcessor) throws SpecException {
        InputDef in = this.getInput(jd.mInTag);
        if (in == null) {
            throw new SpecException("The input source has not been declared: " + jd.mInTag + ".");
        }
        if (in.getJoin() != null) {
            throw new SpecException("The joinKey for '" + in.getTag() + "' has already been specified.");
        }
        if (joinKeyProcessor != null) {
            if (0 != jd.mAccessors.length) {
                throw new SpecException("Join key size with a join key processor " + in.getTag() + " must be zero.");
            }
        } else if (this.mInputsPull.contains(in)) {
            if (JoinType.MAIN == jd.mType) {
                throw new SpecException("Join type for pull input " + in.getTag() + " must not be " + (Object)((Object)JoinType.MAIN));
            }
            if (0 != jd.mAccessors.length) {
                throw new SpecException("Join key size for pull input " + in.getTag() + " must be zero.");
            }
        } else if (this.mJoinKeySize == -2 || this.mJoinKeySize == -1) {
            this.mJoinKeySize = jd.mAccessors.length;
        } else if (this.mJoinKeySize != jd.mAccessors.length) {
            throw new SpecException("Incompatible join key size for " + in.getTag() + ": " + jd.mAccessors.length + " != " + this.mJoinKeySize);
        }
        jd.setJoinKeyProcessor(this, joinKeyProcessor);
        in.setJoin(jd);
        jd.deserialize(this);
    }

    public Boolean shouldBroadcastCondition() {
        return this.shouldBroadcastDataset;
    }

    public Iterable<InputDef> getInputs() {
        return this.mInputs;
    }

    public Iterable<InputDef> getInputsPull() {
        return this.mInputsPull;
    }

    public int getInputSize() {
        return this.mInputsByTag.size();
    }

    public Iterable<OutputDef> getOutputs() {
        return this.mOutputs;
    }

    public Iterable<OutputDef> getOutputs(OutputType outType) {
        List<OutputDef> outputs = this.mOutputsByType[outType.ordinal()];
        if (outputs == null) {
            return Collections.emptyList();
        }
        return outputs;
    }

    public InputDef getFirstInputNonPull() {
        for (InputDef in : this.mInputs) {
            if (in.isPull()) continue;
            return in;
        }
        return null;
    }

    public InputDef getFirstInputMain() {
        for (InputDef in : this.mInputs) {
            if (!in.isMain()) continue;
            return in;
        }
        return null;
    }

    public InputDef getFirstInputLookup() {
        for (InputDef in : this.mInputs) {
            if (!in.isLookup()) continue;
            return in;
        }
        return null;
    }

    public InputDef getInput(int inOrder) {
        return this.mInputs.get(inOrder);
    }

    public InputDef getInput(String inTag) {
        return this.mInputsByTag.get(inTag);
    }

    public OutputDef getOutput(int outOrder) {
        return this.mOutputs.get(outOrder);
    }

    public OutputDef getOutput(String outTag) {
        return this.mOutputsByTag.get(outTag);
    }

    public boolean isMultiOutput() {
        return this.mOutputs.size() > 1;
    }

    public Integer getInputOrder(String inTag) {
        return this.mInputsByTag.get(inTag).getOrder();
    }

    public Integer getOutputOrder(String outTag) {
        return this.mOutputsByTag.get(outTag).getOrder();
    }

    public <X extends IndexedRecord> X getInputRecord(String tag) {
        InputDef in = this.getInput(tag);
        return (X)(in == null ? null : in.getGetter().getRootValue());
    }

    public <X extends IndexedRecord> X getOutputRecord(String tag) {
        OutputDef out = this.getOutput(tag);
        return (X)(out == null ? null : out.getSetter().getRootValue());
    }

    public AvroMapTransformer getTransformer(String inTag, String outTag) {
        return this.getInput(inTag).getTransformer(this.getOutput(outTag));
    }

    boolean isTransform() {
        return this.mJoinKeySize == -2;
    }

    public int getJoinKeySize() {
        return this.mJoinKeySize;
    }

    public Schema getJoinKeySchema() {
        return this.mCompiled.mJoinKeySchema;
    }

    private List<FilterDef> getFilters(String tag) {
        if (this.mFilters.containsKey(tag)) {
            return this.mFilters.get(tag);
        }
        return Collections.emptyList();
    }

    private boolean isUsed(HExpr expr) {
        return this.mCompiled.mUsed.contains(expr);
    }

    class HMapSpecCompiled {
        private final HashSet<HExpr> mUsed = new HashSet();
        private final HashMap<String, HExpr> mHExprRoot = new HashMap();
        private Schema mJoinKeySchema = null;

        HMapSpecCompiled() {
        }

        void setAsUsed(HExpr usedHExpr) {
            for (HExpr used = usedHExpr; used != null && !this.mUsed.contains(used); used = used.getParent()) {
                this.mUsed.add(used);
            }
        }

        void build() throws SpecException {
            if (!HMapSpec.this.isTransform()) {
                InputDef in;
                HExpr[] hexpr = null;
                Iterator<InputDef> iterator = HMapSpec.this.getInputs().iterator();
                while (iterator.hasNext() && (hexpr = (in = iterator.next()).getJoin().getKeys()).length != HMapSpec.this.mJoinKeySize) {
                    hexpr = null;
                }
                this.mJoinKeySchema = hexpr == null ? HExprUtil.createGenericStringRecordSchema(HMapSpec.FIELD_KEY_PREFIX, HMapSpec.this.mJoinKeySize) : HExprUtil.createRecordSchema(HMapSpec.FIELD_KEY_PREFIX, hexpr);
                KryoAvroRecordSerializer.registerSchema(this.mJoinKeySchema);
            }
            for (InputDef in : HMapSpec.this.getInputs()) {
                for (OutputDef out : HMapSpec.this.getOutputs()) {
                    AvroMapTransformer amt = in.getTransformer(out);
                    if (amt == null) continue;
                    amt.build();
                }
            }
        }
    }

    public static class JoinDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String mInTag;
        private final JoinType mType;
        private final JoinMatchType mMatchType;
        private final String[] mAccessors;
        private PostProcessor<? extends IndexedRecord> mJoinKeyProcessor;
        private transient HExpr[] mKeys;

        JoinDef(String inTag, JoinType joinType, JoinMatchType matchType, String[] accessors) {
            this.mInTag = inTag;
            this.mType = joinType;
            this.mMatchType = matchType;
            this.mAccessors = accessors;
        }

        public HExpr[] getKeys() {
            return this.mKeys;
        }

        public JoinType getJoinType() {
            return this.mType;
        }

        public JoinMatchType getJoinMatchType() {
            return this.mMatchType;
        }

        public String toString() {
            return "JoinDef " + this.mInTag + " " + (Object)((Object)this.mType) + ":" + (Object)((Object)this.mMatchType) + " -> " + this.mKeys.length;
        }

        public PostProcessor<? extends IndexedRecord> getJoinKeyProcessor() {
            return this.mJoinKeyProcessor;
        }

        private void setJoinKeyProcessor(HMapSpec spec, PostProcessor<? extends IndexedRecord> joinKeyProcessor) {
            this.mJoinKeyProcessor = joinKeyProcessor;
            if (this.mJoinKeyProcessor != null && this.mJoinKeyProcessor instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mJoinKeyProcessor)).setHMapContext(spec);
            }
        }

        private void deserialize(HMapSpec spec) throws SpecException {
            InputDef in = spec.getInput(this.mInTag);
            if (in == null) {
                throw new SpecException("The input source has not been declared: " + this.mInTag);
            }
            spec.mCompiled.setAsUsed(in.mGetter.getRootHExpr());
            HExpr[] joinHExpr = new HExpr[this.mAccessors.length];
            for (int i = 0; i < this.mAccessors.length; ++i) {
                joinHExpr[i] = in.getGetter().getHExpr(this.mAccessors[i]);
                if (joinHExpr[i] == null) {
                    throw new SpecException("Invalid input accessor: " + this.mAccessors[i]);
                }
                if (!joinHExpr[i].isPrimitive()) {
                    throw new SpecException("Input accessor not a primitive: " + this.mAccessors[i]);
                }
                spec.mCompiled.setAsUsed(joinHExpr[i]);
            }
            this.mKeys = joinHExpr;
            if (this.mJoinKeyProcessor != null && this.mJoinKeyProcessor instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mJoinKeyProcessor)).setHMapContext(spec);
            }
        }
    }

    public static class FilterDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String mAccessor;
        private final Condition<?> mCondition;
        private transient HExpr mExpr;

        public FilterDef(String accessor, Condition<? extends IndexedRecord> condition) {
            this.mAccessor = accessor;
            this.mCondition = condition;
        }

        public <RECORD extends IndexedRecord> Condition<RECORD> getCondition() {
            return this.mCondition;
        }

        public String toString() {
            return "FilterDef " + this.mExpr + " -> " + this.mCondition;
        }
    }

    static class TransformDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String mInAccessor;
        private final String mOutAccessor;
        final AggregateOp mOp;
        final boolean mHintOnly;
        transient HExpr mInput;
        transient HExpr mOutput;

        TransformDef(String input, String output, AggregateOp op) {
            this.mInAccessor = input;
            this.mOutAccessor = output;
            this.mOp = op;
            this.mHintOnly = false;
        }

        public TransformDef(String input, String output, boolean hintOnly) {
            this.mInAccessor = input;
            this.mOutAccessor = output;
            this.mOp = null;
            this.mHintOnly = hintOnly;
        }

        public String toString() {
            return "TransformDef " + this.mInAccessor + " -> " + this.mOutAccessor + (this.mOp != null ? " " + (Object)((Object)this.mOp) : "");
        }
    }

    public class OutputDef
    extends AbstractInputOutputDef {
        private static final long serialVersionUID = 1L;
        private final OutputType[] mOutTypes;
        private final boolean mIsFlattened;
        private PostProcessor<? extends IndexedRecord> mPostProcessor;
        private int mRedirectOrder;
        private transient OutputDef mRedirect;
        private transient AvroSetter mSetter;

        private OutputDef(String tag, int inOrder, Schema schema, OutputType[] outTypes) {
            super(tag, inOrder, schema);
            this.mRedirectOrder = -1;
            this.mOutTypes = outTypes;
            boolean isFlattened = false;
            for (OutputType ot : outTypes) {
                if (!ot.equals((Object)OutputType.FLATTEN)) continue;
                isFlattened = true;
                break;
            }
            this.mIsFlattened = isFlattened;
        }

        public OutputDef getRedirect() {
            return this.mRedirect != null ? this.mRedirect : this;
        }

        public boolean isFlattened() {
            return this.mIsFlattened;
        }

        public PostProcessor<? extends IndexedRecord> getPostProcessor() {
            return this.mPostProcessor;
        }

        public AvroSetter getSetter() {
            return this.mSetter;
        }

        private OutputType[] getOutTypes() {
            return this.mOutTypes;
        }

        private void setPostProcessor(PostProcessor<?> pp) {
            this.mPostProcessor = pp;
            if (this.mPostProcessor != null && this.mPostProcessor instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mPostProcessor)).setHMapContext(HMapSpec.this);
            }
        }

        private void setRedirect(OutputDef redirect) {
            this.mRedirectOrder = redirect.getOrder();
            this.mRedirect = redirect;
        }

        private void deserialize() throws SpecException {
            this.mSetter = new AvroSetter(this.getTag(), this.getSchema());
            HMapSpec.this.mCompiled.mHExprRoot.put(this.getTag(), this.mSetter.getRootHExpr());
            if (this.mRedirectOrder != -1) {
                this.mRedirect = HMapSpec.this.getOutput(this.mRedirectOrder);
            }
            KryoAvroRecordSerializer.registerSchema(this.getSchema());
            if (this.mPostProcessor != null && this.mPostProcessor instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mPostProcessor)).setHMapContext(HMapSpec.this);
            }
        }
    }

    public class InputDef
    extends AbstractInputOutputDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FlatMapper<? super IndexedRecord, ? extends IndexedRecord> mPullSource;
        private JoinDef mJoin;
        private transient AvroGetter mGetter;
        private transient Map<OutputDef, AvroMapTransformer> mTransformersByOutput;
        private transient List<AvroMapTransformer>[] mTransformersByType;

        private InputDef(String tag, int inOrder, Schema schema, FlatMapper<? super IndexedRecord, ? extends IndexedRecord> pullSource) {
            super(tag, inOrder, schema);
            this.mJoin = null;
            this.mPullSource = pullSource;
            if (this.mPullSource != null && this.mPullSource instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mPullSource)).setHMapContext(HMapSpec.this);
            }
        }

        public JoinDef getJoin() {
            return this.mJoin;
        }

        public boolean isMain() {
            return this.mJoin != null && this.mJoin.getJoinType() == JoinType.MAIN;
        }

        public boolean isLookup() {
            return !this.isPull() && !this.isMain();
        }

        public boolean isPull() {
            return this.mPullSource != null;
        }

        public FlatMapper<? super IndexedRecord, ? extends IndexedRecord> getPullSource() {
            return this.mPullSource;
        }

        public AvroGetter getGetter() {
            return this.mGetter;
        }

        private void setJoin(JoinDef jd) {
            this.mJoin = jd;
        }

        private AvroMapTransformer getOrCreateTransformer(OutputDef out) {
            AvroMapTransformer amt;
            if (this.mTransformersByOutput == null) {
                this.mTransformersByOutput = new HashMap<OutputDef, AvroMapTransformer>();
            }
            if ((amt = this.mTransformersByOutput.get(out)) == null) {
                amt = new AvroMapTransformer(this.getGetter(), out.getSetter());
                this.mTransformersByOutput.put(out, amt);
                if (this.mTransformersByType == null) {
                    this.mTransformersByType = new List[OutputType.values().length];
                }
                for (OutputType outType : out.getOutTypes()) {
                    List<AvroMapTransformer> byType = this.mTransformersByType[outType.ordinal()];
                    if (byType == null) {
                        this.mTransformersByType[outType.ordinal()] = byType = new ArrayList<AvroMapTransformer>();
                    }
                    byType.add(amt);
                }
            }
            return amt;
        }

        private AvroMapTransformer getTransformer(OutputDef out) {
            if (this.mTransformersByOutput == null) {
                return null;
            }
            return this.mTransformersByOutput.get(out);
        }

        Iterable<AvroMapTransformer> getTransformers(OutputType outType) {
            if (this.mTransformersByType == null) {
                return Collections.emptyList();
            }
            List<AvroMapTransformer> byType = this.mTransformersByType[outType.ordinal()];
            if (byType == null) {
                return Collections.emptyList();
            }
            return byType;
        }

        private void deserialize() throws SpecException {
            this.mGetter = new AvroGetter(this.getTag(), this.getSchema());
            HMapSpec.this.mCompiled.mHExprRoot.put(this.getTag(), this.mGetter.getRootHExpr());
            KryoAvroRecordSerializer.registerSchema(this.getSchema());
            if (this.mJoin != null) {
                this.mJoin.deserialize(HMapSpec.this);
            }
            if (this.mPullSource != null && this.mPullSource instanceof HMapContextConfigurable) {
                ((HMapContextConfigurable)((Object)this.mPullSource)).setHMapContext(HMapSpec.this);
            }
        }
    }

    protected abstract class AbstractInputOutputDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String mTag;
        private final int mOrder;
        private final String mJsSchema;
        private transient Schema mSchema;

        private AbstractInputOutputDef(String tag, int inOrder, Schema schema) {
            this.mTag = tag;
            this.mOrder = inOrder;
            this.mJsSchema = schema.toString();
            this.mSchema = schema;
        }

        public String getTag() {
            return this.mTag;
        }

        public int getOrder() {
            return this.mOrder;
        }

        public FilterDef getFilter(int i) {
            return (FilterDef)HMapSpec.this.getFilters(this.getTag()).get(i);
        }

        public int getFilterSize() {
            return HMapSpec.this.getFilters(this.getTag()).size();
        }

        public String getJsSchema() {
            return this.mJsSchema;
        }

        public Schema getSchema() {
            if (this.mSchema == null) {
                this.mSchema = new Schema.Parser().parse(this.mJsSchema);
            }
            return this.mSchema;
        }

        public <RECORD extends IndexedRecord> boolean isKeptAfterFilters(RECORD record) {
            for (FilterDef fd : HMapSpec.this.getFilters(this.getTag())) {
                if (fd.getCondition().evaluate(record)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.mTag;
        }
    }

    public static enum OutputType {
        NORMAL,
        FLATTEN,
        REJECT_FILTERS,
        REJECT_INNER,
        REJECT_EXCEPTION;

    }

    public static enum JoinMatchType {
        ALL,
        UNIQUE;

    }

    public static enum JoinType {
        MAIN,
        INNER,
        LEFT_OUTER,
        NESTED;

    }
}

