/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.Builder;
import org.talend.bigdata.dataflow.SpecException;
import org.talend.bigdata.dataflow.functions.FlatMapper;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.hmap.aggregate.AggregateOp;
import org.talend.bigdata.dataflow.hmap.filter.Condition;

public class HMapSpecBuilder
implements Builder<HMapSpec, SpecException> {
    private final HMapSpec mSpec = new HMapSpec();

    public HMapSpecBuilder declareInput(String tag, Schema s) throws SpecException {
        this.mSpec.declareInput(tag, s, null);
        return this;
    }

    public HMapSpecBuilder declareInputPull(String tag, Schema s, FlatMapper<? super IndexedRecord, ? extends IndexedRecord> m) throws SpecException {
        this.mSpec.declareInput(tag, s, m);
        return this;
    }

    public HMapSpecBuilder declareInputPull(String tag, Schema s) throws SpecException {
        this.mSpec.declareInput(tag, s, null);
        return this;
    }

    public HMapSpecBuilder declareOutput(String tag, Schema s, HMapSpec.OutputType ... outTypes) throws SpecException {
        this.mSpec.declareOutput(tag, s, outTypes);
        return this;
    }

    public HMapSpecBuilder unionOutputs(String toOutTag, String ... fromOutTags) throws SpecException {
        this.mSpec.unionOutputs(toOutTag, fromOutTags);
        return this;
    }

    public HMapSpecBuilder postProcess(String outTag, PostProcessor<?> pp) throws SpecException {
        this.mSpec.postProcess(outTag, pp);
        return this;
    }

    public HMapSpecBuilder map(String input, String output) throws SpecException {
        this.mSpec.transform(new HMapSpec.TransformDef(input, output, null));
        return this;
    }

    public HMapSpecBuilder mapHint(String input, String output) throws SpecException {
        this.mSpec.transform(new HMapSpec.TransformDef(input, output, true));
        return this;
    }

    public HMapSpecBuilder mapAll(String input, String output) throws SpecException {
        this.mSpec.mapAll(input, output);
        return this;
    }

    public HMapSpecBuilder aggregate(String input, String output, AggregateOp op) throws SpecException {
        this.mSpec.transform(new HMapSpec.TransformDef(input, output, op));
        return this;
    }

    public HMapSpecBuilder filter(String expr, Condition<?> condition) throws SpecException {
        this.mSpec.filter(new HMapSpec.FilterDef(expr, condition));
        return this;
    }

    public HMapSpecBuilder joinKeySize(int size) throws SpecException {
        this.mSpec.joinKeySize(size);
        return this;
    }

    public HMapSpecBuilder broadcast(Boolean shouldBroadcast) throws SpecException {
        this.mSpec.shouldBroadcastDataset(shouldBroadcast);
        return this;
    }

    public HMapSpecBuilder joinKey(String inTag, HMapSpec.JoinType joinType, HMapSpec.JoinMatchType matchType, String ... accessors) throws SpecException {
        this.mSpec.joinKey(new HMapSpec.JoinDef(inTag, joinType, matchType, accessors), null);
        return this;
    }

    public HMapSpecBuilder joinKey(String inTag, HMapSpec.JoinType joinType, HMapSpec.JoinMatchType matchType, PostProcessor<?> pp) throws SpecException {
        this.mSpec.joinKey(new HMapSpec.JoinDef(inTag, joinType, matchType, new String[0]), pp);
        return this;
    }

    @Override
    public HMapSpec build() throws SpecException {
        return this.mSpec.build();
    }
}

