/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap.filter.impl;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.hexpr.AvroGetter;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.filter.Condition;
import org.talend.bigdata.dataflow.hmap.filter.WithAvroGetter;
import org.talend.bigdata.dataflow.hmap.filter.WithChildConditions;

public class HExprLoopAny<RECORD extends IndexedRecord>
implements Condition<RECORD>,
WithChildConditions<RECORD>,
WithAvroGetter {
    private static final long serialVersionUID = 1L;
    private final String mExprLoop;
    private final Condition<RECORD> mCondition;
    private transient AvroGetter mGetter;
    private transient HExpr mHExprLoop;

    public HExprLoopAny(String exprLoop, Condition<RECORD> condition) {
        this.mExprLoop = exprLoop;
        this.mCondition = condition;
    }

    @Override
    public boolean evaluate(RECORD record) {
        if (this.mGetter == null) {
            HExprLoopAny.setAvroGetterOnAllChildConditions(this, new AvroGetter("X", record.getSchema()));
        }
        if (this.mHExprLoop == null) {
            this.mHExprLoop = this.mGetter.getHExpr(this.mGetter.getRootHExpr().getName() + '.' + this.mExprLoop);
        }
        if (this.mGetter.getRootValue() != record) {
            this.mGetter.setRootValue((IndexedRecord)record);
        }
        while (this.mGetter.hasNext(this.mHExprLoop)) {
            this.mGetter.next(this.mHExprLoop);
            if (!this.mCondition.evaluate(record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Condition<RECORD>> getChildConditions() {
        return Arrays.asList(this.mCondition).iterator();
    }

    @Override
    public AvroGetter getAvroGetter() {
        return this.mGetter;
    }

    @Override
    public void setAvroGetter(AvroGetter getter) {
        this.mGetter = getter;
    }

    public static void setAvroGetterOnAllChildConditions(Object toSet, AvroGetter getter) {
        if (toSet instanceof WithAvroGetter) {
            ((WithAvroGetter)toSet).setAvroGetter(getter);
        }
        if (toSet instanceof WithChildConditions) {
            Iterator i = ((WithChildConditions)toSet).getChildConditions();
            while (i.hasNext()) {
                HExprLoopAny.setAvroGetterOnAllChildConditions(i.next(), getter);
            }
        }
    }
}

