/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.io;

import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.DataFlowBuilder;
import org.talend.bigdata.dataflow.io.IoSpec;

public class IoDataFlowBuilder
extends DataFlowBuilder {
    private final IoSpec mSpec;

    public IoDataFlowBuilder(IoSpec spec) {
        this.mSpec = spec;
    }

    @Override
    public void build(DataFlow<?> df) {
        DataFlowBuilder.DataFlowWithSpecBuilder backend = null;
        String className = null;
        if (df.getClass().getSimpleName().startsWith("Cascading")) {
            className = "org.talend.bigdata.dataflow.cascading.io.CascadingIoDataFlowBuilder";
        } else if (df.getClass().getSimpleName().startsWith("SparkBatch")) {
            className = "org.talend.bigdata.dataflow.spark.batch.io.SparkIoDataFlowBuilder";
        } else if (df.getClass().getSimpleName().startsWith("SparkStreaming")) {
            className = "org.talend.bigdata.dataflow.spark.streaming.io.SparkIoDataFlowBuilder";
        } else if (df.getClass().getSimpleName().startsWith("Di")) {
            className = "org.talend.bigdata.dataflow.di.io.DiIoDataFlowBuilder";
        } else {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support data flows of type " + df.getClass().getSimpleName());
        }
        try {
            Class<?> c = Class.forName(className);
            backend = (DataFlowBuilder.DataFlowWithSpecBuilder)c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
            throw new RuntimeException("Cannot instantiate " + className, e);
        }
        backend.build(df, this.mSpec);
    }
}

