/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.io;

import java.io.Serializable;
import org.apache.avro.Schema;

public class IoSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String mTag;
    private transient Schema mSchema;
    private final String mJsSchema;
    private final String mPath;
    private final String mFieldDelimiter;
    private final String mLineDelimiter;
    private final boolean mIsInput;

    IoSpec(String tag, Schema s, String path, String fieldDelimiter, String lineDelimiter, boolean isInput) {
        this.mTag = tag;
        this.mSchema = s;
        this.mJsSchema = s.toString();
        this.mPath = path;
        this.mFieldDelimiter = fieldDelimiter;
        this.mLineDelimiter = lineDelimiter;
        this.mIsInput = isInput;
    }

    IoSpec(String tag, Schema s, String path, boolean isInput) {
        this(tag, s, path, null, null, isInput);
    }

    public String getTag() {
        return this.mTag;
    }

    public Schema getSchema() {
        if (this.mSchema == null) {
            this.mSchema = new Schema.Parser().parse(this.mJsSchema);
        }
        return this.mSchema;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getFieldDelimiter() {
        return this.mFieldDelimiter;
    }

    public String getLineDelimiter() {
        return this.mLineDelimiter;
    }

    public boolean isInput() {
        return this.mIsInput;
    }
}

