/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.serializer;

import org.apache.avro.Schema;

public class AvroCoercionHelper {
    public static Object coerce(Schema schema, String value) {
        Object result = null;
        switch (schema.getType()) {
            case BOOLEAN: {
                result = Boolean.parseBoolean(value);
                break;
            }
            case DOUBLE: {
                result = Double.parseDouble(value);
                break;
            }
            case FLOAT: {
                result = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case INT: {
                result = Integer.parseInt(value);
                break;
            }
            case LONG: {
                result = Long.parseLong(value);
                break;
            }
            case STRING: {
                result = value;
                break;
            }
            case UNION: {
                if (value == null) break;
                for (Schema type : schema.getTypes()) {
                    if (type.getType().equals((Object)Schema.Type.NULL)) continue;
                    result = AvroCoercionHelper.coerce(type, value);
                }
                break;
            }
        }
        return result;
    }

    public static Object coerce(String type, String value) {
        return AvroCoercionHelper.coerce(Schema.create((Schema.Type)Schema.Type.valueOf((String)type.toUpperCase())), value);
    }
}

