/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class KryoAvroRecordSerializer
extends Serializer<GenericData.Record> {
    private BinaryEncoder encoder;
    private BinaryDecoder decoder;
    private static Map<Schema, Integer> sRegistrySchemaToKey = new HashMap<Schema, Integer>();
    private static Map<Integer, Schema> sRegistryKeyToSchema = new HashMap<Integer, Schema>();

    public static synchronized void registerSchema(Schema s) {
        if (!sRegistrySchemaToKey.containsKey(s)) {
            int count = sRegistryKeyToSchema.size();
            sRegistryKeyToSchema.put(count, s);
            sRegistrySchemaToKey.put(s, count);
        }
    }

    public static void registerIntoConfig(Properties props) {
        for (Map.Entry<Integer, Schema> entry : sRegistryKeyToSchema.entrySet()) {
            props.setProperty("org.talend.avro.schema." + entry.getKey(), entry.getValue().toString());
        }
    }

    public GenericData.Record read(Kryo kryo, Input input, Class<GenericData.Record> klazz) {
        GenericDatumReader reader = new GenericDatumReader(KryoAvroRecordSerializer.readSchema(input));
        this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)input, this.decoder);
        try {
            return (GenericData.Record)reader.read(null, (Decoder)this.decoder);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while deserializing Avro Record.", e);
        }
    }

    public void write(Kryo kryo, Output output, GenericData.Record record) {
        KryoAvroRecordSerializer.writeSchema(output, record.getSchema());
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)output, this.encoder);
        try {
            writer.write((Object)record, (Encoder)this.encoder);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while serializing Avro Record.", e);
        }
    }

    private static Schema readSchema(Input input) {
        return sRegistryKeyToSchema.get(input.readInt(true));
    }

    private static void writeSchema(Output output, Schema schema) {
        output.writeInt(sRegistrySchemaToKey.get(schema).intValue(), true);
    }
}

