/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark;

import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;
import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.DataFlowContext;
import org.talend.bigdata.dataflow.spark.common.MapToPairWithNullKeyFunction;
import org.talend.bigdata.dataflow.spark.common.SparkDataState;
import org.talend.bigdata.dataflow.spark.common.SparkTagParameters;

public abstract class SparkDataFlow<CONTEXT extends DataFlowContext>
implements DataFlow<CONTEXT> {
    protected final CONTEXT mContext;
    private final SparkDataState<JavaPairRDD<?, ? extends IndexedRecord>, JavaRDD<? extends IndexedRecord>> mRdds = new SparkDataState();
    private final SparkDataState<JavaPairRDD<?, ?>, JavaRDD<?>> mIntermediateRdds = new SparkDataState();
    private final SparkTagParameters mTagParameters = new SparkTagParameters();

    public SparkDataFlow(CONTEXT context) {
        this.mContext = context;
    }

    @Override
    public CONTEXT getContext() {
        return this.mContext;
    }

    public <T> T getParameter(String tag, String name, T defaultValue) {
        return this.mTagParameters.get(tag, name, defaultValue);
    }

    public void setParameter(String tag, String name, Object value) {
        this.mTagParameters.set(tag, name, value);
    }

    public void put(String tag, JavaRDDLike<?, ?> rddLike) {
        if (rddLike instanceof JavaRDD) {
            this.putRDD(tag, (JavaRDD)rddLike);
        } else {
            this.putPairRDD(tag, (JavaPairRDD)rddLike);
        }
    }

    public <K, V extends IndexedRecord> JavaPairRDD<K, V> getPairRDD(String pairTag) {
        return this.mRdds.getPairData(pairTag);
    }

    public void putPairRDD(String pairTag, JavaPairRDD<?, ? extends IndexedRecord> pairRdd) {
        if (pairRdd == null) {
            this.mRdds.putPairData(pairTag, null, null);
        } else {
            this.mRdds.putPairData(pairTag, pairRdd, (JavaRDD<? extends IndexedRecord>)pairRdd.values());
        }
    }

    public <V extends IndexedRecord> JavaRDD<V> getRDD(String tag) {
        return this.mRdds.getNonPairData(tag);
    }

    public <V extends IndexedRecord> void putRDD(String tag, JavaRDD<V> rdd) {
        if (rdd == null) {
            this.mRdds.putNonPairData(tag, null, null);
        } else {
            this.mRdds.putNonPairData(tag, rdd, rdd.mapToPair(new MapToPairWithNullKeyFunction()));
        }
    }

    public <K, V> JavaPairRDD<K, V> getIntermediatePairRDD(String pairTag) {
        return this.mIntermediateRdds.getPairData(pairTag);
    }

    public void putIntermediatePairRDD(String pairTag, JavaPairRDD<?, ?> pairRdd) {
        if (pairRdd == null) {
            this.mIntermediateRdds.putPairData(pairTag, null, null);
        } else {
            this.mIntermediateRdds.putPairData(pairTag, pairRdd, pairRdd.values());
        }
    }

    public <V> JavaRDD<V> getIntermediateRDD(String tag) {
        return this.mIntermediateRdds.getNonPairData(tag);
    }

    public <V> void putIntermediateRDD(String tag, JavaRDD<V> rdd) {
        if (rdd == null) {
            this.mIntermediateRdds.putNonPairData(tag, null, null);
        } else {
            this.mIntermediateRdds.putNonPairData(tag, rdd, rdd.mapToPair(new MapToPairWithNullKeyFunction()));
        }
    }
}

