/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.batch;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.talend.bigdata.dataflow.DataFlowContext;

public class SparkBatchDataFlowContext
implements DataFlowContext {
    private String mJobName;
    private JavaSparkContext mSparkContext;

    SparkBatchDataFlowContext(JavaSparkContext sparkContext, String jobName) {
        this.mSparkContext = sparkContext;
        this.mJobName = jobName;
    }

    @Override
    public String getJobName() {
        return this.mJobName;
    }

    public JavaSparkContext getSparkContext() {
        return this.mSparkContext;
    }

    public static class Builder {
        private JavaSparkContext mContext;
        private SparkConf mSparkConf = new SparkConf();
        private String mJobName;

        public Builder withJobName(String jobName) {
            this.mJobName = jobName;
            this.mSparkConf.setAppName(jobName);
            return this;
        }

        public Builder withMaster(String master) {
            this.mSparkConf.setMaster(master);
            return this;
        }

        public Builder withSparkContext(JavaSparkContext sparkContext) {
            this.mContext = sparkContext;
            return this;
        }

        public SparkBatchDataFlowContext build() {
            if (this.mContext == null) {
                this.mContext = this.buildNewSparkContext();
            }
            return new SparkBatchDataFlowContext(this.mContext, this.mJobName);
        }

        private JavaSparkContext buildNewSparkContext() {
            this.mSparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
            this.mSparkConf.set("spark.kryo.registrator", "org.talend.bigdata.dataflow.serializer.KryoAvroRegistrator");
            return new JavaSparkContext(this.mSparkConf);
        }
    }
}

