/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.batch.hmap;

import org.apache.spark.api.java.JavaPairRDD;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.spark.SparkDataFlow;
import org.talend.bigdata.dataflow.spark.common.hmap.Demultiplexor;
import org.talend.bigdata.dataflow.spark.common.hmap.MultiplexFilterPairValue;

public class SparkHMapStore<SDF extends SparkDataFlow<?>>
implements DataFlowPipelineBuilder.PipelinePartialBuilder<SDF, HMapSpec> {
    @Override
    public void build(SDF sdf, HMapSpec spec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        if (spec.isMultiOutput()) {
            JavaPairRDD inData = ((SparkDataFlow)sdf).getIntermediatePairRDD(incoming.iterator().next().getTag());
            JavaPairRDD filteredData = inData.filter(new MultiplexFilterPairValue((byte)spec.getOutputOrder(pa.getTag()).intValue()));
            JavaPairRDD outData = filteredData.mapValues(new Demultiplexor());
            ((SparkDataFlow)sdf).putIntermediatePairRDD(pa.getTag(), outData);
        } else {
            ((SparkDataFlow)sdf).putIntermediatePairRDD(pa.getTag(), ((SparkDataFlow)sdf).getIntermediatePairRDD(incoming.iterator().next().getTag()));
        }
        if (!((SparkDataFlow)sdf).getParameter(pa.getTag(), "retain_key", false).booleanValue()) {
            ((SparkDataFlow)sdf).putIntermediateRDD(pa.getTag(), ((SparkDataFlow)sdf).getIntermediateRDD(pa.getTag()));
        }
        if (!((SparkDataFlow)sdf).getParameter(pa.getTag(), "intermediate", false).booleanValue()) {
            JavaPairRDD outRdd = ((SparkDataFlow)sdf).getIntermediatePairRDD(pa.getTag());
            ((SparkDataFlow)sdf).putPairRDD(pa.getTag(), outRdd);
        }
    }
}

