/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.batch.hmap;

import org.apache.spark.api.java.JavaPairRDD;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.spark.SparkDataFlow;
import org.talend.bigdata.dataflow.spark.common.hmap.MapPairToPairWithCompositeKeyFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.TransformOutputMultiFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.TransformOutputSingleFunction;

public class SparkHMapTransform<SDF extends SparkDataFlow<?>>
implements DataFlowPipelineBuilder.PipelinePartialBuilder<SDF, HMapSpec> {
    @Override
    public void build(SDF sdf, HMapSpec spec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        HMapSpec.InputDef inDef = spec.getFirstInputNonPull();
        JavaPairRDD inData = ((SparkDataFlow)sdf).getIntermediatePairRDD(inDef.getTag());
        if (null != inDef.getJoin() && !((SparkDataFlow)sdf).getParameter(inDef.getTag(), "retain_key", false).booleanValue()) {
            inData = inData.mapToPair(new MapPairToPairWithCompositeKeyFunction(inDef.getOrder(), spec));
        }
        if (spec.isMultiOutput()) {
            JavaPairRDD outData = inData.mapPartitionsToPair(new TransformOutputMultiFunction(spec));
            ((SparkDataFlow)sdf).putIntermediatePairRDD(pa.getTag(), outData);
        } else {
            JavaPairRDD outData = inData.mapPartitionsToPair(new TransformOutputSingleFunction(spec));
            ((SparkDataFlow)sdf).putIntermediatePairRDD(pa.getTag(), outData);
        }
    }
}

