/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.batch.io;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.DataFlowBuilder;
import org.talend.bigdata.dataflow.io.IoSpec;
import org.talend.bigdata.dataflow.spark.batch.SparkBatchDataFlow;
import org.talend.bigdata.dataflow.spark.common.SparkIoDataFlowBuilderFunctions;

public class SparkIoDataFlowBuilder
implements DataFlowBuilder.DataFlowWithSpecBuilder<IoSpec> {
    @Override
    public void build(DataFlow<?> df, IoSpec mSpec) {
        SparkBatchDataFlow sparkDf = (SparkBatchDataFlow)df;
        if (mSpec.isInput()) {
            if (StringUtils.isNotEmpty((String)mSpec.getFieldDelimiter())) {
                String schema = mSpec.getSchema().toString();
                JavaPairRDD input = sparkDf.sc().textFile(mSpec.getPath()).mapToPair((PairFunction)new SparkIoDataFlowBuilderFunctions.FlatToAvroFunction(mSpec.getFieldDelimiter(), schema));
                sparkDf.putPairRDD(mSpec.getTag(), input);
            } else {
                JavaPairRDD input = sparkDf.sc().hadoopFile(mSpec.getPath(), AvroInputFormat.class, AvroWrapper.class, NullWritable.class).mapToPair((PairFunction)new SparkIoDataFlowBuilderFunctions.AvroUnwrapperFunction());
                sparkDf.putPairRDD(mSpec.getTag(), input);
            }
        } else if (StringUtils.isNotEmpty((String)mSpec.getFieldDelimiter())) {
            sparkDf.getPairRDD(mSpec.getTag()).map(new SparkIoDataFlowBuilderFunctions.AvroToFlatFunction(mSpec.getFieldDelimiter(), mSpec.getSchema())).saveAsTextFile(mSpec.getPath());
        } else {
            Job job;
            try {
                job = Job.getInstance();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get job instance.", e);
            }
            AvroJob.setOutputKeySchema((Job)job, (Schema)mSpec.getSchema());
            sparkDf.getPairRDD(mSpec.getTag()).mapToPair(new SparkIoDataFlowBuilderFunctions.AvroStoreFunction()).saveAsNewAPIHadoopFile(mSpec.getPath(), AvroKey.class, NullWritable.class, AvroKeyOutputFormat.class, job.getConfiguration());
        }
    }
}

