/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common;

import java.util.Collections;
import java.util.Map;
import org.apache.spark.broadcast.Broadcast;
import org.talend.bigdata.dataflow.functions.FlatMapper;

public class BroadcastCacheFlatMapper<K, V>
implements FlatMapper<K, V> {
    private static final long serialVersionUID = 1L;
    private final Broadcast<? extends Map<K, ? extends Iterable<V>>> mBroadcast;
    private Map<K, ? extends Iterable<V>> mCache;

    public BroadcastCacheFlatMapper(Broadcast<? extends Map<K, ? extends Iterable<V>>> broadcast) {
        this.mBroadcast = broadcast;
    }

    @Override
    public void prepare() throws Exception {
        this.mCache = (Map)this.mBroadcast.value();
    }

    @Override
    public Iterable<V> flatMap(K next) throws Exception {
        Iterable<V> values = this.mCache.get(next);
        return values != null ? values : Collections.emptyList();
    }

    @Override
    public void cleanup() throws Exception {
    }
}

