/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common.hmap;

import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.function.PairFunction;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.keys.JoinKeyRecord;
import scala.Tuple2;

public class MapPairToPairWithCompositeKeyFunction<KEY>
implements PairFunction<Tuple2<KEY, IndexedRecord>, JoinKeyRecord, IndexedRecord> {
    private static final long serialVersionUID = 1L;
    private final int mOrder;
    private final HMapSpec mSpec;
    private transient HMapSpec.InputDef mIn;
    private transient HExpr[] mJoinKeyHExpr;
    private transient PostProcessor<IndexedRecord> mJoinKeyProcessor;

    public MapPairToPairWithCompositeKeyFunction(int inOrder, HMapSpec hMapSpec) {
        this.mOrder = inOrder;
        this.mSpec = hMapSpec;
    }

    public Tuple2<JoinKeyRecord, IndexedRecord> call(Tuple2<KEY, IndexedRecord> t) throws Exception {
        if (this.mIn == null) {
            this.mIn = this.mSpec.getInput(this.mOrder);
            this.mJoinKeyHExpr = this.mIn.getJoin().getKeys();
            this.mJoinKeyProcessor = this.mIn.getJoin().getJoinKeyProcessor();
        }
        JoinKeyRecord joinKey = new JoinKeyRecord(this.mSpec.getJoinKeySchema());
        this.mIn.getGetter().setRootValue((IndexedRecord)t._2());
        if (this.mJoinKeyProcessor != null) {
            this.mJoinKeyProcessor.postProcess(joinKey);
        } else {
            for (int i = 0; i < this.mJoinKeyHExpr.length; ++i) {
                joinKey.put(i, this.mIn.getGetter().get(this.mJoinKeyHExpr[i]));
            }
        }
        return new Tuple2((Object)joinKey, t._2());
    }
}

