/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common.hmap;

import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.function.PairFunction;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.keys.IndexedRecordGetter;
import org.talend.bigdata.dataflow.keys.ReusableJoinKeyIndexedRecordFetcher;
import scala.Tuple2;

public class MapPairToPairWithSingleKeyFunction<KEY_IN_IGNORED, KEY_OUT>
implements PairFunction<Tuple2<KEY_IN_IGNORED, IndexedRecord>, KEY_OUT, IndexedRecord> {
    private static final long serialVersionUID = 1L;
    private final int mOrder;
    private final HMapSpec mSpec;
    private final PostProcessor<IndexedRecord> mJoinKeyProcessor;
    private transient HMapSpec.InputDef mIn;
    private transient HExpr mJoinKeyHExpr;
    private transient IndexedRecordGetter<KEY_OUT> mFetcherForJoinKeyExpression;

    public MapPairToPairWithSingleKeyFunction(int order, HMapSpec hMapSpec) throws IllegalArgumentException {
        HExpr[] joinKeys;
        this.mOrder = order;
        this.mSpec = hMapSpec;
        HMapSpec.InputDef in = this.mSpec.getInput(this.mOrder);
        this.mJoinKeyProcessor = in.getJoin().getJoinKeyProcessor();
        if (this.mJoinKeyProcessor == null && (joinKeys = in.getJoin().getKeys()).length != 1) {
            throw new IllegalArgumentException("Error choosing a single join key.  Expected 1, actual " + joinKeys.length);
        }
    }

    public Tuple2<KEY_OUT, IndexedRecord> call(Tuple2<KEY_IN_IGNORED, IndexedRecord> t) throws Exception {
        Object joinKey;
        if (this.mIn == null) {
            this.mIn = this.mSpec.getInput(this.mOrder);
            if (this.mJoinKeyProcessor == null) {
                HExpr[] joinKeys = this.mIn.getJoin().getKeys();
                this.mJoinKeyHExpr = joinKeys[0];
            }
            this.mFetcherForJoinKeyExpression = new ReusableJoinKeyIndexedRecordFetcher<KEY_OUT>();
        }
        this.mIn.getGetter().setRootValue((IndexedRecord)t._2());
        if (this.mJoinKeyProcessor != null) {
            IndexedRecord joinKeyAsRecord = this.mFetcherForJoinKeyExpression.get(null);
            this.mJoinKeyProcessor.postProcess(joinKeyAsRecord);
            joinKey = joinKeyAsRecord.get(0);
        } else {
            joinKey = this.mIn.getGetter().get(this.mJoinKeyHExpr);
        }
        return new Tuple2(joinKey, t._2());
    }
}

