/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common.hmap;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.talend.bigdata.dataflow.functions.FlatMapperIterator;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.AvroJoiner;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.keys.JoinKeyRecord;
import scala.Tuple2;

public abstract class TransformOutputBaseFunction<KEY, OUTPUT>
implements PairFlatMapFunction<Iterator<Tuple2<KEY, ? extends IndexedRecord>>, KEY, OUTPUT>,
AvroJoiner.AvroJoinEmitter<Tuple2<KEY, ? extends IndexedRecord>> {
    private static final long serialVersionUID = 1L;
    protected final HMapSpec mSpec;
    private transient HMapSpec.InputDef mIn;
    private transient AvroJoiner<Tuple2<KEY, ? extends IndexedRecord>> mJoiner;
    private transient IndexedRecord mJoinKey;
    private transient HExpr[] mJoinKeyHExpr;
    private transient PostProcessor<IndexedRecord> mJoinKeyProcessor;
    private transient boolean mPreparedPullSources = false;
    protected final ArrayList<Tuple2<KEY, OUTPUT>> mOutput = new ArrayList();

    TransformOutputBaseFunction(HMapSpec spec) {
        this.mSpec = spec;
    }

    public Iterable<Tuple2<KEY, OUTPUT>> call(final Iterator<Tuple2<KEY, ? extends IndexedRecord>> iterator) throws Exception {
        return new Iterable<Tuple2<KEY, OUTPUT>>(){

            @Override
            public Iterator<Tuple2<KEY, OUTPUT>> iterator() {
                return new FlatMapperIterator<Tuple2<KEY, ? extends IndexedRecord>, Tuple2<KEY, OUTPUT>>(iterator){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void prepare() throws Exception {
                        TransformOutputBaseFunction.this.prepare();
                    }

                    @Override
                    public Iterable<Tuple2<KEY, OUTPUT>> flatMap(Tuple2<KEY, ? extends IndexedRecord> next) throws Exception {
                        return TransformOutputBaseFunction.this.transform(next);
                    }

                    @Override
                    public void cleanup() throws Exception {
                        TransformOutputBaseFunction.this.cleanup();
                    }
                };
            }
        };
    }

    private void prepare() {
        this.mIn = this.mSpec.getFirstInputNonPull();
        this.mJoiner = new AvroJoiner(this.mSpec);
        for (HMapSpec.OutputDef out : this.mSpec.getOutputs()) {
            this.mJoiner.addEmitter(out, this);
        }
        if (this.mSpec.getInputsPull().iterator().hasNext()) {
            this.mJoinKeyHExpr = this.mIn.getJoin().getKeys();
            this.mJoinKey = new JoinKeyRecord(this.mSpec.getJoinKeySchema());
            this.mJoinKeyProcessor = this.mIn.getJoin().getJoinKeyProcessor();
        }
    }

    private Iterable<Tuple2<KEY, OUTPUT>> transform(Tuple2<KEY, ? extends IndexedRecord> t) throws Exception {
        this.mOutput.clear();
        this.mJoiner.reset();
        if (this.mJoinKey == null) {
            this.mJoiner.transformNoJoin(t, this.mIn, (IndexedRecord)t._2());
        } else {
            this.mIn.getGetter().setRootValue((IndexedRecord)t._2());
            if (this.mJoinKeyProcessor != null) {
                this.mJoinKeyProcessor.postProcess(this.mJoinKey);
            } else {
                for (int i = 0; i < this.mJoinKeyHExpr.length; ++i) {
                    this.mJoinKey.put(i, this.mIn.getGetter().get(this.mJoinKeyHExpr[i]));
                }
            }
            if (!this.mPreparedPullSources) {
                for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                    pull.getPullSource().prepare();
                }
                this.mPreparedPullSources = true;
            }
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                for (IndexedRecord indexedRecord : pull.getPullSource().flatMap((IndexedRecord)this.mJoinKey)) {
                    if (!pull.isKeptAfterFilters(indexedRecord)) continue;
                    this.mJoiner.addLookup(pull, indexedRecord);
                }
            }
            this.mJoiner.transformMain(t, this.mIn, (IndexedRecord)t._2());
        }
        return this.mOutput;
    }

    private void cleanup() throws Exception {
        if (this.mPreparedPullSources) {
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                pull.getPullSource().cleanup();
            }
        }
    }
}

