/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.streaming;

import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStreamLike;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.talend.bigdata.dataflow.spark.SparkDataFlow;
import org.talend.bigdata.dataflow.spark.common.MapToPairWithNullKeyFunction;
import org.talend.bigdata.dataflow.spark.common.SparkDataState;
import org.talend.bigdata.dataflow.spark.common.SparkTagParameters;
import org.talend.bigdata.dataflow.spark.common.TransformFromPairRDDWithValueFunction;
import org.talend.bigdata.dataflow.spark.streaming.SparkStreamingDataFlowContext;

public class SparkStreamingDataFlow
extends SparkDataFlow<SparkStreamingDataFlowContext> {
    private final SparkDataState<JavaPairDStream<?, ? extends IndexedRecord>, JavaDStream<? extends IndexedRecord>> mDStreams = new SparkDataState();
    private final SparkDataState<JavaPairDStream<?, ?>, JavaDStream<?>> mIntermediateDStreams = new SparkDataState();
    private final SparkTagParameters mTagParameters = new SparkTagParameters();

    public SparkStreamingDataFlow(SparkStreamingDataFlowContext context) {
        super(context);
    }

    @Override
    public void execute() {
        this.ssc().start();
        this.ssc().awaitTermination();
    }

    public void put(String tag, JavaDStreamLike<?, ?, ?> dStreamLike) {
        if (dStreamLike instanceof JavaDStream) {
            this.putDStream(tag, (JavaDStream)dStreamLike);
        } else {
            this.putPairDStream(tag, (JavaPairDStream)dStreamLike);
        }
    }

    public <K, V extends IndexedRecord> JavaPairDStream<K, V> getPairDStream(String pairTag) {
        return this.mDStreams.getPairData(pairTag);
    }

    public <K, V extends IndexedRecord> void putPairDStream(String pairTag, JavaPairDStream<K, V> pairDStream) {
        if (pairDStream == null) {
            this.mDStreams.putPairData(pairTag, null, null);
        } else {
            this.mDStreams.putPairData(pairTag, pairDStream, (JavaDStream<? extends IndexedRecord>)pairDStream.transform(new TransformFromPairRDDWithValueFunction()));
        }
    }

    public <V extends IndexedRecord> JavaDStream<V> getDStream(String tag) {
        return this.mDStreams.getNonPairData(tag);
    }

    public <V extends IndexedRecord> void putDStream(String tag, JavaDStream<V> dStream) {
        if (dStream == null) {
            this.mDStreams.putNonPairData(tag, null, null);
        } else {
            this.mDStreams.putNonPairData(tag, dStream, dStream.mapToPair(new MapToPairWithNullKeyFunction()));
        }
    }

    public <K, V> JavaPairDStream<K, V> getIntermediatePairDStream(String pairTag) {
        return this.mIntermediateDStreams.getPairData(pairTag);
    }

    public <K, V> void putIntermediatePairDStream(String pairTag, JavaPairDStream<K, V> pairDStream) {
        if (pairDStream == null) {
            this.mIntermediateDStreams.putPairData(pairTag, null, null);
        } else {
            this.mIntermediateDStreams.putPairData(pairTag, pairDStream, pairDStream.transform(new TransformFromPairRDDWithValueFunction()));
        }
    }

    public <V> JavaDStream<V> getIntermediateDStream(String tag) {
        return this.mIntermediateDStreams.getNonPairData(tag);
    }

    public <V> void putIntermediateDStream(String tag, JavaDStream<V> dStream) {
        if (dStream == null) {
            this.mIntermediateDStreams.putNonPairData(tag, null, null);
        } else {
            this.mIntermediateDStreams.putNonPairData(tag, dStream, dStream.mapToPair(new MapToPairWithNullKeyFunction()));
        }
    }

    public JavaSparkContext sc() {
        return ((SparkStreamingDataFlowContext)this.mContext).getSparkContext();
    }

    public JavaStreamingContext ssc() {
        return ((SparkStreamingDataFlowContext)this.mContext).getStreamingContext();
    }
}

