/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.streaming;

import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.talend.bigdata.dataflow.DataFlowContext;

public class SparkStreamingDataFlowContext
implements DataFlowContext {
    private String mJobName;
    private JavaStreamingContext mStreamingContext;

    SparkStreamingDataFlowContext(JavaStreamingContext streamingContext, String jobName) {
        this.mStreamingContext = streamingContext;
        this.mJobName = jobName;
    }

    @Override
    public String getJobName() {
        return this.mJobName;
    }

    public JavaSparkContext getSparkContext() {
        return this.mStreamingContext.sparkContext();
    }

    public JavaStreamingContext getStreamingContext() {
        return this.mStreamingContext;
    }

    public static class Builder {
        private JavaStreamingContext mStreamingContext;
        private SparkConf mSparkConf = new SparkConf();
        private String mJobName;
        private Duration mDuration;

        public Builder withJobName(String jobName) {
            this.mJobName = jobName;
            this.mSparkConf.setAppName(jobName);
            return this;
        }

        public Builder withMaster(String master) {
            this.mSparkConf.setMaster(master);
            return this;
        }

        public Builder withStreamingContext(JavaStreamingContext streamingContext) {
            this.mStreamingContext = streamingContext;
            return this;
        }

        public Builder withStreamingDuration(Duration duration) {
            this.mDuration = duration;
            return this;
        }

        public SparkStreamingDataFlowContext build() {
            if (this.mStreamingContext == null) {
                this.mStreamingContext = new JavaStreamingContext(this.buildNewSparkContext(), this.mDuration);
            }
            return new SparkStreamingDataFlowContext(this.mStreamingContext, this.mJobName);
        }

        private JavaSparkContext buildNewSparkContext() {
            this.mSparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
            this.mSparkConf.set("spark.kryo.registrator", "org.talend.bigdata.dataflow.serializer.KryoAvroRegistrator");
            return new JavaSparkContext(this.mSparkConf);
        }
    }
}

