/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.streaming.hmap;

import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.spark.common.hmap.Demultiplexor;
import org.talend.bigdata.dataflow.spark.common.hmap.MultiplexFilterPairValue;
import org.talend.bigdata.dataflow.spark.streaming.SparkStreamingDataFlow;

public class SparkHMapStore
extends org.talend.bigdata.dataflow.spark.batch.hmap.SparkHMapStore<SparkStreamingDataFlow> {
    @Override
    public void build(SparkStreamingDataFlow sdf, HMapSpec spec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        String inTag = incoming.iterator().next().getTag();
        String outTag = pa.getTag();
        if (null == sdf.getIntermediatePairDStream(inTag)) {
            super.build(sdf, spec, pa, incoming);
        } else {
            if (spec.isMultiOutput()) {
                JavaPairDStream inData = sdf.getIntermediatePairDStream(inTag);
                JavaPairDStream filteredData = inData.filter(new MultiplexFilterPairValue((byte)spec.getOutputOrder(pa.getTag()).intValue()));
                JavaPairDStream outData = filteredData.mapValues(new Demultiplexor());
                sdf.putIntermediatePairDStream(outTag, outData);
            } else {
                sdf.putIntermediatePairDStream(outTag, sdf.getIntermediatePairDStream(inTag));
            }
            if (!sdf.getParameter(outTag, "retain_key", false).booleanValue()) {
                sdf.putIntermediateDStream(outTag, sdf.getIntermediateDStream(outTag));
            }
            if (!sdf.getParameter(outTag, "intermediate", false).booleanValue()) {
                JavaPairDStream outDStream = sdf.getIntermediatePairDStream(outTag);
                sdf.putPairDStream(outTag, outDStream);
            }
        }
    }
}

