/*
 * Decompiled with CFR 0.152.
 */
package org.talend.libs.tbd.ee.libstorm;

import backtype.storm.ILocalDRPC;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.generated.DistributedRPC;
import java.io.PrintStream;
import java.util.Map;
import org.talend.libs.tbd.ee.libstorm.StormJobRunHelper;
import org.talend.libs.tbd.ee.libstorm.StormTopologyContext;

public class LocalStormJobRunHelper
extends StormJobRunHelper {
    private LocalTopologyContext ctx = null;

    @Override
    public LocalTopologyContext getTopologyContext() {
        if (this.ctx == null) {
            this.ctx = new LocalTopologyContext();
        }
        return this.ctx;
    }

    @Override
    public void inspect(PrintStream out) {
        System.out.println("== inspect start ==");
        System.out.println("{");
        System.out.println("  \"LOCALMODE\": \"true\",");
        System.out.println("  \"STORM_TOPOLOGY_NAME\": \"" + this.getTopologyName() + "\"");
        System.out.println("}");
        System.out.println("== inspect end ==");
    }

    @Override
    public int submitJob() throws Exception {
        this.getTopologyContext().getLocalCluster().submitTopology(this.getTopologyName(), (Map)this.ctx.getStormConfig(), this.ctx.getTridentTopology().build());
        return 0;
    }

    @Override
    public void runMonitorTimeout() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(LocalStormJobRunHelper.this.getMonitorTimeout() * 1000);
                    ((LocalDRPC)LocalStormJobRunHelper.this.ctx.getDrpcServer()).shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    final class LocalTopologyContext
    extends StormTopologyContext {
        private LocalDRPC localDrpcServer = null;
        private LocalCluster localCluster;

        LocalTopologyContext() {
        }

        @Override
        public final DistributedRPC.Iface getDrpcServer() {
            return this.getLocalDrpcServer();
        }

        @Override
        public final ILocalDRPC getLocalDrpcServer() {
            if (this.localDrpcServer == null) {
                this.localDrpcServer = new LocalDRPC();
            }
            return this.localDrpcServer;
        }

        public final LocalCluster getLocalCluster() {
            if (this.localCluster == null) {
                this.localCluster = new LocalCluster();
            }
            return this.localCluster;
        }
    }
}

