/*
 * Decompiled with CFR 0.152.
 */
package org.talend.libs.tbd.ee.libstorm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import storm.trident.operation.BaseFilter;
import storm.trident.operation.TridentOperationContext;
import storm.trident.tuple.TridentTuple;

public class PrintUtils
extends BaseFilter {
    private static final long serialVersionUID = 1L;
    private int partitionIndex;
    private int numPartitions;
    private boolean displayHeader;
    private boolean displayComponentUniqueName;
    private boolean displayColumnName;
    private boolean displayPartitionInfo;
    private boolean useFixedLength;
    private HashMap<String, Integer> fixedLength;
    private List<String> columnNames;
    private String fieldSeparator;
    private String name;

    public PrintUtils(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.fixedLength = null;
        this.columnNames = null;
        this.partitionIndex = 0;
        this.numPartitions = 0;
        this.displayHeader = false;
        this.displayColumnName = false;
        this.useFixedLength = false;
        this.displayComponentUniqueName = false;
        this.displayPartitionInfo = false;
    }

    public void displayHeader(List<String> columnNames) {
        this.displayHeader = true;
        this.columnNames = columnNames;
    }

    public void displayColumnName(List<String> columnNames) {
        this.displayColumnName = true;
        this.columnNames = columnNames;
    }

    public void forceFixedLength() {
        this.useFixedLength = true;
    }

    public void displayComponentUniqueName(String name) {
        this.displayComponentUniqueName = true;
        this.name = name;
    }

    public void displayPartitionInfo() {
        this.displayPartitionInfo = true;
    }

    public void prepare(Map conf, TridentOperationContext context) {
        this.partitionIndex = context.getPartitionIndex();
        this.numPartitions = context.numPartitions();
        if (this.displayHeader) {
            if (this.displayPartitionInfo) {
                System.out.print("Partition " + this.partitionIndex + " out of " + this.numPartitions + " partitions: ");
            }
            System.out.println(StringUtils.join(this.columnNames, (String)this.fieldSeparator));
            System.out.flush();
        }
    }

    private void printFieldWithColumnName(TridentTuple tuple) {
        if (this.columnNames.size() != tuple.size()) {
            return;
        }
        Iterator<String> columnNameIterator = this.columnNames.iterator();
        Iterator tupleIterator = tuple.iterator();
        if (!tupleIterator.hasNext()) {
            System.out.println("Empty");
        } else {
            while (true) {
                String columnName = columnNameIterator.next();
                Object tupleObject = tupleIterator.next();
                System.out.print(columnName + ": " + tupleObject.toString());
                if (!tupleIterator.hasNext()) {
                    System.out.println();
                    break;
                }
                System.out.print(this.fieldSeparator);
            }
        }
    }

    public boolean isKeep(TridentTuple tuple) {
        if (this.displayComponentUniqueName) {
            System.out.print(this.name + ": ");
        }
        if (this.displayPartitionInfo) {
            System.out.print("Partition " + this.partitionIndex + " out of " + this.numPartitions + " partitions: ");
        }
        if (this.displayColumnName) {
            this.printFieldWithColumnName(tuple);
            System.out.flush();
        } else {
            System.out.println(StringUtils.join((Collection)tuple, (String)this.fieldSeparator));
            System.out.flush();
        }
        return true;
    }
}

