/*
 * Decompiled with CFR 0.152.
 */
package org.talend.libs.tbd.ee.libstorm;

import java.util.List;
import java.util.Map;
import storm.trident.operation.BaseFilter;
import storm.trident.operation.TridentOperationContext;
import storm.trident.tuple.TridentTuple;

public class PrintVerticalUtils
extends BaseFilter {
    private static final long serialVersionUID = 1L;
    String[] des_top = new String[]{".", "-"};
    String[] des_data = new String[]{"-", "+"};
    String[] des_frame = new String[]{"|"};
    private int columnWidth;
    private int partitionIndex;
    private int numPartitions;
    private List<String> columnNames;
    private String uniqueName;

    public PrintVerticalUtils(String uniqueName, List<String> columnNames) {
        this.uniqueName = uniqueName;
        this.columnNames = columnNames;
        this.columnWidth = 5;
        for (String columnName : columnNames) {
            if (this.columnWidth >= columnName.length()) continue;
            this.columnWidth = columnName.length();
        }
        this.partitionIndex = 0;
        this.numPartitions = 0;
    }

    public void prepare(Map conf, TridentOperationContext context) {
        this.partitionIndex = context.getPartitionIndex();
        this.numPartitions = context.numPartitions();
    }

    public boolean isKeep(TridentTuple tuple) {
        int dataWidth = 7;
        for (int i = 0; i < tuple.size(); ++i) {
            if (dataWidth >= tuple.getValue(i).toString().length()) continue;
            dataWidth = tuple.getValue(i).toString().length();
        }
        this.print(tuple, dataWidth);
        return true;
    }

    public void print(TridentTuple tuple, int dataWidth) {
        int i;
        StringBuilder sb = new StringBuilder();
        String title = "node " + this.uniqueName + " #" + this.partitionIndex + " of " + this.numPartitions;
        int totalWidth = dataWidth + this.columnWidth + 5;
        sb.append(".");
        for (int i2 = 0; i2 < totalWidth; ++i2) {
            sb.append("-");
        }
        sb.append(".\n|");
        int emptyCenterWidth = (totalWidth - title.length()) / 2;
        for (i = 0; i < emptyCenterWidth; ++i) {
            sb.append(" ");
        }
        sb.append(title);
        for (i = 0; i < totalWidth - emptyCenterWidth - title.length(); ++i) {
            sb.append(" ");
        }
        sb.append("|\n");
        this.printLine(sb, dataWidth);
        sb.append("| key");
        for (i = 0; i < this.columnWidth - 2; ++i) {
            sb.append(" ");
        }
        sb.append("| value");
        for (i = 0; i < dataWidth - 4; ++i) {
            sb.append(" ");
        }
        sb.append("|\n");
        this.printLine(sb, dataWidth);
        for (int iterator = 0; iterator < tuple.size(); ++iterator) {
            String stringValue = tuple.getValue(iterator).toString();
            sb.append("| " + this.columnNames.get(iterator));
            for (int j = 0; j < this.columnWidth - this.columnNames.get(iterator).length() + 1; ++j) {
                sb.append(" ");
            }
            sb.append("| " + stringValue);
            for (int k = 0; stringValue == null && k < dataWidth - 3 || stringValue != null && k < dataWidth - stringValue.length() + 1; ++k) {
                sb.append(" ");
            }
            sb.append("|\n");
        }
        this.printLine(sb, dataWidth);
        System.out.println(sb.toString());
    }

    public void printLine(StringBuilder sb, int dataWidth) {
        int i;
        sb.append("+");
        for (i = 0; i < this.columnWidth + 2; ++i) {
            sb.append("-");
        }
        sb.append("+");
        for (i = 0; i < dataWidth + 2; ++i) {
            sb.append("-");
        }
        sb.append("+\n");
    }
}

