/*
 * Decompiled with CFR 0.152.
 */
package org.talend.libs.tbd.ee.libstorm;

import backtype.storm.Config;
import backtype.storm.generated.DRPCExecutionException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.thrift7.TException;
import org.talend.libs.tbd.ee.libstorm.StormTopologyContext;
import org.talend.libs.tbd.ee.libstorm.StormTopologyInitializer;
import org.talend.libs.tbd.ee.libstorm.StormTopologyMonitor;

public abstract class StormJobRunHelper {
    protected static final String INSPECT_MARKER_START = "== inspect start ==";
    protected static final String INSPECT_MARKER_END = "== inspect end ==";
    protected final LifecycleArgumentManager lifecycleArgs = new LifecycleArgumentManager();
    protected final ContextArgumentManager contextArgs = new ContextArgumentManager();
    protected boolean doInspect = false;
    protected String topologyName = null;
    private StormTopologyInitializer initializer = null;
    private StormTopologyMonitor monitor = null;

    protected StormJobRunHelper() {
    }

    public abstract int submitJob() throws Exception;

    public abstract StormTopologyContext getTopologyContext();

    public void runMonitorTimeout() {
    }

    public abstract void inspect(PrintStream var1);

    public void killExistingTopology() {
    }

    public int runStorm() throws Exception {
        int status = 0;
        if (this.initializer == null) {
            throw new NullPointerException("the topology initializer was not specified");
        }
        if (this.getDoKillOnExit()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StormJobRunHelper.this.killExistingTopology();
                }
            });
        }
        this.initializer.initialize(this.getTopologyContext());
        if (this.getDoKillAlreadyExisting()) {
            this.killExistingTopology();
        }
        if (this.getDoSubmit()) {
            status = this.submitJob();
        }
        if (this.getDoMonitor()) {
            if (this.lifecycleArgs.monitorTimeout > -1) {
                this.runMonitorTimeout();
            }
            this.runMonitor();
        }
        return status;
    }

    public void evalArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.evalArgument(args[i]);
            this.lifecycleArgs.evalArgument(args[i]);
            this.contextArgs.evalArgument(args[i], args, i);
        }
    }

    protected void evalArgument(String arg) {
        if (arg.startsWith("--topologyName=")) {
            this.topologyName = arg.substring("--topologyName=".length());
        } else if (arg.startsWith("--inspect")) {
            this.doInspect = Boolean.valueOf(arg.substring("--inspect=".length()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runMonitor() throws InterruptedException, DRPCExecutionException {
        if (this.monitor == null) return;
        while (true) {
            Thread.sleep(1000L);
            try {
                this.monitor.run(this.getTopologyContext().getDrpcServer(), this.getTopologyName());
                continue;
            }
            catch (TException e) {
                e.printStackTrace();
                continue;
            }
            catch (DRPCExecutionException ex) {
                throw ex;
            }
            break;
        }
    }

    public Config getStormConfig() {
        return this.getTopologyContext().getStormConfig();
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public boolean getDoInspect() {
        return this.doInspect;
    }

    public void setDoInspect(boolean doInspect) {
        this.doInspect = doInspect;
    }

    public boolean getDoKillAlreadyExisting() {
        return this.lifecycleArgs.doKillAlreadyExisting;
    }

    public void setDoKillAlreadyExisting(boolean doKillAlreadyExisting) {
        this.lifecycleArgs.doKillAlreadyExisting = doKillAlreadyExisting;
    }

    public boolean getDoSubmit() {
        return this.lifecycleArgs.doSubmit;
    }

    public void setDoSubmit(boolean doSubmit) {
        this.lifecycleArgs.doSubmit = doSubmit;
    }

    public boolean getDoMonitor() {
        return this.lifecycleArgs.doMonitor;
    }

    public void setDoMonitor(boolean overrideMonitor) {
        this.lifecycleArgs.doMonitor = overrideMonitor;
    }

    public boolean getDoKillOnExit() {
        return this.lifecycleArgs.doKillOnExit;
    }

    public void setDoKillOnExit(boolean doKillOnExit) {
        this.lifecycleArgs.doKillOnExit = doKillOnExit;
    }

    public void setTopologyInitializer(StormTopologyInitializer initializer) {
        this.initializer = initializer;
    }

    public void setTopologyMonitor(StormTopologyMonitor monitor) {
        this.monitor = monitor;
    }

    protected int getMonitorTimeout() {
        return this.lifecycleArgs.monitorTimeout;
    }

    public void setMonitorTimeout(Integer monitorTimeout) {
        this.lifecycleArgs.monitorTimeout = monitorTimeout;
    }

    public String getContextName() {
        return this.contextArgs.contextStr;
    }

    public void setContextName(String contextName) {
        this.contextArgs.contextStr = contextName;
    }

    public boolean isDefaultContext() {
        return this.contextArgs.isDefaultContext;
    }

    public Properties getOverrideProperties() {
        return this.contextArgs.overrideProperties;
    }

    public static class ContextArgumentManager {
        protected String contextStr;
        protected boolean isDefaultContext = true;
        protected Properties overrideProperties = new Properties();
        private static final String[][] ESCAPE_CHARS = new String[][]{{"\\\\", "\\"}, {"\\n", "\n"}, {"\\'", "'"}, {"\\r", "\r"}, {"\\f", "\f"}, {"\\b", "\b"}, {"\\t", "\t"}};

        protected void evalArgument(String arg, String[] args, int i) {
            if (arg.startsWith("--context=")) {
                this.contextStr = arg.substring("--context=".length());
                this.isDefaultContext = false;
            } else if ("--context_param".equals(arg) && i + 1 < args.length) {
                String keyValue = args[i + 1];
                int index = -1;
                if (keyValue != null && (index = keyValue.indexOf(61)) > -1) {
                    this.overrideProperties.put(keyValue.substring(0, index), this.replaceEscapeChars(keyValue.substring(index + 1)));
                }
            }
        }

        private String replaceEscapeChars(String keyValue) {
            if (keyValue == null || "".equals(keyValue.trim())) {
                return keyValue;
            }
            StringBuilder result = new StringBuilder();
            int currIndex = 0;
            while (currIndex < keyValue.length()) {
                int index = -1;
                for (String[] strArray : ESCAPE_CHARS) {
                    index = keyValue.indexOf(strArray[0], currIndex);
                    if (index < 0) continue;
                    result.append(keyValue.substring(currIndex, index + strArray[0].length()).replace(strArray[0], strArray[1]));
                    currIndex = index + strArray[0].length();
                    break;
                }
                if (index >= 0) continue;
                result.append(keyValue.substring(currIndex));
                currIndex += keyValue.length();
            }
            return result.toString();
        }
    }

    public static class LifecycleArgumentManager {
        protected boolean doKillAlreadyExisting = false;
        protected boolean doSubmit = true;
        protected boolean doMonitor = true;
        protected boolean doKillOnExit = true;
        protected Integer monitorTimeout = -1;

        protected void evalArgument(String arg) {
            if (arg.startsWith("--killAlreadyExisting=")) {
                this.doKillAlreadyExisting = Boolean.valueOf(arg.substring("--killAlreadyExisting=".length()));
            } else if (arg.startsWith("--submit=")) {
                this.doSubmit = Boolean.valueOf(arg.substring("--submit=".length()));
            } else if (arg.startsWith("--monitor=")) {
                this.doMonitor = Boolean.valueOf(arg.substring("--monitor=".length()));
            } else if (arg.startsWith("--killOnExit=")) {
                this.doKillOnExit = Boolean.valueOf(arg.substring("--killOnExit=".length()));
            }
        }
    }
}

