/*
 * Decompiled with CFR 0.152.
 */
package org.talend.libs.tbd.ee.libstorm;

import backtype.storm.Config;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.talend.libs.tbd.ee.libstorm.AbstractFieldGenerator;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class TRowGeneratorSpout
implements IBatchSpout {
    private static final long serialVersionUID = 1L;
    private final long maxGeneratorSize;
    private long currentGeneratorSize;
    private Fields fields;
    private List<AbstractFieldGenerator> fieldGenerators;

    public TRowGeneratorSpout(Fields fields, List<AbstractFieldGenerator> fieldGenerators) throws IOException {
        this(fields, fieldGenerators, -1L);
    }

    public TRowGeneratorSpout(Fields fields, List<AbstractFieldGenerator> fieldGenerators, long maxGeneratorSize) throws IOException {
        this.fields = fields;
        this.fieldGenerators = fieldGenerators;
        this.maxGeneratorSize = maxGeneratorSize;
        this.currentGeneratorSize = 0L;
    }

    public void open(Map conf, TopologyContext context) {
    }

    public void doEmitBatch(long batchId, TridentCollector collector) {
        Values outputValue = new Values();
        for (AbstractFieldGenerator fieldGenerator : this.fieldGenerators) {
            outputValue.add(fieldGenerator.getNext());
        }
        collector.emit((List)outputValue);
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        if (this.maxGeneratorSize < 0L) {
            this.doEmitBatch(batchId, collector);
        } else if (this.currentGeneratorSize < this.maxGeneratorSize) {
            this.doEmitBatch(batchId, collector);
            ++this.currentGeneratorSize;
        }
    }

    public void ack(long batchId) {
    }

    public void close() {
    }

    public Map getComponentConfiguration() {
        return new Config();
    }

    public Fields getOutputFields() {
        return this.fields;
    }
}

