/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.SQLException;

public class DeferredClob
extends DeferredLob {
    private Reader m_reader;
    private byte[] data = null;
    private int offset;
    private int charSize = 1;
    private long totalBytesSent = 0L;
    private boolean m_bXMLType = false;

    public DeferredClob(Reader reader, long l, boolean bl) {
        this.m_reader = reader;
        this.m_nLength = l;
        this.m_bXMLType = bl;
    }

    public int writeDeferredLob(TDPacketStream tDPacketStream, int n, String string) throws IOException, SQLException {
        int n2 = 0;
        if (this.m_nLength == 0L) {
            this.m_bAtEof = true;
            return 0;
        }
        if (this.data != null) {
            tDPacketStream.put(this.data, this.offset, this.data.length - this.offset);
            this.totalBytesSent += (long)(n2 += this.data.length - this.offset);
            this.data = null;
        }
        if (n2 < n && !this.m_bAtEof) {
            if (this.readCharacterStream(n, this.m_bXMLType ? "UTF8" : string) == -1) {
                this.m_bAtEof = true;
                return n2;
            }
            int n3 = n - n2;
            if (this.data.length > n3) {
                tDPacketStream.put(this.data, 0, n3);
                this.totalBytesSent += (long)n3;
                n2 += n3;
                this.offset = n3;
            } else {
                tDPacketStream.put(this.data);
                n2 += this.data.length;
                this.totalBytesSent += (long)this.data.length;
                this.data = null;
            }
        }
        if (this.totalBytesSent >= this.m_nLength * (long)this.charSize) {
            this.m_bAtEof = true;
        }
        return n2;
    }

    private int readCharacterStream(int n, String string) throws IOException, SQLException {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string));
        int n2 = this.m_reader.read();
        if (n2 == -1) {
            this.data = null;
            return -1;
        }
        while (n2 != -1) {
            bufferedWriter.write(n2);
            ++this.m_nAmountRead;
            if (this.m_nAmountRead >= this.m_nLength || ++l >= (long)n) break;
            n2 = this.m_reader.read();
        }
        if (n2 == -1 && this.m_nAmountRead < this.m_nLength) {
            this.m_nLength = l;
        }
        bufferedWriter.flush();
        this.data = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        this.charSize = (int)((long)this.data.length / l);
        return (int)l;
    }
}

