/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.DeferredBlob;
import com.teradata.jdbc.LocatorLob;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.BlobOutputStream;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public abstract class LocatorBlob
extends LocatorLob {
    public LocatorBlob(TDSession tDSession, long l, byte[] byArray) {
        this.m_sColumnName = "bval";
        this.m_session = tDSession;
        this.length = l;
        this.locator = byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        return new LobStream(this.m_session, this.locator, 408, this.length);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        if (l < 1L || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "getBytes");
        }
        if (l + (long)n > this.length() + 1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "getBytes");
        }
        if (n == 0) {
            return new byte[0];
        }
        LobStream lobStream = new LobStream(this.m_session, this.locator, 408, this.length);
        return lobStream.getBytes(l, n);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "position");
    }

    public long position(Blob blob, long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "position");
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBinaryStream");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Blob.setBinaryStream");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.setBinaryStream");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)408);
        tDPreparedStatement.close();
        this.setStaleLocator(true);
        this.close();
        return new BufferedOutputStream(new BlobOutputStream(this), 64000);
    }

    public void truncate(long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (l < 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.truncate");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Blob.truncate");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.truncate");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = SUBSTRING(? FROM 1 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)408);
        tDPreparedStatement.close();
        this.setStaleLocator(true);
        this.close();
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Blob.setBytes");
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (byArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Blob.setBytes");
        }
        if (n < 0 || n2 < 0 || l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBytes");
        }
        if (n + n2 > byArray.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "Blob.setBytes");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("setBytes");
        byte[] byArray2 = byArray;
        if (n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        if (byArray2.length > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ515", "Blob.setBytes", String.valueOf(byArray.length));
        }
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.setBytes");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? || " + "SUBSTRING(? FROM " + (l + (long)n2) + " FOR " + this.length() + ") " + "WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)408, byArray2, 689);
        tDPreparedStatement.close();
        this.setStaleLocator(true);
        this.close();
        return n2;
    }

    public void writeStream(long l, InputStream inputStream, long l2) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Blob.writeStream");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.writeStream");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? WHERE id=" + this.getWritableLobId();
        int n = this.m_session.registerDeferredLob(new DeferredBlob(inputStream, l2));
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)408, n, 405);
        tDPreparedStatement.close();
        this.close();
        this.setStaleLocator(true);
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getBinaryStream(long,long)");
    }
}

