/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class LocatorLob {
    protected String m_sColumnName;
    protected TDSession m_session;
    protected long length;
    protected byte[] locator;
    private int writableLobId = 0;
    private boolean staleLocator = false;
    private Statement m_stmt;
    private ResultSet m_rs;
    protected boolean m_bFreed = false;

    public long length() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        return this.length;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    private static byte[] copyByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int getWritableLobId() {
        return this.writableLobId;
    }

    public void setWritableLobId(int n) {
        this.writableLobId = n;
    }

    public boolean locatorIsStale() {
        return this.staleLocator;
    }

    public void setStaleLocator(boolean bl) {
        this.staleLocator = bl;
    }

    public void close() throws SQLException {
        if (this.m_stmt != null) {
            this.m_stmt.close();
            this.m_stmt = null;
            this.m_rs = null;
        }
    }

    public void refreshStaleLocator() throws SQLException {
        if (this.m_session == null) {
            return;
        }
        String string = "select " + this.m_sColumnName + " from " + this.m_session.getLobTempTable() + " where id = " + this.getWritableLobId();
        if (this.m_stmt != null) {
            this.m_stmt.close();
        }
        this.m_stmt = this.m_session.createStatement();
        this.m_rs = this.m_stmt.executeQuery(string);
        this.m_rs.next();
        this.locator = LocatorLob.copyByteArray(((LocatorLob)this.m_rs.getObject((int)1)).locator);
        this.length = ((LocatorLob)this.m_rs.getObject((int)1)).length;
        this.setStaleLocator(false);
    }

    public String initWritableLobs(String string) throws SQLException {
        String string2;
        String string3 = string2 = this.m_session != null ? this.m_session.getLobTempTable() : null;
        if (string2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ514", string);
        }
        if (this.getWritableLobId() == 0) {
            this.setWritableLobId(this.m_session.getWritableLobId());
            Statement statement = this.m_session.createStatement();
            statement.executeUpdate("INSERT INTO " + string2 + "(id) VALUES(" + this.getWritableLobId() + ")");
            statement.close();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (this.m_bFreed) {
            return;
        }
        this.m_bFreed = true;
        this.close();
        if (this.m_session != null && !this.m_session.isClosed() && this.getWritableLobId() > 0) {
            String string = "DELETE FROM " + this.m_session.getLobTempTable() + " WHERE id = " + this.getWritableLobId();
            TDStatement tDStatement = (TDStatement)((Object)this.m_session.createStatement());
            try {
                tDStatement.executeUpdate(string);
            }
            finally {
                tDStatement.close();
            }
        }
    }
}

