/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class URLParameters {
    private String transactMode = "D";
    private String charSet = "ASCII";
    private String partition = "DBC/SQL";
    private int logonSequenceNumber = 0;
    private short connectFunction = 0;
    private String lssType = "";
    private boolean isGoverned = true;
    private boolean isTypeNameMetadata = false;
    private String type = "DEFAULT";
    private int sessions = 0;
    private String databaseName = "NO_DEF_DATABASE";
    private String accountId = "NO_ACCOUNT_ID";
    private String spl = "SPL";
    private int timestampNano = -1;
    private int timeNano = -1;
    private boolean lobSupport = true;
    private int compatDBS = 0;
    private int compatIsAutoInc = 0;
    private int compatIsCurrency = 0;
    private int compatIsSigned = 0;
    private int compatIsSearch = 0;
    private String compatGetSchema = "NO_DEF_SCHEMA";
    private String compatGetTable = "NO_DEF_TABLE";
    private int compatIsReadOnly = 0;
    private int compatIsWritable = 0;
    private int compatIsDefWrit = 0;
    private int dbsPort = 1025;
    private String m_sClientCharset = null;
    private int loginTimeout;
    private String logLevel = "ERROR";
    private String LogMech;
    private String LogData;
    private boolean encryptData;
    private boolean sipSupport = true;
    private boolean javaSPDefaultConnection = false;
    private String m_sUser;
    private String m_sPassword;
    private String newPassword;
    private boolean useXviews = false;
    private String lobTempTable;
    private boolean m_prepSupport = true;
    private boolean m_copDiscovery = true;
    private boolean m_bRunStartup = false;
    private long m_nConnectFailureTTL = 0L;
    private String m_sTCP = null;
    private boolean m_bTrustedSQLAwareness = false;
    private boolean m_bDataDictStats = false;
    private String m_sFieldSeparator = ",";
    private int m_nReconnectCount;
    private int m_nReconnectInterval;
    private boolean m_bFinalizeAutoClose = false;

    protected URLParameters(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, String string33, String string34, String string35, String string36, String string37, String string38, String string39, String string40, String string41, String string42, String string43) throws SQLException {
        this.transactMode = string;
        this.setCharSet(string2);
        this.partition = string3;
        this.type = string4;
        this.setSessions(string5);
        this.setGovern(string6);
        this.spl = string7;
        this.databaseName = string8;
        this.accountId = string9;
        this.loginTimeout = n;
        this.newPassword = string29;
        this.setClientCharset(string10);
        this.setLobSupport(string11);
        this.setCompatDBS(string16);
        this.setCompatIsAutoInc(string17);
        this.setCompatIsCurrency(string18);
        this.setCompatIsSigned(string19);
        this.setCompatIsSearch(string20);
        this.setCompatGetSchema(string21);
        this.setCompatGetTable(string22);
        this.setCompatIsReadOnly(string23);
        this.setCompatIsWritable(string24);
        this.setCompatIsDefWrit(string25);
        this.setDbsPort(string12);
        this.setLogMech(string13);
        this.setLogData(string14);
        this.setEncryptData(string15);
        this.setLogLevel(string28);
        this.setTimeNano(string26);
        this.setTimestampNano(string27);
        this.setuseXviews(string30);
        this.setLobTempTable(string31);
        this.setPrepSupport(string32);
        this.setCopDiscovery(string33);
        this.setRunStartup(string34);
        this.setConnectFailureTTL(string35);
        this.setTCP(string36);
        this.setTrustedSQLAwareness(string37);
        this.setSipSupport(string38);
        this.setDataDictStats(string39);
        this.setFieldSeparator(string40);
        this.setReconnectCount(string41);
        this.setReconnectInterval(string42);
        this.setFinalizeAutoClose(string43);
    }

    public URLParameters(String string) throws SQLException {
        Vector vector = new Vector(5);
        this.ParseParams(vector, string);
        this.setParams(vector);
    }

    private void setParams(Vector vector) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); i += 2) {
            if (((String)vector.elementAt(i)).equalsIgnoreCase("database")) {
                this.setDatabaseName(vector.elementAt(i + 1).toString());
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("account") || ((String)vector.elementAt(i)).equalsIgnoreCase("accountid")) {
                this.setAccountId(vector.elementAt(i + 1).toString());
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("tmode")) {
                this.setTransactMode((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("charset")) {
                this.setCharSet((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("CLIENT_CHARSET")) {
                this.setClientCharset((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("PARTITION")) {
                this.setPartition((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOGON_SEQUENCE_NUMBER")) {
                this.setLogonSequenceNumber((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("CONNECT_FUNCTION")) {
                this.setConnectFunction((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("TYPE")) {
                this.setType((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("SESSIONS")) {
                this.setSessions((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LSS_TYPE")) {
                this.setLssType((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("GOVERN")) {
                this.setGovern((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("TYPE_NAME_METADATA")) {
                this.setTypeNameMetadata((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("sp_spl")) {
                this.setSpl((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("tsnano")) {
                this.setTimestampNano((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("tnano")) {
                this.setTimeNano((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOB_SUPPORT")) {
                this.setLobSupport((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_DBS")) {
                this.setCompatDBS((String)vector.elementAt(i + 1));
                bl2 = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISAUTOINC")) {
                this.setCompatIsAutoInc((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISCURRENCY")) {
                this.setCompatIsCurrency((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISSIGNED")) {
                this.setCompatIsSigned((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISSEARCH")) {
                this.setCompatIsSearch((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_GETSCHEMA")) {
                this.setCompatGetSchema((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_GETTABLE")) {
                this.setCompatGetTable((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISREADONLY")) {
                this.setCompatIsReadOnly((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISWRITABLE")) {
                this.setCompatIsWritable((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COMPAT_ISDEFWRIT")) {
                this.setCompatIsDefWrit((String)vector.elementAt(i + 1));
                bl = true;
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("DBS_PORT")) {
                this.setDbsPort((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOG")) {
                this.setLogLevel((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOGMECH")) {
                this.setLogMech((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOGDATA")) {
                this.setLogData((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("ENCRYPTDATA")) {
                this.setEncryptData((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("SIP_SUPPORT")) {
                this.setSipSupport((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("USER")) {
                this.m_sUser = (String)vector.elementAt(i + 1);
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("PASSWORD")) {
                this.m_sPassword = (String)vector.elementAt(i + 1);
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("NEW_PASSWORD")) {
                this.setNewPassword((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("USEXVIEWS")) {
                this.setuseXviews((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("LOB_TEMP_TABLE")) {
                this.setLobTempTable((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("PREP_SUPPORT")) {
                this.setPrepSupport((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("COP")) {
                this.setCopDiscovery((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("RUNSTARTUP")) {
                this.setRunStartup((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("CONNECT_FAILURE_TTL")) {
                this.setConnectFailureTTL((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("TCP")) {
                this.setTCP((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("TRUSTED_SQL")) {
                this.setTrustedSQLAwareness((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("DDSTATS")) {
                this.setDataDictStats((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("FIELD_SEP")) {
                this.setFieldSeparator((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("RECONNECT_COUNT")) {
                this.setReconnectCount((String)vector.elementAt(i + 1));
                continue;
            }
            if (((String)vector.elementAt(i)).equalsIgnoreCase("RECONNECT_INTERVAL")) {
                this.setReconnectInterval((String)vector.elementAt(i + 1));
                continue;
            }
            if (!((String)vector.elementAt(i)).equalsIgnoreCase("FINALIZE_AUTO_CLOSE")) continue;
            this.setFinalizeAutoClose((String)vector.elementAt(i + 1));
        }
        if (bl && !bl2) {
            throw ErrorFactory.makeDriverJDBCException("TJ366");
        }
        this.setLoginTimeout(DriverManager.getLoginTimeout());
    }

    public String getDelegatedParameters() {
        return "LOG=" + this.getLogLevel() + "," + "DBS_PORT" + "=" + this.getDbsPort() + "," + "COP" + "=" + (this.getCopDiscovery() ? "ON" : "OFF") + "," + "CONNECT_FAILURE_TTL" + "=" + this.getConnectFailureTTL() + (this.getTCP() != null ? ",TCP=" + this.getTCP() : "") + "," + "charset" + "=" + this.getCharSet() + (this.getClientCharset() != null ? ",CLIENT_CHARSET=" + this.getClientCharset() : "") + "," + "ENCRYPTDATA" + "=" + (this.getEncryptData() ? "ON" : "OFF") + (this.getLogMech() != null ? ",LOGMECH=" + this.getLogMech() : "") + (this.getLogData() != null ? ",LOGDATA='" + this.getLogData() + "'" : "") + "," + "GOVERN" + "=" + this.getGovern() + "," + "RECONNECT_COUNT" + "=" + this.getReconnectCount() + "," + "RECONNECT_INTERVAL" + "=" + this.getReconnectInterval() + "," + "FINALIZE_AUTO_CLOSE" + "=" + (this.getFinalizeAutoClose() ? "ON" : "OFF");
    }

    public String getTransactMode() {
        return this.transactMode;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getPartition() {
        return this.partition;
    }

    public int getLogonSequenceNumber() {
        return this.logonSequenceNumber;
    }

    public short getConnectFunction() {
        return this.connectFunction;
    }

    public String getType() {
        return this.type;
    }

    public int getSessions() {
        return this.sessions;
    }

    public String getLssType() {
        return this.lssType;
    }

    public String getGovern() {
        if (this.isGoverned) {
            return "ON";
        }
        return "OFF";
    }

    public boolean isGoverned() {
        return this.isGoverned;
    }

    public String getTypeNameMetadata() {
        if (this.isTypeNameMetadata) {
            return "ON";
        }
        return "OFF";
    }

    public boolean isTypeNameMetadata() {
        return this.isTypeNameMetadata;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getSpl() {
        return this.spl;
    }

    public int getTimestampNano() {
        return this.timestampNano;
    }

    public int getTimeNano() {
        return this.timeNano;
    }

    public void setLobSupport(boolean bl) {
        this.lobSupport = bl;
    }

    public boolean isLobSupported() {
        return this.lobSupport;
    }

    public String getClientCharset() {
        return this.m_sClientCharset;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setTransactMode(String string) {
        if (string.equalsIgnoreCase("tera")) {
            this.transactMode = "T";
        } else if (string.equalsIgnoreCase("ansi")) {
            this.transactMode = "A";
        } else if (string.equalsIgnoreCase("default")) {
            this.transactMode = "D";
        }
    }

    public void setCharSet(String string) {
        this.charSet = string.toUpperCase();
    }

    protected void setPartition(String string) {
        this.partition = string;
    }

    protected void setLogonSequenceNumber(String string) throws SQLException {
        try {
            this.logonSequenceNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ404", string);
        }
    }

    protected void setConnectFunction(String string) throws SQLException {
        try {
            this.connectFunction = Short.parseShort(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ405", string);
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    protected void setSessions(String string) throws SQLException {
        try {
            this.sessions = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ErrorFactory.makeDriverJDBCException("TJ454", string);
        }
        if (this.sessions < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ455", this.sessions);
        }
    }

    protected void setLssType(String string) throws SQLException {
        this.lssType = string;
    }

    protected void setGovern(String string) throws SQLException {
        this.isGoverned = string.equalsIgnoreCase("ON");
    }

    protected void setTypeNameMetadata(String string) throws SQLException {
        this.isTypeNameMetadata = string.equalsIgnoreCase("ON");
    }

    protected void setDatabaseName(String string) {
        try {
            this.databaseName = string;
        }
        catch (Exception exception) {
            this.databaseName = "NO_DEF_DATABASE";
        }
    }

    protected void setLobTempTable(String string) {
        if (string != null) {
            string = "\"" + string.replaceAll("\"", "\"\"").replaceAll("[.]", "\".\"") + "\"";
        }
        this.lobTempTable = string;
    }

    public String getLobTempTable() {
        return this.lobTempTable;
    }

    protected void setAccountId(String string) {
        try {
            this.accountId = string;
        }
        catch (Exception exception) {
            this.accountId = "NO_ACCOUNT_ID";
        }
    }

    public void setSpl(String string) {
        this.spl = string;
    }

    protected void setTimestampNano(String string) {
        try {
            this.timestampNano = Integer.parseInt(string);
            if (this.timestampNano > 6) {
                this.timestampNano = 6;
            } else if (this.timestampNano < 0) {
                this.timestampNano = -1;
            }
        }
        catch (Exception exception) {
            this.timestampNano = -1;
        }
    }

    public void setTimestampNano(int n) {
        this.timestampNano = n;
    }

    protected void setTimeNano(String string) {
        try {
            this.timeNano = Integer.parseInt(string);
            if (this.timeNano > 6) {
                this.timeNano = 6;
            } else if (this.timeNano < 0) {
                this.timeNano = -1;
            }
        }
        catch (Exception exception) {
            this.timeNano = -1;
        }
    }

    public void setTimeNano(int n) {
        this.timeNano = n;
    }

    public void setLobSupport(String string) {
        this.lobSupport = !string.equalsIgnoreCase("OFF");
    }

    protected void setCompatDBS(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatDBS = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatDBS = 2;
            }
        }
    }

    public int getCompatDBS() {
        return this.compatDBS;
    }

    protected void setCompatIsAutoInc(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsAutoInc = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsAutoInc = 2;
            }
        }
    }

    public int getCompatIsAutoInc() {
        return this.compatIsAutoInc;
    }

    protected void setCompatIsCurrency(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsCurrency = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsCurrency = 2;
            }
        }
    }

    public int getCompatIsCurrency() {
        return this.compatIsCurrency;
    }

    protected void setCompatIsSigned(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsSigned = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsSigned = 2;
            }
        }
    }

    public int getCompatIsSigned() {
        return this.compatIsSigned;
    }

    protected void setCompatIsSearch(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsSearch = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsSearch = 2;
            }
        }
    }

    public int getCompatIsSearch() {
        return this.compatIsSearch;
    }

    protected void setCompatGetSchema(String string) {
        this.compatGetSchema = string;
    }

    public String getCompatGetSchema() {
        return this.compatGetSchema;
    }

    protected void setCompatGetTable(String string) {
        this.compatGetTable = string;
    }

    public String getCompatGetTable() {
        return this.compatGetTable;
    }

    protected void setCompatIsReadOnly(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsReadOnly = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsReadOnly = 2;
            }
        }
    }

    public int getCompatIsReadOnly() {
        return this.compatIsReadOnly;
    }

    protected void setCompatIsWritable(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsWritable = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsWritable = 2;
            }
        }
    }

    public int getCompatIsWritable() {
        return this.compatIsWritable;
    }

    protected void setCompatIsDefWrit(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.compatIsDefWrit = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.compatIsDefWrit = 2;
            }
        }
    }

    public int getCompatIsDefWrit() {
        return this.compatIsDefWrit;
    }

    protected void setDbsPort(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.dbsPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.dbsPort <= 0) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ594", "DBS_PORT", string);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
    }

    public int getDbsPort() {
        return this.dbsPort;
    }

    protected void setClientCharset(String string) {
        this.m_sClientCharset = string;
    }

    protected void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    protected void setLogMech(String string) {
        this.LogMech = string;
    }

    public String getLogMech() {
        return this.LogMech;
    }

    protected void setLogData(String string) {
        this.LogData = string;
    }

    public String getLogData() {
        return this.LogData;
    }

    protected void setEncryptData(String string) {
        if (string != null && string.equalsIgnoreCase("ON")) {
            this.encryptData = true;
        }
    }

    public boolean getEncryptData() {
        return this.encryptData;
    }

    public String getUser() {
        return this.m_sUser;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setuseXviews(String string) {
        if (string != null && string.equalsIgnoreCase("ON")) {
            this.useXviews = true;
        }
    }

    public boolean getuseXviews() {
        return this.useXviews;
    }

    private void ParseParams(Vector vector, String string) throws SQLException {
        String string2 = string;
        while (string2.length() > 0) {
            int n = (string2 = string2.trim()).indexOf(61, 0);
            if (n >= 0) {
                String string3;
                int n2;
                String string4 = string2.substring(0, n).trim();
                if ((string2 = string2.substring(n + 1).trim()).length() == 0 || string2.charAt(0) == ',') {
                    throw ErrorFactory.makeDriverJDBCException("TJ631", string4);
                }
                int n3 = -1;
                int n4 = -1;
                int n5 = 0;
                n3 = string2.indexOf(39);
                if (n3 != -1) {
                    n2 = n3;
                    while ((n4 = string2.indexOf(39, n2 + 1)) != -1 && string2.length() > n4 + 1 && string2.charAt(n4 + 1) == '\'') {
                        if (n5 == 0) {
                            n5 = n4;
                        }
                        n2 = n4 + 2;
                    }
                }
                n = string2.indexOf(44, 0);
                n2 = string2.indexOf(32, 0);
                if (n != -1 && n > n3 && n < n4) {
                    n = string2.indexOf(44, n4 + 1);
                }
                if (n2 != -1 && n2 > n3 && n2 < n4) {
                    n2 = string2.indexOf(32, n4 + 1);
                }
                int n6 = n;
                if (n < 0) {
                    n6 = n2;
                } else {
                    n6 = n;
                    if (n2 >= 0 && n2 < n) {
                        n6 = n2;
                    }
                }
                if (n6 > 0) {
                    string3 = string2.substring(0, n6);
                    string2 = string2.substring(n6 + 1);
                } else if (n6 == 0) {
                    string3 = "";
                    string2 = string2.substring(n6 + 1);
                } else {
                    string3 = string2.substring(0);
                    string2 = "";
                }
                vector.addElement(string4);
                if (n5 != 0 && (n5 <= n6 || n6 == -1)) {
                    string3 = string3.replaceAll("''", "'");
                }
                if (string3.charAt(0) == '\'') {
                    string3 = string3.substring(1);
                }
                if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\'') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                vector.addElement(string3);
                continue;
            }
            string2 = "";
        }
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String string) {
        if (string != null) {
            this.logLevel = string;
        }
    }

    public boolean sipSupport() {
        return this.sipSupport;
    }

    protected void setSipSupport(String string) {
        if (string.equalsIgnoreCase("ON")) {
            this.sipSupport = true;
        } else if (string.equalsIgnoreCase("OFF")) {
            this.sipSupport = false;
        }
    }

    public void setSipSupport(boolean bl) {
        this.sipSupport = bl;
    }

    public void setJavaSPDefaultConnection(boolean bl) {
        this.javaSPDefaultConnection = bl;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.javaSPDefaultConnection;
    }

    public boolean getPrepSupport() {
        return this.m_prepSupport;
    }

    private void setPrepSupport(String string) {
        this.m_prepSupport = !"OFF".equalsIgnoreCase(string);
    }

    public boolean getCopDiscovery() {
        return this.m_copDiscovery;
    }

    public void setCopDiscovery(String string) {
        this.m_copDiscovery = !"OFF".equalsIgnoreCase(string);
    }

    public boolean getRunStartup() {
        return this.m_bRunStartup;
    }

    public void setRunStartup(String string) {
        this.m_bRunStartup = "ON".equalsIgnoreCase(string);
    }

    public long getConnectFailureTTL() {
        return this.m_nConnectFailureTTL;
    }

    public void setConnectFailureTTL(String string) {
        if (string != null) {
            this.m_nConnectFailureTTL = Long.parseLong(string);
        }
    }

    public String getTCP() {
        return this.m_sTCP;
    }

    public void setTCP(String string) {
        this.m_sTCP = string;
    }

    public boolean getTrustedSQLAwareness() {
        return this.m_bTrustedSQLAwareness;
    }

    public void setTrustedSQLAwareness(String string) {
        this.m_bTrustedSQLAwareness = "ON".equalsIgnoreCase(string);
    }

    public boolean getDataDictStats() {
        return this.m_bDataDictStats;
    }

    public void setDataDictStats(String string) {
        this.m_bDataDictStats = "ON".equalsIgnoreCase(string);
    }

    public String getFieldSeparator() {
        return this.m_sFieldSeparator;
    }

    public void setFieldSeparator(String string) {
        this.m_sFieldSeparator = string;
    }

    public void setReconnectCount(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nReconnectCount = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nReconnectCount < 0) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ594", "RECONNECT_COUNT", string);
                if (numberFormatException != null) {
                    jDBCException.initCause(numberFormatException);
                }
                throw jDBCException;
            }
        }
    }

    public void setReconnectInterval(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nReconnectInterval = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nReconnectInterval < 0) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ594", "RECONNECT_INTERVAL", string);
                if (numberFormatException != null) {
                    jDBCException.initCause(numberFormatException);
                }
                throw jDBCException;
            }
        }
    }

    public int getReconnectCount() {
        return this.m_nReconnectCount;
    }

    public int getReconnectInterval() {
        return this.m_nReconnectInterval;
    }

    public boolean getFinalizeAutoClose() {
        return this.m_bFinalizeAutoClose;
    }

    public void setFinalizeAutoClose(String string) {
        this.m_bFinalizeAutoClose = "ON".equalsIgnoreCase(string);
    }
}

