/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class Utility {
    public static final int HELP_SESSION_QUERY_BAND_INDEX = 44;
    public static final int QUERY_BAND_TRANSACTION_INDEX = 0;
    public static final int QUERY_BAND_SESSION_INDEX = 1;

    public static String getQueryBandFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        String string = "";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 44) {
            string = resultSet.getString(44);
        }
        return string;
    }

    public static String[] parseQueryBand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("queryBand argument must not be null");
        }
        String[] stringArray = new String[]{"", ""};
        if (!string.equals("")) {
            String string2 = "=T> ";
            String string3 = "=S> ";
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n >= 0 && n2 >= 0) {
                if (n < n2) {
                    stringArray[0] = string.substring(n + string2.length(), n2).trim();
                    stringArray[1] = string.substring(n2 + string3.length()).trim();
                } else {
                    stringArray[0] = string.substring(n + string2.length()).trim();
                    stringArray[1] = string.substring(n2 + string3.length(), n).trim();
                }
            } else if (n >= 0) {
                stringArray[0] = string.substring(n + string2.length()).trim();
            } else if (n2 >= 0) {
                stringArray[1] = string.substring(n2 + string3.length()).trim();
            }
        }
        return stringArray;
    }

    public static void tokenizeQueryBand(Map map, String string) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n < 0) continue;
            map.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
    }

    public static void sleepForSeconds(int n) {
        long l = (long)n * 1000L;
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

