/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogOffParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class GenericLogoffController {
    private GenericTeradataConnection m_con;

    public GenericLogoffController(GenericTeradataConnection genericTeradataConnection) {
        this.m_con = genericTeradataConnection;
    }

    public void run() throws SQLException {
        Parcel parcel;
        this.m_con.suppressReconnect();
        Log log = this.m_con.getLog();
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind((byte)8);
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setRequestNumber(this.m_con.getRequestNum());
        tDPacket.setHostCharSet((byte)-65);
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        LogOffParcel logOffParcel = new LogOffParcel(log);
        tDPacket.addParcel(logOffParcel);
        tDPacket.toStream();
        log.debug(tDPacket.getBuffer());
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), this.m_con.getTeraEncrypt());
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), this.m_con.getTeraEncrypt());
        tDPacket.initParcelFactory(this.m_con);
        log.debug(tDPacket.getBuffer());
        block5: while ((parcel = tDPacket.nextParcel()) != null) {
            switch (parcel.getFlavor()) {
                case 8: 
                case 205: {
                    ((StatementStatusParcel)parcel).verifySuccess();
                    continue block5;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
        }
    }
}

