/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.TeraCallbackHandler;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketEncrypt;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssContext;
import com.teradata.tdgss.jtdgss.TdgssManager;
import com.teradata.tdgss.jtdgss.TdgssMechProp;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GenericTeraEncrypt
implements PrivilegedExceptionAction,
TDPacketEncrypt {
    static final String GSS_KERBEROS_PRINCIPALNAME = "1.2.840.113554.1.2.2.1";
    static final String TD1_OID = "1.3.6.1.4.1.191.1.1012.1.1.8";
    static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private boolean isKerberos = false;
    static final int MECH_SUPPORTS_UTF16 = 8;
    static final int MECH_SUPPORTS_UTF8 = 4;
    static final int MECH_SUPPORTS_MECHDATA = 2;
    static final int SIZE_USER_NAME_PASS_DATA_ACCT = 50;
    private static TdgssManager myGSSManager;
    private static TdgssConfigApi myConfig;
    private TdgssContext context;
    private byte[] inToken;
    private byte trip;
    private boolean enabled;
    private boolean isPreV2R6;
    private GSSCredential myCred = null;
    private TdgssName myID = null;
    private int lifetimeCredential = 0;
    private Oid mechOid;
    private boolean usingGeneratedCredentials = false;
    protected Log log;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;

    private static JDBCException transformException(Throwable throwable) {
        if (throwable instanceof JDBCException) {
            return (JDBCException)throwable;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return ErrorFactory.makeDriverJDBCException("TJ314", "tdgss-stack-trace-begin>>> " + stringWriter + " <<<end-tdgss-stack-trace");
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(TD1_OID);
            genericTeradataConnection.setAuthMethod(new AuthMechanism(oid, this.log));
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = true;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public GenericTeraEncrypt(GenericTeradataConnection genericTeradataConnection, String string) throws JDBCException {
        this.log = genericTeradataConnection.getLog();
        try {
            Oid oid = new Oid(string);
            this.initEncrypt(genericTeradataConnection, oid);
            this.isPreV2R6 = false;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void initEncrypt(GenericTeradataConnection var1_1, Oid var2_2) throws JDBCException, GSSException, LoginException {
        var3_3 = null;
        var4_4 = 0;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        this.mechOid = var2_2;
        var8_8 = GenericTeraEncrypt.getGSSM(this.log);
        var9_9 = GenericTeraEncrypt.getConfig(this.log);
        var10_10 = null;
        if (this.log.canLog(1)) {
            var11_11 /* !! */  = TdgssManager.InquireLibraryVersion();
            this.log.info("tdgss version: " + var11_11 /* !! */ .MajorRelease + "." + var11_11 /* !! */ .MinorRelease + "." + var11_11 /* !! */ .MaintenanceRelease + "." + var11_11 /* !! */ .EmergencyRelease);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("java.security.auth.login.config: " + System.getProperty("java.security.auth.login.config"));
            this.log.debug("javax.security.auth.useSubjectCredsOnly: " + System.getProperty("javax.security.auth.useSubjectCredsOnly"));
            var11_11 /* !! */  = this.getLocalMechs();
            if (var11_11 /* !! */  != null) {
                this.log.debug(var11_11 /* !! */ );
            }
        }
        var11_11 /* !! */  = var9_9.InquirePropertiesForMech(var2_2.toString());
        var1_1.setAuthMethod(new AuthMechanism(var2_2.toString(), this.log));
        block26: for (var12_12 = 0; var12_12 < var11_11 /* !! */ .length - 1; ++var12_12) {
            if (var11_11 /* !! */ [var12_12] == null) continue;
            switch (var11_11 /* !! */ [var12_12].getIndex()) {
                case 1: {
                    if (var11_11 /* !! */ [var12_12].getValue().compareToIgnoreCase("yes") != 0) continue block26;
                    this.enabled = true;
                    continue block26;
                }
                case 24: {
                    var4_4 = this.getInt(var11_11 /* !! */ [var12_12].getValue());
                    continue block26;
                }
                case 25: {
                    this.lifetimeCredential = this.getInt(var11_11 /* !! */ [var12_12].getValue());
                    continue block26;
                }
                case 2: {
                    var5_5 = this.getBool(var11_11 /* !! */ [var12_12].getValue());
                    continue block26;
                }
                case 3: {
                    var6_6 = this.getBool(var11_11 /* !! */ [var12_12].getValue());
                    continue block26;
                }
                case 41: {
                    var7_7 = this.getBool(var11_11 /* !! */ [var12_12].getValue());
                }
            }
        }
        if (!this.enabled) {
            throw ErrorFactory.makeDriverJDBCException("TJ339", var2_2.toString());
        }
        var1_1.setSSOSupported(var5_5 != false || var6_6 != false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SSOSupported is: " + var1_1.getSSOSupported());
        }
        if (!var1_1.getSSOSupported() && var1_1.getLogonInformation().getUserName().equals("") && var1_1.getLogonInformation().getPassword().equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ332", var9_9.GetInforForMech(var2_2)[0]);
        }
        if (var2_2.toString().equals("1.2.840.113554.1.2.2")) {
            this.isKerberos = true;
        }
        if ((var12_13 = var8_8.getNamesForMech(var2_2)) != null) {
            var13_14 = 0;
            for (var14_16 = 0; var14_16 < var12_13.length; ++var14_16) {
                if (var12_13[var14_16].equals(GSSName.NT_HOSTBASED_SERVICE)) {
                    var15_22 = var1_1.getIO().getRemoteAddress();
                    var16_23 = var15_22.getHostAddress();
                    var17_24 = System.currentTimeMillis();
                    var19_26 = var15_22.getCanonicalHostName();
                    if (this.log.canLog(2)) {
                        this.log.timing("getCanonicalHostName for " + var15_22 + " took " + (System.currentTimeMillis() - var17_24) + " ms and returned " + var19_26);
                    }
                    var20_27 = var16_23.equals(var19_26) != false ? var1_1.getMachineName() : var19_26;
                    var21_28 = "TERADATA@" + var20_27;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("initEncrypt: iaRemote=" + var15_22 + " sRemoteLiteralIPAddress=" + (String)var16_23 + " sRemoteFQDN=" + var19_26 + " serverNameString=" + var21_28);
                    }
                    var3_3 = (TdgssName)var8_8.createName(var21_28, GSSName.NT_HOSTBASED_SERVICE, var2_2);
                    continue;
                }
                if (var12_13[var14_16].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA)) {
                    var13_14 = Math.max(var13_14, 2);
                    continue;
                }
                if (var12_13[var14_16].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                    if (!var1_1.isUTF_CredentialSupported()) continue;
                    var13_14 = Math.max(var13_14, 8);
                    continue;
                }
                if (var12_13[var14_16].equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                    if (!var1_1.isUTF_CredentialSupported()) continue;
                    var13_14 = Math.max(var13_14, 4);
                    continue;
                }
                this.log.debug("Unknown Oid Name Type for Mechanism: " + var12_13[var14_16].toString());
            }
            var10_10 = var1_1.getlogdata();
            if (var5_5 && var7_7) {
                var14_17 = var1_1.getLogonInformation().getUserName();
                var15_22 = var1_1.getLogonInformation().getPassword();
                if (var14_17 != null && var14_17.length() != 0 && var15_22 != null && var15_22.length() != 0) {
                    var15_22 = GenericTeraEncrypt.processEscapeChars((String)var15_22);
                    v0 = var16_23 = this.isKerberos != false ? var14_17 + "@@" + (String)var15_22 : "'" + var14_17 + "@@" + var15_22.replaceAll("'", "''") + "'";
                    if (var10_10 != null) {
                        var16_23 = (String)var16_23 + " " + var10_10;
                    }
                    var10_10 = var16_23;
                    this.usingGeneratedCredentials = true;
                }
            }
            if (var10_10 != null && var10_10.length() != 0) {
                switch (var13_14) {
                    case 8: {
                        this.myID = (TdgssName)var8_8.createName(var10_10, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, var2_2);
                        break;
                    }
                    case 4: {
                        this.myID = (TdgssName)var8_8.createName(var10_10, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, var2_2);
                        break;
                    }
                    case 2: {
                        try {
                            var14_18 = null;
                            var14_18 = var10_10.getBytes(var1_1.getSerializeDeserializeCharset());
                            this.myID = (TdgssName)var8_8.createName(var14_18, TdgssName.GSS_C_NT_TDAT_MECHDATA, var2_2);
                            break;
                        }
                        catch (Throwable var14_19) {
                            throw GenericTeraEncrypt.transformException(var14_19);
                        }
                    }
                }
            }
        }
        if (var1_1.getSSOSupported()) {
            if (this.isKerberos) {
                if (var10_10 != null && var10_10.length() != 0) {
                    var13_15 = var10_10.split("@@", 3);
                    if (var13_15 == null || var13_15.length != 2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ345");
                    }
                    try {
                        var14_20 = new TeraCallbackHandler(var13_15[0], var13_15[1]);
                        var15_22 = new LoginContext(this.getClass().getName(), var14_20);
                        var15_22.login();
                        this.log.debug("Subject is: " + var15_22.getSubject().toString());
                        Subject.doAs(var15_22.getSubject(), this);
                        if (!this.log.isDebugEnabled()) ** GOTO lbl137
                        var16_23 = var15_22.getSubject().getPrincipals().iterator();
                        this.log.debug("Authenticated user has the following Principals:");
                        while (var16_23.hasNext()) {
                            var17_25 = (Principal)var16_23.next();
                            this.log.debug("\t" + var17_25.toString());
                        }
                        this.log.debug("User has " + var15_22.getSubject().getPublicCredentials().size() + " Public Credential(s)");
                    }
                    catch (Throwable var14_21) {
                        throw GenericTeraEncrypt.transformException(var14_21);
                    }
                } else {
                    this.myCred = var8_8.createCredential(null, this.lifetimeCredential, var2_2, 1);
                }
            } else {
                if (var10_10 == null || var10_10.length() == 0) {
                    throw ErrorFactory.makeDriverJDBCException("TJ346");
                }
                this.myCred = var8_8.createCredential((GSSName)this.myID, this.lifetimeCredential, var2_2, 1);
            }
        }
lbl137:
        // 6 sources

        if (this.log.isDebugEnabled()) {
            this.log.debug("Credentials are: " + this.myCred);
        }
        this.context = (TdgssContext)var8_8.createContext(var3_3, var2_2, this.myCred, var4_4);
        this.inToken = new byte[0];
        block29: for (var13_14 = 0; var13_14 < var11_11 /* !! */ .length - 1; ++var13_14) {
            if (var11_11 /* !! */ [var13_14] == null) continue;
            switch (var11_11 /* !! */ [var13_14].getIndex()) {
                case 18: {
                    this.context.requestCredDeleg(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 19: {
                    this.context.requestMutualAuth(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 20: {
                    this.context.requestReplayDet(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 33: {
                    this.context.requestSequenceDet(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 21: {
                    this.context.requestConf(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 23: {
                    this.context.requestAnonymity(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                    continue block29;
                }
                case 22: {
                    this.context.requestInteg(this.getBool(var11_11 /* !! */ [var13_14].getValue()));
                }
            }
        }
    }

    public Object run() throws Exception {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        this.myCred = tdgssManager.createCredential((GSSName)this.myID, this.lifetimeCredential, this.mechOid, 1);
        return this.myCred;
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws JDBCException {
        long l = System.currentTimeMillis();
        byte[] byArray2 = null;
        try {
            byArray2 = this.context.initSecContext(byArray, n, n2);
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        if (this.log.canLog(2)) {
            this.log.timing("TdgssContext.initSecContext took " + (System.currentTimeMillis() - l) + " ms");
        }
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) throws JDBCException {
        try {
            MessageProp messageProp = new MessageProp(true);
            byte[] byArray2 = this.context.wrap(byArray, n, n2, messageProp);
            if (byArray2 == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ647");
            }
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.encrypt: inBuf.length=" + byArray.length + " offset=" + n + " len=" + n2 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " expansion=" + (byArray2 == null ? "n/a" : "" + (byArray2.length - n2)));
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) throws JDBCException {
        try {
            MessageProp messageProp = new MessageProp(true);
            byte[] byArray2 = this.context.unwrap(byArray, n, n2, messageProp);
            if (byArray2 == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ648");
            }
            if (this.log.canLog(1)) {
                this.log.info("TeraEncrypt.decrypt: inBuf.length=" + byArray.length + " offset=" + n + " len=" + n2 + " outToken.length=" + (byArray2 == null ? "null" : "" + byArray2.length) + " shrinkage=" + (byArray2 == null ? "n/a" : "" + (n2 - byArray2.length)));
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
    }

    public byte[] getIntoken() {
        return this.inToken;
    }

    public void setIntoken(byte[] byArray) {
        this.inToken = byArray;
    }

    public byte getTrip() {
        return this.trip;
    }

    public void incTrip() {
        this.trip = (byte)(this.trip + 2);
    }

    public void showContext() throws SQLException {
        GSSName gSSName;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("Context Information:" + Log.LINE_SEP);
        stringBuffer.append("getAnonymityState: " + this.context.getAnonymityState() + Log.LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + Log.LINE_SEP);
        stringBuffer.append("getConfState: " + this.context.getConfState() + Log.LINE_SEP);
        stringBuffer.append("getCredDelegState: " + this.context.getCredDelegState() + Log.LINE_SEP);
        stringBuffer.append("getLifeTime: " + this.context.getLifetime() + Log.LINE_SEP);
        try {
            stringBuffer.append("getMech: " + this.context.getMech().toString() + Log.LINE_SEP);
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        stringBuffer.append("getMutualAuthState: " + this.context.getMutualAuthState() + Log.LINE_SEP);
        stringBuffer.append("getReplayDetState: " + this.context.getReplayDetState() + Log.LINE_SEP);
        stringBuffer.append("getSequenceDetState: " + this.context.getSequenceDetState() + Log.LINE_SEP);
        try {
            stringBuffer.append("SrcName is: ");
            gSSName = this.context.getSrcName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + Log.LINE_SEP);
            } else {
                stringBuffer.append("undefined" + Log.LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        try {
            stringBuffer.append("TargName is: ");
            gSSName = this.context.getTargName();
            if (gSSName != null) {
                stringBuffer.append(((Object)gSSName).toString() + Log.LINE_SEP);
            } else {
                stringBuffer.append("undefined" + Log.LINE_SEP);
            }
        }
        catch (Throwable throwable) {
            throw GenericTeraEncrypt.transformException(throwable);
        }
        stringBuffer.append("isEstablished: " + this.context.isEstablished() + Log.LINE_SEP);
        stringBuffer.append("isProtReady: " + this.context.isProtReady() + Log.LINE_SEP);
        this.log.debug(stringBuffer);
    }

    public static byte[] getTDgssVersion() {
        TdgssVersion tdgssVersion = TdgssManager.InquireLibraryVersion();
        byte[] byArray = new byte[]{tdgssVersion.MajorRelease, tdgssVersion.MinorRelease, tdgssVersion.MaintenanceRelease, tdgssVersion.EmergencyRelease};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssManager getGSSM(Log log) {
        if (myGSSManager == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                if (myGSSManager == null) {
                    long l = System.currentTimeMillis();
                    myGSSManager = (TdgssManager)TdgssManager.getInstance();
                    long l2 = System.currentTimeMillis();
                    myConfig = TdgssConfigApi.getInstance();
                    if (log.canLog(2)) {
                        log.timing("TdgssManager initialization took " + (l2 - l) + " ms, TdgssConfigApi initialization took " + (System.currentTimeMillis() - l2) + " ms");
                    }
                }
            }
        }
        return myGSSManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TdgssConfigApi getConfig(Log log) {
        if (myConfig == null) {
            Class clazz = class$com$teradata$jdbc$jdbc$GenericTeraEncrypt == null ? (class$com$teradata$jdbc$jdbc$GenericTeraEncrypt = GenericTeraEncrypt.class$("com.teradata.jdbc.jdbc.GenericTeraEncrypt")) : class$com$teradata$jdbc$jdbc$GenericTeraEncrypt;
            synchronized (clazz) {
                GenericTeraEncrypt.getGSSM(log);
            }
        }
        return myConfig;
    }

    String dispOidType(Oid oid) {
        if (oid.equals(GSSName.NT_USER_NAME)) {
            return new String("\tNT_USER_NAME");
        }
        if (oid.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            return new String("\tNT_HOSTBASED_SERVICE");
        }
        if (oid.equals(GSSName.NT_EXPORT_NAME)) {
            return new String("\tNT_EXPORT_NAME");
        }
        if (oid.equals(GSSName.NT_ANONYMOUS)) {
            return new String("\tNT_ANONYMOUS");
        }
        if (oid.equals(GSSName.NT_MACHINE_UID_NAME)) {
            return new String("\tNT_MACHINE_UID_NAME");
        }
        if (oid.equals(GSSName.NT_STRING_UID_NAME)) {
            return new String("\tNT_STRING_UID_NAME");
        }
        if (oid.toString().equals(GSS_KERBEROS_PRINCIPALNAME)) {
            return new String("\tNT__ Kerberos Principal Name");
        }
        return new String("\tNT__ Unknown");
    }

    public boolean getBool(String string) {
        return string.equalsIgnoreCase(new String("yes"));
    }

    public int getInt(String string) {
        return string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    public byte getSSOAuthMethod() {
        if (this.isPreV2R6) {
            return 8;
        }
        return 0;
    }

    public static Oid getOidForName(String string, Log log) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray = tdgssConfigApi.GetInforForMech(oidArray[i]);
            if (stringArray[0].compareToIgnoreCase(string) != 0) continue;
            return oidArray[i];
        }
        return null;
    }

    public static String getUserNameForOid(Oid oid, Log log) {
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        String[] stringArray = tdgssConfigApi.GetInforForMech(oid);
        return stringArray[0];
    }

    public String getLocalMechs() {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(this.log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(this.log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Locally defined Mechanisms are:");
        String[][] stringArray = new String[oidArray.length][2];
        for (int i = 0; i < oidArray.length; ++i) {
            String[] stringArray2 = tdgssConfigApi.GetInforForMech(oidArray[i]);
            stringBuffer.append(Log.LINE_SEP + stringArray2[0] + "\t" + oidArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Oid getClientDefaultMech(Log log) {
        TdgssManager tdgssManager = GenericTeraEncrypt.getGSSM(log);
        TdgssConfigApi tdgssConfigApi = GenericTeraEncrypt.getConfig(log);
        Oid[] oidArray = tdgssManager.getMechs();
        if (oidArray == null) {
            return null;
        }
        for (int i = 0; i < oidArray.length; ++i) {
            if (oidArray[i] == null) continue;
            TdgssMechProp[] tdgssMechPropArray = tdgssConfigApi.InquirePropertiesForMech(oidArray[i].toString());
            boolean bl = false;
            boolean bl2 = false;
            block5: for (int j = 0; j < tdgssMechPropArray.length - 1; ++j) {
                if (tdgssMechPropArray[j] == null) continue;
                switch (tdgssMechPropArray[j].getIndex()) {
                    case 16: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0) continue block5;
                        bl2 = true;
                        continue block5;
                    }
                    case 1: {
                        if (tdgssMechPropArray[j].getValue().compareToIgnoreCase("yes") != 0) continue block5;
                        bl = true;
                    }
                }
            }
            if (!bl || !bl2) continue;
            if (log.isDebugEnabled()) {
                log.debug("Client Default Mechanism is: " + oidArray[i].toString());
            }
            return oidArray[i];
        }
        return null;
    }

    public boolean isUsingGeneratedCredentials() {
        return this.usingGeneratedCredentials;
    }

    private static String processEscapeChars(String string) {
        String string2 = "";
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    string2 = string2 + "\\b";
                    continue block6;
                }
                case '\n': {
                    string2 = string2 + "\\n";
                    continue block6;
                }
                case '\t': {
                    string2 = string2 + "\\t";
                    continue block6;
                }
                case '/': 
                case '@': 
                case '\\': {
                    string2 = string2 + "\\" + c;
                    continue block6;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

