/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.SerialNumber;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.util.CharSetNames;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import org.ietf.jgss.Oid;

public abstract class GenericTeradataConnection {
    public static final char ANSI_SEMANTICS = 'A';
    public static final char TD_SEMANTICS = 'T';
    public static final char DEFAULT_SEMANTICS = 'D';
    private static final CharSetNames CHARSET_NAMES = new CharSetNames();
    protected TDNetworkIOIF io;
    protected String machineName;
    protected URLParameters urlParams;
    protected Log log;
    private long m_nLoginEndTime = 0L;
    private SQLWarning m_sqlWarningChain = null;
    private final Object m_oWarningChainMutex = new Object();
    protected ConfigRspParcel configRsp;
    private SerialNumber m_requestNum = new SerialNumber();
    private SerialNumber m_authenticationNonce = new SerialNumber();
    private boolean m_bSuppressReconnect = false;
    public static final int PACKET_64KB = 1;
    public static final int PACKET_BIG = 2;

    protected GenericTeradataConnection(String string, URLParameters uRLParameters) throws SQLException {
        this.machineName = string;
        this.log = new Log(this.toString());
        this.updateURLParameters(uRLParameters);
        if (this.urlParams.getLoginTimeout() != 0) {
            this.m_nLoginEndTime = System.currentTimeMillis() + (long)(this.urlParams.getLoginTimeout() * 1000);
        }
    }

    public abstract LogonInformation getLogonInformation();

    public abstract TDNetworkIOIF getIO() throws JDBCException;

    public abstract String getlogmech();

    public abstract String getlogdata();

    public abstract void addServerAuthMech(AuthMechanism var1);

    public abstract ArrayList getServerAuthMechs();

    public abstract boolean serverHasAuthMechs();

    public abstract AuthMechanism getAuthMethod();

    public abstract void setAuthMethod(AuthMechanism var1);

    public abstract Oid getServerDefaultAuthMethodOid();

    public abstract void setServerDefaultAuthMethodOid(Oid var1);

    public abstract boolean getUsingClientDefaultMech();

    public abstract void setUsingClientDefaultMech(boolean var1);

    public abstract boolean isUTF_CredentialSupported();

    public abstract void setUTF_CredentialSupported(boolean var1);

    public abstract GenericTeraEncrypt getTeraEncrypt();

    public abstract void setTeraEncrypt(GenericTeraEncrypt var1);

    public abstract boolean getSSOSupported();

    public abstract void setSSOSupported(boolean var1);

    public abstract boolean getEncryptData();

    public abstract boolean getEncryptPassword();

    public abstract void setEncryptPassword(boolean var1);

    public abstract void setAssignRspParcel(AssignRspParcel var1);

    public abstract void setLogonSequenceNumberParcel(LogonSequenceNumberParcel var1);

    public abstract void setSessionNum(int var1);

    public abstract int getSessionNum();

    public abstract byte getTdSessionCharSetCode() throws JDBCException;

    public char getTransactionSemantics() {
        return this.urlParams.getTransactMode().charAt(0);
    }

    public boolean isAnsiMode() {
        return this.getTransactionSemantics() == 'A' || this.getTransactionSemantics() == 'D' && this.configRsp.getDefaultTransactionSemantics() == 'A';
    }

    public int getMaxMessageSize(boolean bl, boolean bl2) {
        return (bl2 ? 52 : 0) + (bl ? this.configRsp.getMaxRequestMessageBodySize() : this.configRsp.getMaxResponseMessageBodySize());
    }

    public TDPacket createPacket(int n) {
        switch (n) {
            case 1: {
                return new TDPacket(65156);
            }
            case 2: {
                return new TDPacket(this.getMaxMessageSize(true, true));
            }
        }
        throw new IllegalArgumentException("Invalid value for nPacketOption=" + n);
    }

    public String getMachineName() {
        return this.machineName;
    }

    public int getMachinePort() {
        return this.urlParams.getDbsPort();
    }

    public URLParameters getURLParameters() {
        return this.urlParams;
    }

    public String getSessionJavaCharSet() {
        return CHARSET_NAMES.getMappedName(this.urlParams.getCharSet());
    }

    public String getSerializeDeserializeCharset() {
        if (this.urlParams.getClientCharset() != null) {
            return this.urlParams.getClientCharset();
        }
        return this.getSessionJavaCharSet();
    }

    public Log getLog() {
        return this.log;
    }

    public int checkRemainingLoginTime() throws JDBCException {
        if (this.m_nLoginEndTime == 0L) {
            return 0;
        }
        long l = this.m_nLoginEndTime - System.currentTimeMillis();
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ589", this.machineName);
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (this.log.canLog(2)) {
            this.log.timing("Login time remaining is " + l + " ms");
        }
        return (int)l;
    }

    public boolean isClosed() throws SQLException {
        return this.io == null || this.io.isClosed();
    }

    protected void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            return this.m_sqlWarningChain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            this.m_sqlWarningChain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(SQLWarning sQLWarning) {
        Object object = this.m_oWarningChainMutex;
        synchronized (object) {
            if (this.m_sqlWarningChain != null) {
                this.m_sqlWarningChain.setNextWarning(sQLWarning);
            } else {
                this.m_sqlWarningChain = sQLWarning;
            }
        }
    }

    public boolean supportsPasswordChange() {
        return false;
    }

    public void setNeedNewPassword(boolean bl) {
    }

    public void updateURLParameters(URLParameters uRLParameters) throws SQLException {
        this.log.setLogLevel(uRLParameters.getLogLevel());
        if (this.urlParams == null) {
            this.urlParams = uRLParameters;
        } else {
            this.urlParams.setLogLevel(uRLParameters.getLogLevel());
            this.urlParams.setSpl(uRLParameters.getSpl());
            this.urlParams.setLobSupport(uRLParameters.isLobSupported());
            this.urlParams.setSipSupport(uRLParameters.sipSupport());
            this.urlParams.setTimestampNano(uRLParameters.getTimestampNano());
            this.urlParams.setTimeNano(uRLParameters.getTimeNano());
            this.urlParams.setCharSet(uRLParameters.getCharSet());
        }
        if (this.getSessionJavaCharSet() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ302", this.urlParams.getCharSet());
        }
    }

    public boolean isExtObjectNameParcelSupported() {
        return this.configRsp != null && this.configRsp.isExtObjectNameParcelSupported();
    }

    public int getRequestNum() {
        return this.m_requestNum.getIntNextValue();
    }

    public int getCurrentRequestNum() {
        return this.m_requestNum.getIntCurrentValue();
    }

    public void setCurrentRequestNum(int n) {
        this.m_requestNum.setLongCurrentValue(n);
    }

    public long getAuthenticationNonce() {
        return this.m_authenticationNonce.getLongNextValue();
    }

    public long readAuthenticationNonce() {
        return this.m_authenticationNonce.getLongCurrentValue();
    }

    public void setAuthenticationNonce(long l) {
        this.m_authenticationNonce.setLongCurrentValue(l);
    }

    public ConfigRspParcel getConfigResponse() {
        return this.configRsp;
    }

    public void setConfigResponse(ConfigRspParcel configRspParcel) {
        this.configRsp = configRspParcel;
    }

    public Blob constructLocatorBlob(long l, byte[] byArray) {
        return null;
    }

    public Clob constructLocatorClob(long l, byte[] byArray) {
        return null;
    }

    public TeraSQLXML constructLocatorSQLXML(short s, long l, byte[] byArray) {
        return null;
    }

    public boolean hasResponseNullIndicatorBits() {
        return true;
    }

    public boolean isLobSupported() {
        return this.configRsp.getLOBSupport() && this.urlParams.isLobSupported();
    }

    public boolean isStatementInfoSupported() {
        return this.configRsp.isStatementInfoSupported() && this.urlParams.sipSupport();
    }

    public void suppressReconnect() {
        this.m_bSuppressReconnect = true;
    }

    public boolean isReconnectEnabled() {
        return (this.urlParams.getReconnectCount() != 0 || this.urlParams.getReconnectInterval() != 0) && !this.m_bSuppressReconnect;
    }
}

