/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.fastload.FastLoadCSVConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerConnection;
import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.regex.Matcher;

public abstract class FastLoadCSVPreparedStatement {
    private static final int DEFAULT_FASTLOAD_MAX_SESSION_COUNT = 8;
    private static final int DATE_STRING_LENGTH = 10;
    private static final int FLOAT_STRING_LENGTH = new Double(Double.MAX_VALUE).toString().length() + 2;
    private static final int RESP_PARCEL_LENGTH = 6;
    private static final int INITIAL_INDIC_DATA_PARCEL_LENGTH = 4;
    private Connection m_conManager = null;
    private TDSession m_controlSession = null;
    private Connection[] m_aconFastLoad = null;
    private boolean m_bFastLoading = false;
    private String m_sMachineName = null;
    private String m_sUserName = null;
    private String m_sPassword = null;
    private String m_sTableName = null;
    private String m_sBeginLoading = null;
    private String m_sUsingInsert = null;
    private Statement m_stmtControl = null;
    private PreparedStatement[] m_apstmtFastLoad = null;
    private ResultSet[] m_arsFastLoad = null;
    private int[] m_anFastLoadRequestNumbers = null;
    private int m_iFastLoadPrepStmt = 0;
    private InputStream m_instream = null;
    private byte[][] m_aabyRequestMessage = new byte[2][65156];
    private int m_iRequestMessage = 0;
    private ByteBuffer[] m_abbufRequestMessage = new ByteBuffer[2];
    private int m_iFirstIndicDataParcel = 0;
    private int m_nColumnCount = 0;
    private byte m_byFieldSeparator;
    private int m_nNullIndicatorByteCount = 0;
    private int m_nSerializedRowCount = 0;
    private boolean m_bIsClosed = false;
    private boolean m_bFastLoadSessionsConnected = false;
    private String m_sOriginalSQL = null;
    private SQLWarning m_sqlWarnings = null;

    public FastLoadCSVPreparedStatement(FastLoadCSVConnection fastLoadCSVConnection, String string, String string2, String string3, String string4) throws SQLException {
        this.m_conManager = (Connection)((Object)fastLoadCSVConnection);
        this.m_sMachineName = string;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        this.m_sOriginalSQL = string4;
        this.initializeFastLoad();
    }

    protected void abortIfClosed() throws SQLException {
        if (this.m_conManager.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.m_bIsClosed) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ700", n);
        }
    }

    private void initializeFastLoad() throws SQLException {
        try {
            this.connectFastLoad();
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ691");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    private static ByteBuffer getCharsetEncodedByteBuffer(String string, String string2) throws CharacterCodingException {
        Charset charset = Charset.forName(string2);
        CharBuffer charBuffer = CharBuffer.wrap(string);
        return charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).encode(charBuffer);
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            sQLException.setNextException(sQLException2);
        }
        return sQLException;
    }

    private void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.m_sqlWarnings == null) {
            this.m_sqlWarnings = sQLWarning;
        } else {
            this.m_sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    private int getSessionsCount(int n) throws SQLException {
        int n2;
        int n3 = Integer.parseInt(this.m_controlSession.getAMPCount());
        if (n == 0) {
            n2 = Math.min(8, n3);
        } else {
            n2 = Math.min(n, n3);
            if (n2 < n) {
                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ616", String.valueOf(n), String.valueOf(n2), this.m_sUsingInsert);
                this.chainSQLWarnings(sQLWarning);
            }
        }
        return n2;
    }

    private void connectFastLoad() throws SQLException {
        if (!this.m_bFastLoadSessionsConnected) {
            SQLException sQLException = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                int n6;
                URLParameters uRLParameters = ((FastLoadCSVConnection)((Object)this.m_conManager)).getURLParameters();
                String string = uRLParameters.getFieldSeparator();
                n3 = uRLParameters.getSessions();
                URLParameters uRLParameters2 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "tmode" + "=TERA" + "," + "CONNECT_FUNCTION" + "=" + 1);
                this.m_controlSession = (TDSession)((Object)ConnectionFactory.createConnection(this.m_sMachineName, this.m_sUserName, this.m_sPassword, uRLParameters2));
                n = Integer.parseInt(this.m_controlSession.getAMPCount());
                this.prepareFastLoad();
                this.validateFieldSeparator(string);
                this.m_stmtControl = this.m_controlSession.createStatement();
                n2 = this.getSessionsCount(n3);
                URLParameters uRLParameters3 = new URLParameters(uRLParameters.getDelegatedParameters() + "," + "TYPE" + "=" + "RAW" + "," + "PARTITION" + "=" + "FASTLOAD" + "," + "CONNECT_FUNCTION" + "=" + 2 + "," + "LOGON_SEQUENCE_NUMBER" + "=" + this.m_controlSession.getLogonSequenceNumber());
                this.m_aconFastLoad = new Connection[n2];
                for (n6 = 0; n6 < this.m_aconFastLoad.length; ++n6) {
                    this.m_aconFastLoad[n6] = ConnectionFactory.createConnection(this.m_sMachineName, this.m_sUserName, this.m_sPassword, uRLParameters3);
                    ++n4;
                }
                this.m_apstmtFastLoad = new PreparedStatement[this.m_aconFastLoad.length];
                for (n6 = 0; n6 < this.m_apstmtFastLoad.length; ++n6) {
                    this.m_apstmtFastLoad[n6] = this.m_aconFastLoad[n6].prepareStatement(null);
                    ++n5;
                }
                this.m_arsFastLoad = new ResultSet[this.m_apstmtFastLoad.length];
                this.m_anFastLoadRequestNumbers = new int[this.m_apstmtFastLoad.length];
                Arrays.fill(this.m_anFastLoadRequestNumbers, 1);
                for (n6 = 0; n6 < this.m_aabyRequestMessage.length; ++n6) {
                    this.m_aabyRequestMessage[n6][0] = 3;
                    this.m_aabyRequestMessage[n6][1] = 1;
                    this.m_aabyRequestMessage[n6][2] = 5;
                    this.m_aabyRequestMessage[n6][37] = this.m_controlSession.getTdSessionCharSetCode();
                    this.m_abbufRequestMessage[n6] = ByteBuffer.wrap(this.m_aabyRequestMessage[n6]);
                    this.m_abbufRequestMessage[n6].position(52);
                }
                this.m_iFirstIndicDataParcel = this.m_abbufRequestMessage[0].position();
                this.m_iFastLoadPrepStmt = 0;
                this.m_iRequestMessage = 0;
                this.m_controlSession.getLog().info("FastLoad found " + n + " AMP (s) in " + this.m_sMachineName + " and created " + n4 + " FastLoadConnection (s) and " + n5 + " FastLoadPreparedStatement (s) with SESSIONS=" + n3 + ".");
                this.m_bFastLoadSessionsConnected = true;
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                try {
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ690", String.valueOf(n), String.valueOf(n4), String.valueOf(n5), String.valueOf(n3));
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private String getTeradataTypeCast(int n, FullContentMetadataItem fullContentMetadataItem, String string) throws SQLException {
        String string2 = null;
        String string3 = fullContentMetadataItem.getCustomerVisibleColumnTypeName();
        if (string3.equals("BIGINT") || string3.equals("BYTEINT") || string3.equals("INTEGER") || string3.equals("SMALLINT")) {
            string2 = "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 1) + ")";
        } else if (string3.equals("FLOAT")) {
            string2 = "VARCHAR (" + FLOAT_STRING_LENGTH + ")";
        } else if (string3.equals("DATE")) {
            string2 = "VARCHAR (10)";
        } else if (string3.endsWith("CHAR") || string3.startsWith("INTERVAL")) {
            if (string3.endsWith("CHAR") && this.m_controlSession.getURLParameters().getCharSet().equals("ASCII") && fullContentMetadataItem.getCharsetCode() != 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ708", String.valueOf(n));
            }
            string2 = "VARCHAR (" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
        } else if (string3.equals("DECIMAL")) {
            string2 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 1) + ")" : "VARCHAR (" + (fullContentMetadataItem.getTotalNumberOfDigits() + 2) + ")";
        } else if (string3.startsWith("TIME")) {
            if (string3.startsWith("TIMESTAMP")) {
                int n2;
                int n3 = n2 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "VARCHAR (" + (25 + n2) + ")" : "VARCHAR (" + (19 + n2) + ")";
            } else {
                int n4;
                int n5 = n4 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "VARCHAR (" + (14 + n4) + ")" : "VARCHAR (" + (8 + n4) + ")";
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ546", string3, String.valueOf(n));
        }
        return string2;
    }

    private void prepareFastLoad() throws SQLException {
        Object object;
        PreparedStatement preparedStatement = this.m_controlSession.prepareStatement(this.m_sOriginalSQL);
        String string = this.m_controlSession.getURLParameters().getCharSet();
        if (!string.equals("ASCII") && !string.equals("UTF8")) {
            throw ErrorFactory.makeDriverJDBCException("TJ701", string);
        }
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)preparedStatement);
        MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
        if (metaDataList.size() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ628");
        }
        if (metaDataList.size() > 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ541");
        }
        TeraResultSetMetaData teraResultSetMetaData = metaDataList.getFirstMetaData();
        if (!ActivityAnalyzer.isFastLoadCompatible(teraResultSetMetaData.getActivityType())) {
            throw ErrorFactory.makeDriverJDBCException("TJ542");
        }
        if (tDPreparedStatement.hasGeneratedKeysRequest()) {
            throw ErrorFactory.makeDriverJDBCException("TJ543");
        }
        if (!this.m_controlSession.isStatementInfoSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ696");
        }
        ArrayList arrayList = tDPreparedStatement.getParameterMarkerMetaData();
        Matcher matcher = FastLoadManagerConnection.matchInsertValuesStatement(tDPreparedStatement.getOriginalSql());
        if (!matcher.matches()) {
            throw ErrorFactory.makeDriverJDBCException("TJ544");
        }
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer("USING ");
        StringBuffer stringBuffer2 = new StringBuffer(" INSERT INTO ");
        StringBuffer stringBuffer3 = new StringBuffer(" VALUES ( ");
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (FullContentMetadataItem)arrayList.get(i);
            String string4 = this.getTeradataTypeCast(i + 1, (FullContentMetadataItem)object, string);
            if (i == 0) {
                string2 = ((FullContentMetadataItem)object).getDatabaseName();
                string3 = ((FullContentMetadataItem)object).getProcedureOrTableName();
                stringBuffer2.append(FastLoadManagerConnection.quoteName(string2) + "." + FastLoadManagerConnection.quoteName(string3) + " ( ");
            } else {
                stringBuffer.append(", ");
                stringBuffer2.append(", ");
                stringBuffer3.append(", ");
            }
            String string5 = ((FullContentMetadataItem)object).getColumnOrParameterName();
            stringBuffer.append(FastLoadManagerConnection.quoteName("F_" + string5) + " (" + string4 + ")");
            stringBuffer2.append(FastLoadManagerConnection.quoteName(string5));
            stringBuffer3.append(":" + FastLoadManagerConnection.quoteName("F_" + string5));
        }
        stringBuffer2.append(" )");
        stringBuffer3.append(" )");
        this.m_sTableName = FastLoadManagerConnection.quoteName(string2) + "." + FastLoadManagerConnection.quoteName(string3);
        String string6 = FastLoadManagerConnection.quoteName(string2) + "." + FastLoadManagerConnection.quoteName(string3 + "_ERR_1");
        object = FastLoadManagerConnection.quoteName(string2) + "." + FastLoadManagerConnection.quoteName(string3 + "_ERR_2");
        this.m_sBeginLoading = "BEGIN LOADING " + this.m_sTableName + " ERRORFILES " + string6 + ", " + (String)object + " WITH INTERVAL";
        this.m_sUsingInsert = stringBuffer.toString() + stringBuffer2.toString() + stringBuffer3.toString();
        this.m_controlSession.getLog().info("FastLoad " + this.m_sUsingInsert);
    }

    private void validateFieldSeparator(String string) throws SQLException {
        String string2 = string;
        if (string2.equals("\\")) {
            throw ErrorFactory.makeDriverJDBCException("TJ703", string);
        }
        if (string.length() == 6 && string.startsWith("\\u")) {
            try {
                string2 = String.valueOf((char)Integer.parseInt(string.substring(2, string.length()), 16));
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ704", string);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
        try {
            ByteBuffer byteBuffer = FastLoadCSVPreparedStatement.getCharsetEncodedByteBuffer(string2, this.m_controlSession.getSerializeDeserializeCharset());
            if (byteBuffer.remaining() != 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ706", string);
            }
            this.m_byFieldSeparator = byteBuffer.get();
            if (this.m_byFieldSeparator == 13 || this.m_byFieldSeparator == 10 || this.m_byFieldSeparator == 34) {
                throw ErrorFactory.makeDriverJDBCException("TJ707", string);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ705", string, this.m_controlSession.getURLParameters().getCharSet());
            jDBCException.initCause(exception);
            throw jDBCException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected) {
            SQLException sQLException = null;
            try {
                JDBCException jDBCException;
                int n;
                if (this.m_arsFastLoad != null) {
                    for (n = 0; n < this.m_arsFastLoad.length; ++n) {
                        if (this.m_arsFastLoad[n] == null) continue;
                        try {
                            this.m_arsFastLoad[n].close();
                            continue;
                        }
                        catch (SQLException sQLException2) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ693", n, this.m_arsFastLoad.length);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        }
                    }
                }
                if (this.m_apstmtFastLoad != null) {
                    for (n = 0; n < this.m_apstmtFastLoad.length; ++n) {
                        if (this.m_apstmtFastLoad[n] == null) continue;
                        try {
                            this.m_apstmtFastLoad[n].close();
                            continue;
                        }
                        catch (SQLException sQLException3) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ694", n, this.m_apstmtFastLoad.length);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                        }
                    }
                }
                if (this.m_stmtControl != null) {
                    try {
                        this.m_stmtControl.close();
                    }
                    catch (SQLException sQLException4) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                    }
                }
                if (this.m_aconFastLoad != null) {
                    for (int i = 0; i < this.m_aconFastLoad.length; ++i) {
                        if (this.m_aconFastLoad[i] == null) continue;
                        try {
                            this.m_aconFastLoad[i].close();
                            continue;
                        }
                        catch (SQLException sQLException5) {
                            jDBCException = ErrorFactory.makeDriverJDBCException("TJ695", i, this.m_aconFastLoad.length);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                        }
                    }
                }
                if (this.m_controlSession != null) {
                    try {
                        this.m_controlSession.close();
                    }
                    catch (SQLException sQLException6) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                    }
                }
                Object var6_12 = null;
                this.m_bFastLoadSessionsConnected = false;
                this.m_arsFastLoad = null;
                this.m_apstmtFastLoad = null;
                this.m_stmtControl = null;
                this.m_aconFastLoad = null;
                this.m_controlSession = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.m_bFastLoadSessionsConnected = false;
                this.m_arsFastLoad = null;
                this.m_apstmtFastLoad = null;
                this.m_stmtControl = null;
                this.m_aconFastLoad = null;
                this.m_controlSession = null;
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ692");
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private void beginFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && !this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                this.abortFastLoad();
                try {
                    this.m_stmtControl.execute(this.m_sBeginLoading);
                    this.m_bFastLoading = true;
                    this.m_controlSession.setAutoCommit(false);
                    this.m_stmtControl.executeUpdate(this.m_sUsingInsert);
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    this.abortFastLoad();
                }
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ460", this.m_sTableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    private void abortFastLoad() throws SQLException {
        if (!this.m_bFastLoadSessionsConnected) {
            return;
        }
        SQLException sQLException = null;
        boolean bl = false;
        try {
            if (this.m_bFastLoading) {
                try {
                    this.flushRequestMessage();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
                this.closeFastLoad();
                this.connectFastLoad();
            } else {
                try {
                    this.m_stmtControl.executeQuery("SELECT 1 FROM " + this.m_sTableName + " WHERE 1=2");
                }
                catch (SQLException sQLException3) {
                    if (sQLException3.getErrorCode() == 2652) {
                        bl = true;
                    }
                    throw sQLException3;
                }
            }
            if (this.m_bFastLoading || bl) {
                this.m_controlSession.setAutoCommit(true);
                this.m_stmtControl.execute(this.m_sBeginLoading);
                this.m_controlSession.setAutoCommit(false);
                this.m_stmtControl.executeUpdate("END LOADING");
                this.m_controlSession.commit();
                this.m_controlSession.setAutoCommit(true);
                this.m_stmtControl.executeUpdate("DELETE " + this.m_sTableName + " ALL");
            }
        }
        catch (SQLException sQLException4) {
            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ477", this.m_sTableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                try {
                    try {
                        this.flushRequestMessage();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    }
                    this.m_stmtControl.executeUpdate("CHECKPOINT LOADING END");
                    this.m_controlSession.commit();
                    int n = this.m_stmtControl.executeUpdate("END LOADING");
                    if (n != this.m_nSerializedRowCount) {
                        SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ476", String.valueOf(this.m_nSerializedRowCount - n), this.m_sTableName, String.valueOf(this.m_nSerializedRowCount), String.valueOf(n));
                        ((FastLoadCSVConnection)((Object)this.m_conManager)).chainSQLWarnings(sQLWarning);
                    }
                    this.m_controlSession.commit();
                    this.m_controlSession.setAutoCommit(true);
                    this.closeFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    try {
                        this.abortFastLoad();
                    }
                    catch (SQLException sQLException4) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                    }
                    Object var5_9 = null;
                    this.m_bFastLoading = false;
                    this.m_nSerializedRowCount = 0;
                    this.m_nColumnCount = 0;
                    this.m_nNullIndicatorByteCount = 0;
                    if (this.m_bIsClosed) {
                        ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                    }
                }
                Object var5_8 = null;
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                }
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ461", this.m_sTableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackFastLoad() throws SQLException {
        if (this.m_bFastLoadSessionsConnected && this.m_bFastLoading) {
            SQLException sQLException = null;
            try {
                block9: {
                    try {
                        this.abortFastLoad();
                        if (!this.m_bIsClosed) break block9;
                        this.closeFastLoad();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        Object var4_3 = null;
                        this.m_bFastLoading = false;
                        this.m_nSerializedRowCount = 0;
                        this.m_nColumnCount = 0;
                        this.m_nNullIndicatorByteCount = 0;
                        if (this.m_bIsClosed) {
                            ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                        }
                    }
                }
                Object var4_2 = null;
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_bFastLoading = false;
                this.m_nSerializedRowCount = 0;
                this.m_nColumnCount = 0;
                this.m_nNullIndicatorByteCount = 0;
                if (this.m_bIsClosed) {
                    ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                }
                throw throwable;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ478", this.m_sTableName);
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    protected boolean isFastLoading() {
        return this.m_bFastLoading;
    }

    private int setParcelHeader(int n) {
        int n2 = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)n);
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)4);
        return n2;
    }

    private void setParcelLength(int n) {
        int n2 = this.m_abbufRequestMessage[this.m_iRequestMessage].position() - n;
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort(n + 2, (short)n2);
    }

    private void addRespParcel() {
        int n = this.setParcelHeader(4);
        this.m_abbufRequestMessage[this.m_iRequestMessage].putShort((short)-380);
        this.setParcelLength(n);
    }

    private void sendRequestMessage() throws SQLException {
        this.addRespParcel();
        int n = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
        int n2 = n - 52;
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(n2);
        this.m_aabyRequestMessage[this.m_iRequestMessage][3] = byArray[0];
        this.m_aabyRequestMessage[this.m_iRequestMessage][4] = byArray[1];
        this.m_aabyRequestMessage[this.m_iRequestMessage][8] = byArray[2];
        this.m_aabyRequestMessage[this.m_iRequestMessage][9] = byArray[3];
        this.m_abbufRequestMessage[this.m_iRequestMessage].putInt(32, this.m_anFastLoadRequestNumbers[this.m_iFastLoadPrepStmt]);
        if (this.m_arsFastLoad[this.m_iFastLoadPrepStmt] != null) {
            this.receiveResponseMessage(this.m_aconFastLoad[this.m_iFastLoadPrepStmt], this.m_arsFastLoad[this.m_iFastLoadPrepStmt]);
        }
        this.m_apstmtFastLoad[this.m_iFastLoadPrepStmt].setObject(1, (Object)this.m_aabyRequestMessage[this.m_iRequestMessage], -2, n);
        this.m_arsFastLoad[this.m_iFastLoadPrepStmt] = this.m_apstmtFastLoad[this.m_iFastLoadPrepStmt].executeQuery();
        int n3 = this.m_iFastLoadPrepStmt;
        this.m_anFastLoadRequestNumbers[n3] = this.m_anFastLoadRequestNumbers[n3] + 1;
        this.m_iFastLoadPrepStmt = (this.m_iFastLoadPrepStmt + 1) % this.m_apstmtFastLoad.length;
    }

    private void receiveResponseMessage(Connection connection, ResultSet resultSet) throws SQLException {
        byte[] byArray;
        ByteBuffer byteBuffer;
        int n;
        if (resultSet.next() && (n = (byteBuffer = ByteBuffer.wrap(byArray = resultSet.getBytes(1))).getShort(52) & Short.MAX_VALUE) != 8) {
            TDPacket tDPacket = new TDPacket(0);
            tDPacket.getBuffer().setBuffer(byArray);
            tDPacket.initParcelFactory((RawConnection)((Object)connection));
            Parcel parcel = null;
            block6: while ((parcel = tDPacket.nextParcel()) != null) {
                ((RawConnection)((Object)connection)).getLog().debug("Parcel flavor: " + parcel.getFlavor());
                switch (parcel.getFlavor()) {
                    case 8: {
                        SuccessParcel successParcel = (SuccessParcel)parcel;
                        continue block6;
                    }
                    case 9: {
                        FailureParcel failureParcel = (FailureParcel)parcel;
                        ((RawConnection)((Object)connection)).getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        ((RawConnection)((Object)connection)).getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    case 12: {
                        return;
                    }
                }
                ((RawConnection)((Object)connection)).getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
            }
            ((RawConnection)((Object)connection)).getLog().error("Did not receive an expected parcel from the database");
            throw ErrorFactory.makeIoJDBCException("TJ420", "FastLoadCSVPreparedStatement.receiveResponseMessage", ((RawConnection)((Object)connection)).getIO(), null, ((RawConnection)((Object)connection)).getLog());
        }
    }

    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        this.m_instream = null;
    }

    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int executeUpdate() throws SQLException {
        SQLException sQLException;
        block34: {
            this.abortIfClosed();
            if (this.m_instream == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ698");
            }
            this.initializeFastLoad();
            sQLException = null;
            try {
                int n;
                this.clearWarnings();
                this.beginFastLoad();
                int n2 = this.m_iFirstIndicDataParcel;
                boolean bl = true;
                int n3 = 0;
                byte[] byArray = null;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                boolean bl2 = true;
                byte by = 10;
                byte[] byArray2 = new byte[0x100000];
                while ((n = this.m_instream.read(byArray2)) >= 0) {
                    for (int i = 0; i < n; ++i) {
                        int n9;
                        by = byArray2[i];
                        if (this.m_nColumnCount == 0) {
                            n9 = by == 10 ? 1 : 0;
                            if (n9 == 0 && by != this.m_byFieldSeparator) continue;
                            ++n7;
                            if (n9 == 0) continue;
                            bl2 = false;
                            this.m_nColumnCount = n7;
                            this.m_nNullIndicatorByteCount = (this.m_nColumnCount + 7) / 8;
                            continue;
                        }
                        if (bl) {
                            boolean bl3;
                            n9 = this.m_nNullIndicatorByteCount + this.m_nColumnCount * 2;
                            boolean bl4 = bl3 = 4 + n9 + 1 + 6 <= this.m_abbufRequestMessage[this.m_iRequestMessage].remaining();
                            if (!bl3) {
                                this.sendRequestMessage();
                                this.m_abbufRequestMessage[this.m_iRequestMessage].position(this.m_iFirstIndicDataParcel);
                            }
                            n2 = this.setParcelHeader(68);
                            n3 = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n3 + this.m_nNullIndicatorByteCount);
                            byArray = new byte[this.m_nNullIndicatorByteCount];
                            n4 = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
                            n5 = n4 + 2;
                            bl = false;
                        } else if (n5 + 1 + 6 > this.m_aabyRequestMessage[this.m_iRequestMessage].length) {
                            n9 = this.m_iRequestMessage + 1 < this.m_aabyRequestMessage.length ? this.m_iRequestMessage + 1 : 0;
                            System.arraycopy(this.m_aabyRequestMessage[this.m_iRequestMessage], n2, this.m_aabyRequestMessage[n9], this.m_iFirstIndicDataParcel, n5 - n2);
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n2);
                            this.sendRequestMessage();
                            this.m_iRequestMessage = n9;
                            n4 = n4 - n2 + this.m_iFirstIndicDataParcel;
                            n5 = n5 - n2 + this.m_iFirstIndicDataParcel;
                            n2 = this.m_iFirstIndicDataParcel;
                            n3 = n2 + 4;
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n3 + this.m_nNullIndicatorByteCount);
                        }
                        if (by == 13) continue;
                        if (by == 10) {
                            if (bl2) {
                                bl2 = false;
                                continue;
                            }
                            if (this.m_nColumnCount != n8 + 1) {
                                this.m_abbufRequestMessage[this.m_iRequestMessage].position(n2);
                                throw ErrorFactory.makeDriverJDBCException("TJ697", this.m_nSerializedRowCount + 1, n8 + 1, this.m_nColumnCount);
                            }
                            if (n6 == 0) {
                                int n10 = n9 = n8 / 8;
                                byArray[n10] = (byte)(byArray[n10] | (byte)(1 << 7 - n8 % 8));
                            }
                            this.m_aabyRequestMessage[this.m_iRequestMessage][n4] = (byte)(n6 >> 8 & 0xFF);
                            this.m_aabyRequestMessage[this.m_iRequestMessage][n4 + 1] = (byte)(n6 & 0xFF);
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n5);
                            n9 = this.m_abbufRequestMessage[this.m_iRequestMessage].position();
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n3);
                            this.m_abbufRequestMessage[this.m_iRequestMessage].put(byArray);
                            this.m_abbufRequestMessage[this.m_iRequestMessage].position(n9);
                            this.setParcelLength(n2);
                            bl = true;
                            n6 = 0;
                            n8 = 0;
                            ++this.m_nSerializedRowCount;
                            continue;
                        }
                        if (bl2) continue;
                        if (by == this.m_byFieldSeparator) {
                            if (n6 == 0) {
                                int n11 = n9 = n8 / 8;
                                byArray[n11] = (byte)(byArray[n11] | (byte)(1 << 7 - n8 % 8));
                            }
                            this.m_aabyRequestMessage[this.m_iRequestMessage][n4] = (byte)(n6 >> 8 & 0xFF);
                            this.m_aabyRequestMessage[this.m_iRequestMessage][n4 + 1] = (byte)(n6 & 0xFF);
                            if (n5 + 2 + 6 > this.m_aabyRequestMessage[this.m_iRequestMessage].length) {
                                n9 = this.m_iRequestMessage + 1 < this.m_aabyRequestMessage.length ? this.m_iRequestMessage + 1 : 0;
                                System.arraycopy(this.m_aabyRequestMessage[this.m_iRequestMessage], n2, this.m_aabyRequestMessage[n9], this.m_iFirstIndicDataParcel, n5 - n2);
                                this.m_abbufRequestMessage[this.m_iRequestMessage].position(n2);
                                this.sendRequestMessage();
                                this.m_iRequestMessage = n9;
                                n4 = n4 - n2 + this.m_iFirstIndicDataParcel;
                                n2 = this.m_iFirstIndicDataParcel;
                                n3 = n2 + 4;
                                this.m_abbufRequestMessage[this.m_iRequestMessage].position(n3 + this.m_nNullIndicatorByteCount);
                            }
                            n5 = (n4 += n6 + 2) + 2;
                            n6 = 0;
                            ++n8;
                            continue;
                        }
                        this.m_aabyRequestMessage[this.m_iRequestMessage][n5++] = by;
                        ++n6;
                    }
                }
                if (by != 10) {
                    this.m_abbufRequestMessage[this.m_iRequestMessage].position(n2);
                    throw ErrorFactory.makeDriverJDBCException("TJ702");
                }
                Object var19_24 = null;
                this.m_instream = null;
            }
            catch (Throwable throwable) {
                Object var19_28 = null;
                this.m_instream = null;
                if (this.m_conManager.getAutoCommit()) {
                    try {
                        this.endFastLoad();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    }
                }
                throw throwable;
            }
            if (this.m_conManager.getAutoCommit()) {
                try {
                    this.endFastLoad();
                }
                catch (SQLException sQLException3) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                }
            }
            break block34;
            {
                catch (IOException iOException) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ680", this.m_sTableName);
                    jDBCException.initCause(iOException);
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                    Object var19_25 = null;
                    this.m_instream = null;
                    if (this.m_conManager.getAutoCommit()) {
                        try {
                            this.endFastLoad();
                        }
                        catch (SQLException sQLException4) {
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                        }
                    }
                    break block34;
                }
                catch (SQLException sQLException5) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ680", this.m_sTableName);
                    jDBCException.setNextException(sQLException5);
                    jDBCException.initCause(sQLException5);
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                    Object var19_26 = null;
                    this.m_instream = null;
                    if (this.m_conManager.getAutoCommit()) {
                        try {
                            this.endFastLoad();
                        }
                        catch (SQLException sQLException6) {
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
                        }
                    }
                    break block34;
                }
                catch (Exception exception) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ680", this.m_sTableName);
                    jDBCException.initCause(exception);
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                    Object var19_27 = null;
                    this.m_instream = null;
                    if (this.m_conManager.getAutoCommit()) {
                        try {
                            this.endFastLoad();
                        }
                        catch (SQLException sQLException7) {
                            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException7);
                        }
                    }
                }
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return 0;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (n2 != -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ699", n2);
        }
        this.m_instream = inputStream;
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.m_sqlWarnings = null;
        if (this.m_bFastLoadSessionsConnected) {
            this.m_stmtControl.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        SQLException sQLException = null;
        try {
            block8: {
                try {
                    if (this.m_bFastLoading) break block8;
                    this.closeFastLoad();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    Object var4_3 = null;
                    this.m_bIsClosed = true;
                    if (!this.m_bFastLoading) {
                        ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
                    }
                }
            }
            Object var4_2 = null;
            this.m_bIsClosed = true;
            if (!this.m_bFastLoading) {
                ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_bIsClosed = true;
            if (!this.m_bFastLoading) {
                ((FastLoadCSVConnection)((Object)this.m_conManager)).removeStatement(this);
            }
            throw throwable;
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ466", this.m_sTableName);
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    private void flushRequestMessage() throws SQLException {
        SQLException sQLException = null;
        try {
            if (this.m_abbufRequestMessage[this.m_iRequestMessage].position() > this.m_iFirstIndicDataParcel) {
                try {
                    this.sendRequestMessage();
                }
                catch (SQLException sQLException2) {
                    sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            if (this.m_arsFastLoad != null) {
                for (int i = 0; i < this.m_arsFastLoad.length; ++i) {
                    if (this.m_arsFastLoad[i] == null) continue;
                    try {
                        this.receiveResponseMessage(this.m_aconFastLoad[i], this.m_arsFastLoad[i]);
                        continue;
                    }
                    catch (SQLException sQLException3) {
                        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ693", i, this.m_arsFastLoad.length);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
                        sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
            }
        }
        catch (Exception exception) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ727");
            jDBCException.initCause(exception);
            sQLException = FastLoadCSVPreparedStatement.chainSQLExceptions(sQLException, jDBCException);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.m_conManager;
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        if (this.m_bFastLoadSessionsConnected) {
            this.chainSQLWarnings(this.m_stmtControl.getWarnings());
            this.m_stmtControl.clearWarnings();
        }
        return this.m_sqlWarnings;
    }

    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean isClosed() throws SQLException {
        return this.m_bIsClosed;
    }

    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        this.m_instream = inputStream;
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (l != -1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ699", String.valueOf(l));
        }
        this.m_instream = inputStream;
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }
}

