/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ManagerConnectionBase;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FastLoadManagerConnection
extends ManagerConnectionBase {
    private List fastloads = Collections.synchronizedList(new ArrayList());

    public FastLoadManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
    }

    private String getTeradataTypeCast(int n, FullContentMetadataItem fullContentMetadataItem, String string) {
        String string2 = null;
        String string3 = fullContentMetadataItem.getCustomerVisibleColumnTypeName();
        if (string3.equals("BIGINT") || string3.equals("BYTEINT") || string3.equals("DATE") || string3.equals("FLOAT") || string3.equals("INTEGER") || string3.equals("SMALLINT")) {
            string2 = string3;
        } else if (string3.endsWith("BYTE")) {
            string2 = "VARBYTE(" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
        } else if (string3.endsWith("CHAR") || string3.startsWith("INTERVAL")) {
            string2 = "VARCHAR(" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
        } else if (string3.equals("DECIMAL")) {
            string2 = string3 + "(" + this.m_appSession.getMaxDecimalPrecision() + "," + fullContentMetadataItem.getNumberOfFractionalDigits() + ")";
        } else if (string3.startsWith("TIME")) {
            int n2 = 1;
            if (string.equals("UTF16")) {
                n2 = 2;
            }
            if (string3.startsWith("TIMESTAMP")) {
                int n3;
                int n4 = n3 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "CHAR(" + n2 * (25 + n3) + ")" : "CHAR(" + n2 * (19 + n3) + ")";
            } else {
                int n5;
                int n6 = n5 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                string2 = string3.endsWith("ZONE") ? "CHAR(" + n2 * (14 + n5) + ")" : "CHAR(" + n2 * (8 + n5) + ")";
            }
        } else {
            this.getLog().info("Cannot FastLoad because a data type of " + string3 + " in column " + n + " of the destination database table is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ546", string3, String.valueOf(n));
            this.addWarning(sQLWarning);
        }
        return string2;
    }

    public static String quoteName(String string) {
        return string == null ? string : "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }

    public static String unquoteName(String string) {
        return string == null || string.length() < 2 || !string.startsWith("\"") ? string : string.substring(1, string.length() - 1).replaceAll("\"\"", "\"");
    }

    private static String caseTeradataTypeCodes(String string, String string2, String string3) {
        return "cast ((coalesce (case " + string + " when 'AT' then " + 760 + " when 'BF' then " + 692 + " when 'BO' then " + 400 + " when 'BV' then " + 688 + " when 'CF' then case " + string2 + " when 4 then " + 468 + " else " + 452 + " end" + " when 'CO' then " + 416 + " when 'CV' then case " + string2 + " when 4 then " + 464 + " else " + 448 + " end" + " when 'D'  then " + 484 + " when 'DA' then " + 752 + " when 'DH' then " + 792 + " when 'DM' then " + 796 + " when 'DS' then " + 800 + " when 'DY' then " + 788 + " when 'F'  then " + 480 + " when 'GF' then " + 468 + " when 'GV' then " + 464 + " when 'HM' then " + 808 + " when 'HR' then " + 804 + " when 'HS' then " + 812 + " when 'I1' then " + 756 + " when 'I2' then " + 500 + " when 'I'  then " + 496 + " when 'I8' then " + 600 + " when 'MI' then " + 816 + " when 'MO' then " + 784 + " when 'MS' then " + 820 + " when 'SC' then " + 824 + " when 'SZ' then " + 772 + " when 'TS' then " + 764 + " when 'TZ' then " + 768 + " when 'YM' then " + 780 + " when 'YR' then " + 776 + " else null end" + " +" + " case " + string3 + " when 'Y' then 1" + " else 0 end" + ", 0))" + " as smallint)";
    }

    private static String caseMaxLengthInBytes(String string, String string2, String string3, String string4) {
        String string5 = "cast ((" + string2 + " / case " + string3 + " when 2 then 2" + " when 4 then 2" + " else 1 end)" + " * ";
        string5 = string.equals("UTF8") ? string5 + "case " + string3 + " when 1 then 2" + " when 2 then 3" + " else 1 end" : (string.equals("UTF16") ? string5 + "case " + string3 + " when 0 then (case " + string4 + " when 'AT' then 2" + " when 'DH' then 2" + " when 'DM' then 2" + " when 'DS' then 2" + " when 'DY' then 2" + " when 'HM' then 2" + " when 'HR' then 2" + " when 'HS' then 2" + " when 'MI' then 2" + " when 'MO' then 2" + " when 'MS' then 2" + " when 'SC' then 2" + " when 'SZ' then 2" + " when 'TS' then 2" + " when 'TZ' then 2" + " when 'YM' then 2" + " when 'YR' then 2" + " else 1 end)" + " else 2 end" : (string.equals("KANJISJIS_0S") || string.equals("KANJIEUC_0U") ? string5 + "case " + string3 + " when 2 then 2" + " else 1 end" : string5 + "1"));
        string5 = string5 + " as integer)";
        return string5;
    }

    private static String caseMaxLengthInChars(String string, String string2) {
        String string3 = "cast ((" + string + " / case " + string2 + " when 2 then 2" + " when 4 then 2" + " else 1 end)";
        string3 = string3 + " as integer)";
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList createMetadataItemsFromDataDictionary(TDSession tDSession, String string, String string2, String string3) throws SQLException {
        ArrayList<FullContentMetadataItem> arrayList = new ArrayList<FullContentMetadataItem>();
        PreparedStatement preparedStatement = tDSession.prepareStatement("locking row for access select trim(DatabaseName), trim(TableName), trim(ColumnName), " + FastLoadManagerConnection.caseTeradataTypeCodes("ColumnType", "CharType", "Nullable") + "," + " " + FastLoadManagerConnection.caseMaxLengthInBytes(string, "ColumnLength", "CharType", "ColumnType") + "," + " DecimalTotalDigits," + " DecimalFractionalDigits," + " Nullable," + " " + FastLoadManagerConnection.caseMaxLengthInChars("ColumnLength", "CharType") + " from dbc.columns" + " where upper(DatabaseName) = upper((coalesce(?, database)))" + " and upper(TableName) = upper(?)");
        try {
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                FullContentMetadataItem fullContentMetadataItem = new FullContentMetadataItem(1, 1, 0);
                fullContentMetadataItem.setDatabaseName(resultSet.getString(1));
                fullContentMetadataItem.setProcedureOrTableName(resultSet.getString(2));
                fullContentMetadataItem.setColumnOrParameterName(resultSet.getString(3));
                fullContentMetadataItem.setDataType(resultSet.getShort(4));
                fullContentMetadataItem.setMaxDataLengthInBytes(resultSet.getInt(5));
                fullContentMetadataItem.setTotalNumberOfDigits(resultSet.getShort(6));
                fullContentMetadataItem.setNumberOfFractionalDigits(resultSet.getShort(7));
                fullContentMetadataItem.setIsNullable((byte)resultSet.getString(8).charAt(0));
                fullContentMetadataItem.setMaxNumberOfCharacters(resultSet.getInt(9));
                arrayList.add(fullContentMetadataItem);
            }
        }
        finally {
            preparedStatement.close();
        }
        return arrayList;
    }

    public static Matcher matchInsertValuesStatement(String string) {
        String string2 = "(?is)\\s*INSERT\\s+INTO\\s+(?:([^\"][^\\s.]*|\"(?:\"\"|[^\"])*\")\\s*\\.\\s*)?([^\"][^\\s]*|\"(?:\"\"|[^\"])*\")\\s*(?:\\((.*)\\))?\\s*(?:VALUES)?\\s*\\([\\s?,]+\\)\\s*(?:;\\s*)?";
        return Pattern.compile(string2).matcher(string);
    }

    private static SQLWarning createInsertStatementParameterMarkerMetadata(Log log, TDSession tDSession, String string, Matcher matcher, ArrayList arrayList) throws SQLException {
        Object object;
        Matcher matcher2;
        String string2 = FastLoadManagerConnection.unquoteName(matcher.group(1));
        String string3 = FastLoadManagerConnection.unquoteName(matcher.group(2));
        String string4 = matcher.group(3);
        ArrayList<String> arrayList2 = string4 != null ? new ArrayList<String>() : null;
        String string5 = "\\s*,\\s*([^\"][^\\s,]*|\"(?:\"\"|[^\"])*\")";
        Matcher matcher3 = matcher2 = string4 != null ? Pattern.compile(string5).matcher("," + string4) : null;
        while (arrayList2 != null && matcher2 != null && matcher2.find()) {
            arrayList2.add(FastLoadManagerConnection.unquoteName(matcher2.group(1)).toUpperCase());
        }
        ArrayList arrayList3 = FastLoadManagerConnection.createMetadataItemsFromDataDictionary(tDSession, string, string2, string3);
        LinkedHashMap<String, FullContentMetadataItem> linkedHashMap = new LinkedHashMap<String, FullContentMetadataItem>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            object = (FullContentMetadataItem)iterator.next();
            linkedHashMap.put(((FullContentMetadataItem)object).getColumnOrParameterName().toUpperCase(), (FullContentMetadataItem)object);
        }
        if (arrayList2 == null) {
            arrayList.addAll(arrayList3);
        } else {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)linkedHashMap.get(object);
                if (fullContentMetadataItem == null) {
                    log.info("Column name " + (String)object + " was not found in table's columns: " + linkedHashMap.keySet());
                    return ErrorFactory.makeSQLWarning("TJ545", (String)object, linkedHashMap.keySet().toString());
                }
                arrayList.add(fullContentMetadataItem);
            }
        }
        return null;
    }

    protected synchronized PreparedStatement createManagerPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        Object object;
        String string = this.getURLParameters().getCharSet();
        if (!(string.equals("ASCII") || string.equals("UTF8") || string.equals("UTF16") || string.equals("KANJISJIS_0S") || string.equals("KANJIEUC_0U"))) {
            this.getLog().info("Cannot FastLoad because the specified Java Character Encoding is not supported: " + string);
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ540", string);
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)preparedStatement);
        MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
        if (metaDataList.size() == 0) {
            this.getLog().info("Cannot FastLoad because no metadata is available.");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ628");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        if (metaDataList.size() > 1) {
            this.getLog().info("Cannot FastLoad a multi-statement request!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ541");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        TeraResultSetMetaData teraResultSetMetaData = metaDataList.getFirstMetaData();
        if (!ActivityAnalyzer.isFastLoadCompatible(teraResultSetMetaData.getActivityType())) {
            this.getLog().info("Cannot FastLoad because statement is not an INSERT!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ542");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        if (tDPreparedStatement.hasGeneratedKeysRequest()) {
            this.getLog().info("Cannot FastLoad because auto-generated key retrieval was requested, but is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ543");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        ArrayList arrayList = null;
        if (this.m_appSession.isStatementInfoSupported()) {
            arrayList = tDPreparedStatement.getParameterMarkerMetaData();
        }
        SQLWarning sQLWarning = null;
        Matcher matcher = FastLoadManagerConnection.matchInsertValuesStatement(tDPreparedStatement.getOriginalSql());
        if (!matcher.matches()) {
            this.getLog().info("Cannot FastLoad because the INSERT statement does not match the required syntax.");
            sQLWarning = ErrorFactory.makeSQLWarning("TJ544");
        } else if (arrayList == null) {
            arrayList = new ArrayList();
            sQLWarning = FastLoadManagerConnection.createInsertStatementParameterMarkerMetadata(this.getLog(), this.m_appSession, string, matcher, arrayList);
            if (sQLWarning != null) {
                this.getLog().info("Cannot FastLoad because metadata could not be obtained for the destination table.");
                object = ErrorFactory.makeSQLWarning("TJ559");
                this.addWarning((SQLWarning)object);
            }
        }
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        object = null;
        String string2 = null;
        String string3 = "USING ";
        String string4 = " INSERT INTO ";
        String string5 = " VALUES ( ";
        for (int i = 0; i < arrayList.size(); ++i) {
            FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)arrayList.get(i);
            String string6 = this.getTeradataTypeCast(i + 1, fullContentMetadataItem, string);
            if (string6 == null) {
                return preparedStatement;
            }
            if (i == 0) {
                object = fullContentMetadataItem.getDatabaseName();
                string2 = fullContentMetadataItem.getProcedureOrTableName();
                string4 = string4 + FastLoadManagerConnection.quoteName((String)object) + "." + FastLoadManagerConnection.quoteName(string2) + " ( ";
            } else {
                string3 = string3 + ", ";
                string4 = string4 + ", ";
                string5 = string5 + ", ";
            }
            String string7 = fullContentMetadataItem.getColumnOrParameterName();
            string3 = string3 + FastLoadManagerConnection.quoteName("F_" + string7) + " (" + string6 + ")";
            string4 = string4 + FastLoadManagerConnection.quoteName(string7);
            string5 = string5 + ":" + FastLoadManagerConnection.quoteName("F_" + string7);
        }
        string4 = string4 + " )";
        string5 = string5 + " )";
        String string8 = string3 + string4 + string5;
        this.getLog().info("FastLoad " + string8);
        preparedStatement = this.constructPreparedStatement(this.machineName, this.userName, this.password, (String)object, string2, string8, preparedStatement, arrayList);
        this.fastloads.add(preparedStatement);
        return preparedStatement;
    }

    protected synchronized void removeStatement(Object object) {
        this.fastloads.remove(object);
    }

    public synchronized String getLogonSequenceNumber() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.fastloads.size(); ++i) {
            FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)this.fastloads.get(i);
            if (!fastLoadManagerPreparedStatement.isConnected()) continue;
            if (!bl) {
                string = string + ",";
            } else {
                bl = false;
            }
            string = string + fastLoadManagerPreparedStatement.hashCode() + ",";
            string = string + fastLoadManagerPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.fastloads);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)arrayList.get(i);
                    boolean bl = fastLoadManagerPreparedStatement.isFastLoading();
                    try {
                        fastLoadManagerPreparedStatement.close();
                        if (!bl) continue;
                        fastLoadManagerPreparedStatement.rollbackFastLoad();
                        fastLoadManagerPreparedStatement.closeFastLoad();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                        continue;
                    }
                    finally {
                        if (bl) {
                            this.removeStatement(fastLoadManagerPreparedStatement);
                        }
                    }
                }
                this.m_appSession.close();
            }
            catch (SQLException sQLException3) {
                sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
            }
            finally {
                this.connected = false;
            }
            if (sQLException != null) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ457");
                jDBCException.setNextException(sQLException);
                throw jDBCException;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).endFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.m_appSession.commit();
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ458");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    public synchronized void rollback() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).rollbackFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, jDBCException);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.m_appSession.rollback();
        }
        catch (SQLException sQLException3) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
        }
        if (sQLException != null) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ474");
            jDBCException.setNextException(sQLException);
            throw jDBCException;
        }
    }

    protected abstract PreparedStatement constructPreparedStatement(String var1, String var2, String var3, String var4, String var5, String var6, PreparedStatement var7, ArrayList var8) throws SQLException;
}

