/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.SizeConstrainedMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResponseTracker {
    private Map m_mapOpenResponses = Collections.synchronizedMap(new SizeConstrainedMap(20));

    public void notifyCancelResponse(TDPacket tDPacket) {
        this.m_mapOpenResponses.remove(new Integer(tDPacket.getRequestNumber()));
    }

    public void notifyReceiveResponse(StatementController statementController, TDPacket tDPacket, Log log) throws SQLException {
        if (!log.canLog(1)) {
            return;
        }
        int n = tDPacket.nextParcelPeek();
        if (n < 0) {
            return;
        }
        if (n == 49 || n == 9) {
            int n2 = tDPacket.getCurrentPosition();
            ErrorParcel errorParcel = (ErrorParcel)tDPacket.nextParcel();
            tDPacket.skipParcel(-1 * (tDPacket.getCurrentPosition() - n2));
            if (errorParcel.getCode() == 3130) {
                LinkedHashMap linkedHashMap = new LinkedHashMap(this.m_mapOpenResponses);
                int n3 = 1;
                Iterator iterator = linkedHashMap.values().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    log.info(errorParcel.getMsg() + " Open response " + n3 + " of " + linkedHashMap.size() + " is request number " + string);
                    ++n3;
                }
            }
        } else if (tDPacket.getLANKind() == 5 && (statementController.getMode() == 66 || statementController.getMode() == 69) && statementController.getStatement().useKeepResponse()) {
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter((Writer)stringWriter, true));
            String string = stringWriter.toString().trim();
            int n4 = string.indexOf(Log.LINE_SEP);
            if (n4 >= 0) {
                string = string.substring(n4);
            }
            string = tDPacket.getRequestNumber() + " submitted " + Log.currentDateTime() + " by [" + Thread.currentThread().getName() + "]" + Log.LINE_SEP + statementController.getQuery() + string;
            this.m_mapOpenResponses.put(new Integer(tDPacket.getRequestNumber()), string);
        }
    }
}

