/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.ResultArray;
import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.ResultStruct;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.ResultSetRowContext;
import com.teradata.jdbc.jdbc_4.ResultSetUpdater;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TDResultSet
implements ResultSetRowContext {
    protected int m_nResultSetType = 1003;
    protected SQLWarning m_sqlWarning;
    protected boolean m_bMetaDataRS;
    protected Statement m_stmt;
    protected ResultSetHelper m_helper;
    protected ResultSetUpdater m_updater;
    private RowFetchController m_controller;
    private int m_nRequestNumber;
    private int m_nStatementNumber;
    private int m_nFetchSize;
    private int m_nFetchDirection;
    private int m_nActivityCount = 0;
    private int m_nExecuteActivityType = 0;
    protected int m_nCurrentRowNumber = 0;
    protected ResultSetRow m_rowCurrent = null;
    protected List m_listFetchedRows = new ArrayList();
    protected int m_nFirstFetchedRowNumber = 1;
    private boolean m_bMoreToFetch = false;
    private TeraResultSetMetaData m_rsmd = null;
    private boolean m_bWasNull = false;
    private int m_nTotalAvailableRowCount = -1;
    private boolean m_bResultSetClosed = false;
    protected Log log;
    private FetchedRowsPostProcessor m_postprocessor;
    private static final String OPTIONAL_SPACES = " *";
    private static final Pattern PATTERN_INTEGER_DATE = Pattern.compile(" *(-?\\d{3,8}) *");
    private static final Pattern PATTERN_2_DIGIT_YEAR = Pattern.compile("(\\d{2})/(\\d{2})/(\\d{2}) *");
    private static final Pattern PATTERN_ANSI_DATE = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2}) *");
    private static final Pattern PATTERN_TIMESTAMP = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})(?:[.](\\d{1,6}))?([-+]\\d{2}:\\d{2})? *");
    private static final Pattern PATTERN_TIME = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})(?:[.](\\d{1,6}))?([-+]\\d{2}:\\d{2})? *");

    protected TDResultSet(TeraResultSetMetaData teraResultSetMetaData, int n, ResultSetHelper resultSetHelper, Statement statement, RowFetchController rowFetchController, Log log) throws SQLException {
        this.m_stmt = statement;
        this.m_helper = resultSetHelper;
        this.m_rsmd = teraResultSetMetaData;
        this.m_nExecuteActivityType = n;
        this.log = log;
        this.m_controller = rowFetchController;
        if (this.m_controller != null) {
            this.m_nRequestNumber = this.m_controller.getCurrentRequestNumber();
            this.m_nStatementNumber = this.m_controller.getCurrentStatementNumber();
            this.m_nFetchSize = this.m_controller.getRowFetchSize();
            this.m_nFetchDirection = this.m_controller.getRowFetchDirection();
        }
        if (this.m_stmt != null) {
            if (this.m_stmt.getResultSetConcurrency() == 1008) {
                if (this.m_rsmd != null) {
                    for (int i = 0; i < this.m_rsmd.getColumnCount() && this.m_updater == null; ++i) {
                        ColumnProperties columnProperties = this.m_rsmd.getColumnProperties(i + 1);
                        if (!columnProperties.isUnique() && !columnProperties.isKeyColumn()) continue;
                        this.m_updater = new ResultSetUpdater(this.m_rsmd, this.m_stmt.getConnection(), this.log);
                    }
                }
                if (this.m_updater == null) {
                    this.log.debug("ResultSet: downgraded concurrency from updatable result set to read-only because the result set had no unique columns or key columns");
                    this.m_helper.addWarning(ErrorFactory.makeSQLWarning("TJ500"));
                }
            }
            switch (this.m_stmt.getResultSetType()) {
                case 1004: 
                case 1005: {
                    this.m_nResultSetType = 1004;
                }
            }
        }
    }

    public void setNumberOfRows(int n) {
        this.m_nActivityCount = n;
    }

    public int getNumberOfRows() {
        return this.m_nActivityCount;
    }

    public int getExecuteActivityType() {
        return this.m_nExecuteActivityType;
    }

    protected int getRowCount() {
        int n = this.m_controller == null ? 0 : this.m_controller.getMaxFetchRows();
        int n2 = this.m_nTotalAvailableRowCount >= 0 ? this.m_nTotalAvailableRowCount : this.m_nActivityCount;
        return n > 0 ? Math.min(n, n2) : n2;
    }

    protected Object getObjectFromCurrentRow(int n) throws SQLException {
        this.validateRowPositionForGet(String.valueOf(n));
        Object object = this.m_rowCurrent == null ? null : this.m_rowCurrent.getValue(n - 1);
        this.m_bWasNull = object == null;
        return object;
    }

    public void addResultSetRow(ResultSetRow resultSetRow) throws JDBCException {
        if (this.m_bResultSetClosed) {
            String string = "ResultSet.addResultSetRow was called for a closed result set; m_listFetchedRows.size=" + this.m_listFetchedRows.size() + " this=" + this;
            this.log.error(string);
            throw new IllegalStateException(string);
        }
        if (this.m_controller != null) {
            int n = this.m_controller.getMaxFetchFieldSize();
            int n2 = this.m_rsmd.getColumnCount();
            for (int i = 1; i <= n2; ++i) {
                int n3 = this.m_rsmd.getColumnBaseJDBCType(i);
                if (n <= 0 || !this.validTruncationType(n3)) continue;
                this.limitColumn(resultSetRow, i - 1, n);
            }
        }
        this.m_listFetchedRows.add(resultSetRow);
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.addResultSetRow added row with " + resultSetRow.size() + " columns; m_listFetchedRows.size=" + this.m_listFetchedRows.size() + " this=" + this);
        }
    }

    private boolean validTruncationType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private void limitColumn(ResultSetRow resultSetRow, int n, int n2) throws JDBCException {
        String string;
        Object object = resultSetRow.getValue(n);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                resultSetRow.setValue(n, byArray2);
            }
        } else if (object instanceof String && (string = (String)object).length() > n2) {
            resultSetRow.setValue(n, string.substring(0, n2));
        }
    }

    public boolean isMoreToFetch() {
        return this.m_bMoreToFetch;
    }

    public void setMoreToFetch(boolean bl) {
        this.m_bMoreToFetch = bl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.setMoreToFetch m_bMoreToFetch=" + this.m_bMoreToFetch + " this=" + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean goToRow(int n) throws SQLException {
        boolean bl;
        block15: {
            boolean bl2;
            block14: {
                boolean bl3;
                block13: {
                    if (this.isClosed()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ598");
                    }
                    this.cancelRowChanges();
                    try {
                        boolean bl4;
                        boolean bl5;
                        if (this.m_controller != null) {
                            if (!this.m_controller.registerStatement()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("ResultSet.goToRow: cleanup has already started");
                                }
                                boolean bl6 = false;
                                Object var10_4 = null;
                                if (this.m_controller == null) return bl6;
                                this.m_controller.unregisterStatement();
                                return bl6;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ResultSet.goToRow: cleanup has not started");
                            }
                        }
                        this.m_rowCurrent = null;
                        int n2 = this.getRowCount();
                        this.m_nCurrentRowNumber = n < 0 ? 0 : (n > n2 + 1 ? n2 + 1 : n);
                        boolean bl7 = this.m_nCurrentRowNumber == 0;
                        boolean bl8 = this.m_nCurrentRowNumber == n2 + 1;
                        boolean bl9 = bl5 = bl7 || bl8;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ResultSet.goToRow nAbsolute=" + n + " bBeforeFirstRow=" + bl7 + " bAfterLastRow=" + bl8 + " bInvalidRow=" + bl5 + " nRowCount=" + n2);
                        }
                        if (bl5) {
                            bl3 = false;
                            break block13;
                        }
                        int n3 = this.m_nFirstFetchedRowNumber + this.m_listFetchedRows.size();
                        boolean bl10 = bl4 = this.m_nCurrentRowNumber >= this.m_nFirstFetchedRowNumber && this.m_nCurrentRowNumber < n3;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ResultSet.goToRow m_nCurrentRowNumber=" + this.m_nCurrentRowNumber + " m_nFirstFetchedRowNumber=" + this.m_nFirstFetchedRowNumber + " m_listFetchedRows.size=" + this.m_listFetchedRows.size() + " nBeyondFetchRowNumber=" + n3 + " bAlreadyFetched=" + bl4);
                        }
                        if (!bl4) {
                            this.m_listFetchedRows.clear();
                            this.m_nFirstFetchedRowNumber = this.m_nCurrentRowNumber;
                            this.m_controller.fetchRows(this, this.m_nRequestNumber, this.m_nStatementNumber, this.m_nCurrentRowNumber, n3);
                            if (this.m_listFetchedRows.isEmpty()) {
                                bl2 = false;
                                break block14;
                            }
                            if (this.m_postprocessor != null) {
                                this.m_postprocessor.processRows(this.m_nFirstFetchedRowNumber, this.m_listFetchedRows);
                            }
                        }
                        this.m_rowCurrent = (ResultSetRow)this.m_listFetchedRows.get(this.m_nCurrentRowNumber - this.m_nFirstFetchedRowNumber);
                        bl = true;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        if (this.m_controller == null) throw throwable;
                        this.m_controller.unregisterStatement();
                        throw throwable;
                    }
                }
                Object var10_5 = null;
                if (this.m_controller == null) return bl3;
                this.m_controller.unregisterStatement();
                return bl3;
            }
            Object var10_6 = null;
            if (this.m_controller == null) return bl2;
            this.m_controller.unregisterStatement();
            return bl2;
        }
        Object var10_7 = null;
        if (this.m_controller == null) return bl;
        this.m_controller.unregisterStatement();
        return bl;
    }

    public void setFetchedRowsPostProcessor(FetchedRowsPostProcessor fetchedRowsPostProcessor) throws SQLException {
        this.m_postprocessor = fetchedRowsPostProcessor;
        if (this.m_postprocessor != null && !this.m_listFetchedRows.isEmpty()) {
            this.m_postprocessor.processRows(this.m_nFirstFetchedRowNumber, this.m_listFetchedRows);
        }
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this.m_rsmd);
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean bl) throws SQLException {
        boolean bl2 = false;
        this.internalClose(bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            try {
                if (this.m_controller != null && this.m_controller.getFinalizeAutoClose()) {
                    this.internalClose(true);
                }
            }
            finally {
                super.finalize();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void internalClose(boolean bl) throws SQLException {
        this.internalClose(bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose(boolean bl, boolean bl2) throws SQLException {
        TDResultSet tDResultSet;
        if (this.m_bResultSetClosed) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSet.close: already closed, this=" + this);
            }
            return;
        }
        TDResultSet tDResultSet2 = tDResultSet = this.m_controller != null ? this.m_controller.getCloseMutex() : this;
        synchronized (tDResultSet2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSet.close: upon entry m_bResultSetClosed=" + this.m_bResultSetClosed + ", this=" + this);
            }
            if (this.m_bResultSetClosed) {
                return;
            }
            this.m_bResultSetClosed = true;
            if (this.m_controller != null) {
                this.m_controller.closingResultSet(bl, bl2);
            }
        }
        if (this.m_bMetaDataRS && this.m_stmt != null) {
            this.m_stmt.close();
        }
    }

    public void suppressResponseCancel() {
        this.m_bResultSetClosed = true;
        if (this.m_controller != null) {
            this.m_controller.suppressResponseCancel();
        }
    }

    public int getRequestNumber() {
        return this.m_nRequestNumber;
    }

    public int getStatementNumber() {
        return this.m_nStatementNumber;
    }

    public void setStartingRowPosition(long l) throws JDBCException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw ErrorFactory.makeDriverJDBCException("TJ627", String.valueOf(l));
        }
        int n = (int)l;
        this.m_nCurrentRowNumber = n == 0 ? 0 : n - 1;
        this.m_nFirstFetchedRowNumber = n == 0 ? 1 : n;
    }

    public boolean wasNull() {
        return this.m_bWasNull;
    }

    public int getConcurrency() {
        return this.m_updater != null ? 1008 : 1007;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        if (n >= 0) {
            return this.goToRow(n);
        }
        return this.goToRow(this.getRowCount() + 1 + n);
    }

    public void afterLast() throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        this.goToRow(this.getRowCount() + 1);
    }

    public void beforeFirst() throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        this.goToRow(0);
    }

    public boolean first() throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        return this.goToRow(1);
    }

    public int getFetchDirection() {
        return this.m_nFetchDirection;
    }

    public int getFetchSize() {
        return this.m_nFetchSize;
    }

    public int getRow() {
        return this.m_rowCurrent == null ? 0 : this.m_nCurrentRowNumber;
    }

    public int getType() throws SQLException {
        return this.m_nResultSetType;
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_nCurrentRowNumber > this.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.getRowCount() != 0 && this.m_nCurrentRowNumber == 0;
    }

    public boolean isFirst() {
        return this.m_nCurrentRowNumber == 1;
    }

    public boolean isLast() throws SQLException {
        int n = this.getRowCount();
        int n2 = this.m_nFirstFetchedRowNumber + this.m_listFetchedRows.size();
        int n3 = n2 - 1;
        if (this.m_nCurrentRowNumber == n3 && this.m_nCurrentRowNumber < n && n == 0x7FFFFFFE) {
            this.m_listFetchedRows.clear();
            this.m_nFirstFetchedRowNumber = n2;
            this.m_controller.fetchRows(this, this.m_nRequestNumber, this.m_nStatementNumber, n2, n2);
            if (!this.m_listFetchedRows.isEmpty() && this.m_postprocessor != null) {
                this.m_postprocessor.processRows(n2, this.m_listFetchedRows);
            }
            this.m_listFetchedRows.add(0, this.m_rowCurrent);
            this.m_nFirstFetchedRowNumber = this.m_nCurrentRowNumber;
            n = this.getRowCount();
        }
        return n != 0 && this.m_nCurrentRowNumber == n;
    }

    public boolean last() throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        return this.goToRow(this.getRowCount());
    }

    public boolean next() throws SQLException {
        return this.goToRow(this.m_nCurrentRowNumber + 1);
    }

    public boolean previous() throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        return this.goToRow(this.m_nCurrentRowNumber - 1);
    }

    public void refreshRow() throws SQLException {
        if (this.m_updater != null) {
            this.m_updater.refreshRow();
        }
    }

    public boolean relative(int n) throws SQLException {
        if (this.m_nResultSetType == 1003) {
            throw ErrorFactory.makeDriverJDBCException("TJ319");
        }
        return this.goToRow(this.m_nCurrentRowNumber + n);
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.getType() == 1003 && n != 1000) {
            throw ErrorFactory.makeDriverJDBCException("TJ320");
        }
        this.m_nFetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        int n2;
        int n3 = n2 = this.m_controller == null ? 0 : this.m_controller.getMaxFetchRows();
        if (n < 0 || n2 > 0 && n > n2) {
            throw ErrorFactory.makeDriverJDBCException("TJ321", n);
        }
        this.m_nFetchSize = n;
    }

    public void lastRowFetched() {
        this.m_nTotalAvailableRowCount = this.m_nFirstFetchedRowNumber + this.m_listFetchedRows.size() - 1;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.lastRowFetched m_nTotalAvailableRowcount=" + this.m_nTotalAvailableRowCount);
        }
    }

    public boolean isClosed() {
        return this.m_bResultSetClosed;
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateInt(this, n, n2);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateDouble(this, n, d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateBigDecimal(this, n, bigDecimal);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateBlob(this, n, blob);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateByte(this, n, by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateBytes(this, n, byArray);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateClob(this, n, clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateDate(this, n, date);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateFloat(this, n, f);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateLong(this, n, l);
    }

    public void updateNull(int n) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateNull(this, n);
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateShort(this, n, s);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateString(this, n, string);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateTime(this, n, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateTimestamp(this, n, timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateAsciiStream(this, n, inputStream, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateBinaryStream(this, n, inputStream, n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateCharacterStream(this, n, reader, n2);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateObject(this, n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateObject(this, n, object, n2);
    }

    public void updateRow() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.updateRow(this);
    }

    public void deleteRow() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.deleteRow(this);
    }

    public void insertRow() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.insertRow();
    }

    public void moveToInsertRow() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.moveToCurrentRow();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.m_updater == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ501");
        }
        this.m_updater.cancelRowUpdates();
    }

    protected void cancelRowChanges() throws SQLException {
        if (this.m_updater != null) {
            this.m_updater.cancelRowChanges();
        }
    }

    public void validateRowPositionForGet(String string) throws SQLException {
        if (this.getRowCount() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ630", string);
        }
        if (this.isBeforeFirst()) {
            throw ErrorFactory.makeDriverJDBCException("TJ632", string);
        }
        if (this.isAfterLast()) {
            throw ErrorFactory.makeDriverJDBCException("TJ633", string);
        }
    }

    public boolean isOnActualRow() throws SQLException {
        return !this.isBeforeFirst() && !this.isAfterLast() && this.getRow() != 0;
    }

    public void setMetadataRS(boolean bl) {
        this.m_bMetaDataRS = bl;
    }

    public static int internalGetInt(Object object) throws SQLException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            try {
                return new Double(((String)object).trim()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ140", (String)object);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
        if (object instanceof byte[]) {
            throw ErrorFactory.makeDriverJDBCException("TJ141");
        }
        throw ErrorFactory.makeDriverJDBCException("TJ142", object.getClass().getName());
    }

    public static long internalGetLong(Object object) throws SQLException {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof String) {
            try {
                return new Double(((String)object).trim()).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ024", (String)object);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ025", object.getClass().getName());
    }

    protected static float internalGetFloat(Object object) throws SQLException {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0f : 0.0f;
        }
        if (object instanceof String) {
            try {
                return new Float(((String)object).trim()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ026", (String)object);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ027", object.getClass().getName());
    }

    public static double internalGetDouble(Object object) throws SQLException {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof String) {
            try {
                return new Double(((String)object).trim());
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ028", (String)object);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ029", object.getClass().getName());
    }

    public static BigDecimal internalGetBigDecimal(Object object, int n) throws SQLException {
        BigDecimal bigDecimal;
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)object;
        } else if (object instanceof Float || object instanceof Double) {
            bigDecimal = new BigDecimal(((Number)object).doubleValue());
        } else if (object instanceof Number) {
            bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
        } else if (object instanceof Boolean) {
            bigDecimal = BigDecimal.valueOf((Boolean)object != false ? 1L : 0L);
        } else if (object instanceof String) {
            try {
                bigDecimal = new BigDecimal(((String)object).trim());
            }
            catch (NumberFormatException numberFormatException) {
                JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ030", (String)object);
                jDBCException.initCause(numberFormatException);
                throw jDBCException;
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ031", object.getClass().getName());
        }
        if (n > 0) {
            bigDecimal = bigDecimal.setScale(n);
        }
        return bigDecimal;
    }

    public static byte[] internalGetBytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof TeraSQLXML) {
            return ((TeraSQLXML)object).getBytes();
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            return blob.getBytes(1L, (int)Math.min(Integer.MAX_VALUE, blob.length()));
        }
        throw ErrorFactory.makeDriverJDBCException("TJ032", object.getClass().getName());
    }

    protected InputStream internalGetBinaryStream(Object object) throws SQLException {
        return TDResultSet.internalGetBinaryStream(object, this.m_helper.getSerializeDeserializeCharset());
    }

    public static InputStream internalGetBinaryStream(Object object, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof TeraSQLXML) {
            return ((TeraSQLXML)object).internalGetBinaryStream();
        }
        if (!(object instanceof byte[])) {
            try {
                object = object.toString().getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ErrorFactory.makeDriverJDBCException("TJ212", string);
            }
        }
        return new ByteArrayInputStream((byte[])object);
    }

    public SQLWarning getWarnings() {
        return this.m_sqlWarning;
    }

    public void clearWarnings() {
        this.m_sqlWarning = null;
    }

    public String getCursorName() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ038");
    }

    public int findColumn(String string) throws SQLException {
        int n;
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ734");
        }
        int n2 = this.m_rsmd == null ? 0 : this.m_rsmd.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            if (!string.equalsIgnoreCase(this.m_rsmd.getColumnName(n))) continue;
            return n;
        }
        for (n = 1; n <= n2; ++n) {
            if (!string.equalsIgnoreCase(this.m_rsmd.getColumnLabel(n))) continue;
            return n;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ049", string);
    }

    public boolean rowUpdated() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowDeleted() {
        return false;
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Boolean");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Boolean");
    }

    public Statement getStatement() {
        return this.m_stmt;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Ref");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Ref");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Array");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ503", "Array");
    }

    private static Object convertObjectToDateTimeValue(int n, Object object, Calendar calendar, boolean bl, boolean bl2) throws SQLException {
        boolean bl3;
        boolean bl4;
        int n2;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            object = object.toString();
        }
        if (!(object instanceof String)) {
            throw ErrorFactory.makeDriverJDBCException("TJ638", String.valueOf(n), object.getClass().getName(), object.toString());
        }
        String string = (String)object;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        Matcher matcher = PATTERN_INTEGER_DATE.matcher(string);
        if (matcher.matches()) {
            n2 = Integer.parseInt(matcher.group(1)) + 19000000;
            string2 = String.valueOf(n2 / 10000);
            string3 = String.valueOf(n2 % 10000 / 100);
            string4 = String.valueOf(n2 % 100);
        } else {
            matcher = PATTERN_2_DIGIT_YEAR.matcher(string);
            if (matcher.matches()) {
                string2 = "19" + matcher.group(1);
                string3 = matcher.group(2);
                string4 = matcher.group(3);
            } else {
                matcher = PATTERN_ANSI_DATE.matcher(string);
                if (matcher.matches()) {
                    string2 = matcher.group(1);
                    string3 = matcher.group(2);
                    string4 = matcher.group(3);
                } else {
                    matcher = PATTERN_TIMESTAMP.matcher(string);
                    if (matcher.matches()) {
                        string2 = matcher.group(1);
                        string3 = matcher.group(2);
                        string4 = matcher.group(3);
                        string5 = matcher.group(4);
                        string6 = matcher.group(5);
                        string7 = matcher.group(6);
                        if (matcher.groupCount() == 8) {
                            string8 = matcher.group(7);
                            string9 = matcher.group(8);
                        }
                    } else {
                        matcher = PATTERN_TIME.matcher(string);
                        if (matcher.matches()) {
                            string5 = matcher.group(1);
                            string6 = matcher.group(2);
                            string7 = matcher.group(3);
                            if (matcher.groupCount() == 5) {
                                string8 = matcher.group(4);
                                string9 = matcher.group(5);
                            }
                        } else {
                            throw ErrorFactory.makeDriverJDBCException("TJ639", String.valueOf(n), string);
                        }
                    }
                }
            }
        }
        if (bl && string2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ640", String.valueOf(n), string);
        }
        if (bl2 && string5 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ641", String.valueOf(n), string);
        }
        n2 = string9 == null ? 1 : 0;
        boolean bl5 = calendar != null;
        boolean bl6 = bl4 = n2 != 0 && bl5;
        if (bl4) {
            TDResultSet.validateCalendarTimeZone(n, calendar);
        }
        TimeZone timeZone = bl4 ? calendar.getTimeZone() : null;
        boolean bl7 = string9 != null;
        boolean bl8 = bl3 = calendar != null;
        if (bl7 && bl3) {
            TimeZone timeZone2 = TimeZone.getTimeZone("GMT" + string9);
            calendar.setTimeZone(timeZone2);
        }
        int n3 = string2 != null ? Integer.parseInt(string2) : 1970;
        int n4 = string3 != null ? Integer.parseInt(string3) - 1 : 0;
        int n5 = string4 != null ? Integer.parseInt(string4) : 1;
        int n6 = string5 != null ? Integer.parseInt(string5) : 0;
        int n7 = string6 != null ? Integer.parseInt(string6) : 0;
        int n8 = string7 != null ? Integer.parseInt(string7) : 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n4, n5, n6, n7, n8);
        if (timeZone != null) {
            int n9 = timeZone.getRawOffset();
            TimeZone timeZone3 = ((Calendar)gregorianCalendar).getTimeZone();
            timeZone3.setRawOffset(timeZone3.getRawOffset() + n9);
            long l = gregorianCalendar.getTimeInMillis();
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(l);
        }
        if (bl) {
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
        }
        if (bl2) {
            gregorianCalendar.set(1, 1970);
            gregorianCalendar.set(2, 0);
            gregorianCalendar.set(5, 1);
        }
        long l = gregorianCalendar.getTimeInMillis();
        while (string8 != null && string8.length() < 9) {
            string8 = string8 + "0";
        }
        int n10 = string8 != null ? Integer.parseInt(string8) : 0;
        int n11 = n10 / 1000000;
        if (bl) {
            return new Date(l);
        }
        if (bl2) {
            return new Time(l + (long)n11);
        }
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n10);
        return timestamp;
    }

    public static void validateCalendarTimeZone(int n, Calendar calendar) throws SQLException {
        if (calendar.getTimeZone() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ642", n);
        }
    }

    public static Date convertDateWithTimeZoneToGMT(int n, Date date, Calendar calendar) throws SQLException {
        return (Date)TDResultSet.convertObjectToDateTimeValue(n, date.toString(), calendar, true, false);
    }

    public static Date internalGetDate(int n, Object object, Calendar calendar) throws SQLException {
        return (Date)TDResultSet.convertObjectToDateTimeValue(n, object, calendar, true, false);
    }

    public static Time internalGetTime(int n, Object object, Calendar calendar) throws SQLException {
        return (Time)TDResultSet.convertObjectToDateTimeValue(n, object, calendar, false, true);
    }

    public static Timestamp internalGetTimestamp(int n, Object object, Calendar calendar) throws SQLException {
        return (Timestamp)TDResultSet.convertObjectToDateTimeValue(n, object, calendar, false, false);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public static ResultArray internalGetArray(int n, Object object) throws SQLException {
        if (object != null && !(object instanceof ResultArray)) {
            throw ErrorFactory.makeDriverJDBCException("TJ638", String.valueOf(n), object.getClass().getName(), object.toString());
        }
        return (ResultArray)object;
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        return TDResultSet.internalGetArray(n, object);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        this.validateRowPositionForGet(String.valueOf(n));
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getURL");
    }

    public URL getURL(String string) throws SQLException {
        this.validateRowPositionForGet(string);
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getURL");
    }

    public Ref getRef(int n) throws SQLException {
        this.validateRowPositionForGet(String.valueOf(n));
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getRef");
    }

    public Ref getRef(String string) throws SQLException {
        this.validateRowPositionForGet(string);
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getRef");
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        return TDResultSet.internalGetString(object, this.m_helper.getSerializeDeserializeCharset());
    }

    public static String internalGetString(Object object, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof TeraSQLXML) {
            return ((TeraSQLXML)object).internalGetString();
        }
        try {
            if (object instanceof byte[]) {
                return new String((byte[])object, string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", string);
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) != 0;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        return TDResultSet.internalGetInt(this.getObjectFromCurrentRow(n));
    }

    public long getLong(int n) throws SQLException {
        return TDResultSet.internalGetLong(this.getObjectFromCurrentRow(n));
    }

    public float getFloat(int n) throws SQLException {
        return TDResultSet.internalGetFloat(this.getObjectFromCurrentRow(n));
    }

    public double getDouble(int n) throws SQLException {
        return TDResultSet.internalGetDouble(this.getObjectFromCurrentRow(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return TDResultSet.internalGetBigDecimal(this.getObjectFromCurrentRow(n), n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return TDResultSet.internalGetBytes(this.getObjectFromCurrentRow(n));
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Object object = this.getObjectFromCurrentRow(n);
        return TDResultSet.internalGetAsciiStream(object, this.m_helper.getSerializeDeserializeCharset());
    }

    public static InputStream internalGetAsciiStream(Object object, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getAsciiStream();
        }
        try {
            return new ByteArrayInputStream(TDResultSet.internalGetString(object, string).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", "ASCII");
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getString(n).getBytes());
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.internalGetBinaryStream(this.getObjectFromCurrentRow(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        Map<String, Class<?>> map = this.m_stmt != null && this.m_stmt.getConnection() != null ? this.m_stmt.getConnection().getTypeMap() : Collections.EMPTY_MAP;
        return this.internalGetObject(n, map);
    }

    public Object getObject(int n, Map map) throws SQLException {
        map = TDSession.copyAndVerifyTypeMap(map);
        return this.internalGetObject(n, map);
    }

    private Object internalGetObject(int n, Map map) throws SQLException {
        Object object = this.getObjectFromCurrentRow(n);
        int n2 = this.m_rsmd.getColumnType(n);
        int n3 = this.m_rsmd.getColumnBaseJDBCType(n);
        String string = this.m_rsmd.getColumnTypeName(n);
        return TDResultSet.internalGetObject(this.m_helper, n, object, n2, n3, string, map);
    }

    public static Object internalGetObject(ResultSetHelper resultSetHelper, int n, Object object, int n2, int n3, String string, Map map) throws SQLException {
        switch (n2) {
            case 92: {
                if (object instanceof Time) break;
                object = TDResultSet.internalGetTime(n, object, null);
                break;
            }
            case 93: {
                if (object instanceof Timestamp) break;
                object = TDResultSet.internalGetTimestamp(n, object, null);
                break;
            }
            case 91: {
                if (object instanceof Date) break;
                object = TDResultSet.internalGetDate(n, object, null);
                break;
            }
            case 5: {
                if (!(object instanceof Short)) break;
                object = new Integer(((Short)object).intValue());
                break;
            }
            case -6: {
                if (!(object instanceof Byte)) break;
                object = new Integer(((Byte)object).intValue());
                break;
            }
            case 2003: {
                if (object == null) break;
                ((ResultArray)object).setResultSetHelper(resultSetHelper);
                break;
            }
            case 2001: {
                if (object == null) break;
                Class clazz = (Class)map.get(string);
                if (clazz != null) {
                    object = ResultStruct.getSQLData(resultSetHelper, clazz, new Object[]{object}, new int[]{n3}, new int[]{n3}, new String[]{string}, string, map);
                    break;
                }
                object = TDResultSet.internalGetObject(resultSetHelper, n, object, n3, n3, string, map);
                break;
            }
            case 2002: {
                if (object == null || !(object instanceof ResultStruct)) break;
                ResultStruct resultStruct = (ResultStruct)object;
                Object[] objectArray = resultStruct.getMutableMappedAttributeValueArray();
                int[] nArray = resultStruct.getMutableAttributeSQLTypeArray();
                int[] nArray2 = resultStruct.getMutableAttributeBaseJDBCTypeArray();
                String[] stringArray = resultStruct.getMutableAttributeTypeNameArray();
                Class clazz = (Class)map.get(string);
                if (clazz != null) {
                    object = ResultStruct.getSQLData(resultSetHelper, clazz, objectArray, nArray, nArray2, stringArray, resultStruct.getSQLTypeName(), map);
                    break;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = TDResultSet.internalGetObject(resultSetHelper, i + 1, objectArray[i], nArray[i], nArray2[i], stringArray[i], map);
                }
                break;
            }
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.getObjectFromCurrentRow(n);
        return TDResultSet.internalGetCharacterStream(object, this.m_helper.getSerializeDeserializeCharset());
    }

    public static Reader internalGetCharacterStream(Object object, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof TeraSQLXML) {
            return ((TeraSQLXML)object).internalGetCharacterStream();
        }
        return new StringReader(TDResultSet.internalGetString(object, string));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return TDResultSet.internalGetDate(n, this.getObjectFromCurrentRow(n), calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return TDResultSet.internalGetTime(n, this.getObjectFromCurrentRow(n), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return TDResultSet.internalGetTimestamp(n, this.getObjectFromCurrentRow(n), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObjectFromCurrentRow(n);
        return TDResultSet.internalGetBlob(object);
    }

    public static Blob internalGetBlob(Object object) throws SQLException {
        if (object != null && !(object instanceof Blob)) {
            throw ErrorFactory.makeDriverJDBCException("TJ220", object.getClass().getName());
        }
        return (Blob)object;
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObjectFromCurrentRow(n);
        return TDResultSet.internalGetClob(object);
    }

    public static Clob internalGetClob(Object object) throws SQLException {
        if (object != null && !(object instanceof Clob)) {
            throw ErrorFactory.makeDriverJDBCException("TJ221", object.getClass().getName());
        }
        return (Clob)object;
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public void updateNString(int n, String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNString");
    }

    public void updateNString(String string, String string2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNString");
    }

    public String getNString(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNString");
    }

    public String getNString(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNString");
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNCharacterStream");
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNCharacterStream");
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNCharacterStream");
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNCharacterStream");
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream");
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBinaryStream");
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateCharacterStream");
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream");
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBinaryStream");
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateCharacterStream");
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBlob");
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBlob");
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateClob");
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateClob");
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNClob");
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNClob");
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNCharacterStream");
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNCharacterStream");
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream");
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBinaryStream");
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateCharacterStream");
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream");
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBinaryStream");
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateCharacterStream");
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBlob");
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateBlob");
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateClob");
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateClob");
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNClob");
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateNClob");
    }

    public static interface FetchedRowsPostProcessor {
        public void processRows(int var1, List var2) throws SQLException;
    }
}

