/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraDriver;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraSQLOutput;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.client.ClientArray;
import com.teradata.jdbc.client.ClientStruct;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.ResponseTracker;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ConfigController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.ietf.jgss.Oid;

public abstract class TDSession
extends GenericTeradataConnection
implements LocalEscapeFunctions,
ResultSetHelper {
    private boolean bAutoCommit = true;
    private boolean m_bUseAnsiDate = true;
    private LogonInformation logonInformation;
    private boolean transactionInProgress;
    private Mutex sessionLock;
    private int m_nDeferredLobToken = 0;
    private Map m_mapDeferredLobs = new HashMap();
    private boolean encryptPassword = false;
    private GenericTeraEncrypt myEncrypt = null;
    private AuthMechanism authMethod;
    private Oid serverDefaultAuthMethodOid;
    private ArrayList serverAuthMechs = new ArrayList();
    private boolean SSOSupported = false;
    private boolean usingClientDefaultMech = false;
    private boolean cleanUpStatementsStarted = false;
    private Vector statementList = null;
    private AssignRspParcel assignRsp;
    private boolean UTF_CredentialSupported = false;
    private LogonSequenceNumberParcel logonSeqNumParcel = null;
    private int writableLobId = 1;
    private boolean needNewPassword = false;
    private byte m_spReturnResult = 0;
    private Map m_typeMap = Collections.EMPTY_MAP;
    private ResponseTracker m_responseTracker = new ResponseTracker();
    private List m_listCloseCursorsAtCommitStatements = new ArrayList();
    private int m_nHoldabilityForSubsequentStatements = 1;
    static /* synthetic */ Class class$java$sql$SQLData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TDSession(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, uRLParameters);
        Object object;
        this.logonInformation = new LogonInformation(string2, string3);
        if (uRLParameters.getAccountId().compareTo("NO_ACCOUNT_ID") != 0) {
            this.logonInformation.setAccount(uRLParameters.getAccountId());
        }
        this.sessionLock = new Mutex("SessionLock", this.log);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            this.bAutoCommit = false;
            if (this.io == null) {
                object = TeraDriver.getCurrentThreadDefaultConnection();
                this.io = new TDNetworkIOIF(((CurrentThreadIO)object).getOutputStream(), ((CurrentThreadIO)object).getInputStream(), this.log);
            }
            try {
                object = new ConfigController(this);
                ((ConfigController)object).run();
            }
            catch (JDBCException jDBCException) {
                if (this.io != null) {
                    this.io.close();
                }
                throw jDBCException;
            }
        }
        try {
            object = new GenericLogonController(this.logonInformation, this);
            ((GenericLogonController)object).run();
        }
        catch (JDBCException jDBCException) {
            if (this.io != null) {
                this.io.close();
            }
            throw jDBCException;
        }
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.supportsPasswordChange()) {
                object = "MODIFY USER " + this.getLogonInformation().getUserName() + " AS PASSWORD=" + uRLParameters.getNewPassword();
                this.executeSessionRequest("TDSession constructor", false, (String)object, false);
                if (this.isAnsiMode()) {
                    this.executeSessionRequest("TDSession constructor", false, "COMMIT WORK", false);
                }
                this.needNewPassword = false;
            }
            if (this.needNewPassword) {
                return;
            }
            if (uRLParameters.isJavaSPDefaultConnection()) {
                boolean bl;
                TDResultSet tDResultSet = this.executeSessionRequest("TDSession constructor", true, "HELP SESSION", false);
                try {
                    tDResultSet.next();
                    bl = "ANSI".equals(tDResultSet.getObject(8));
                }
                finally {
                    tDResultSet.close();
                }
                uRLParameters.setTransactMode(bl ? "ansi" : "tera");
                if (!this.isAnsiMode()) {
                    boolean bl2 = this.bAutoCommit = !this.transactionInProgress;
                }
            }
            if (uRLParameters.getRunStartup() && !uRLParameters.isJavaSPDefaultConnection()) {
                this.runUserStartup();
            }
            if (uRLParameters.getDatabaseName() != null && uRLParameters.getDatabaseName().length() > 0 && !uRLParameters.getDatabaseName().equals("NO_DEF_DATABASE")) {
                String string4 = "DATABASE " + uRLParameters.getDatabaseName();
                if (this.isAnsiMode()) {
                    string4 = string4 + ";COMMIT WORK";
                }
                this.executeSessionRequest("TDSession constructor", false, string4, false);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    private void initPacketForRequest(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(by);
        tDPacket.setHostCharSet(this.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.getSessionNum());
        tDPacket.setAuthentication(this.getAuthenticationNonce());
        tDPacket.setRequestNumber(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendAndReceive(TDPacket tDPacket, int n, String string, Integer n2) throws SQLException {
        if (this.getEncryptData() && this.getAuthMethod() != null) {
            tDPacket.setEncrypted();
        }
        tDPacket.toStream();
        this.log.debug(tDPacket.getBuffer());
        this.io.acquireWriteLock();
        try {
            tDPacket.getBuffer().writeStream(this.io, this.getTeraEncrypt(), false);
        }
        finally {
            this.io.releaseWriteLock();
        }
        tDPacket.clear();
        this.io.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(this.io, this.getTeraEncrypt(), false, n, true);
        }
        finally {
            this.io.releaseReadLock();
        }
        this.log.debug(tDPacket.getBuffer());
        tDPacket.initParcelFactory(this);
        this.setTransactionInProgress(tDPacket.inTransaction());
        switch (tDPacket.nextParcelPeek()) {
            case 9: 
            case 49: {
                boolean bl;
                ErrorParcel errorParcel = (ErrorParcel)tDPacket.nextParcel();
                JDBCException jDBCException = ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                if (this.log.canLog(1)) {
                    this.log.info(string + " produced Error or Failure parcel: " + jDBCException);
                }
                boolean bl2 = bl = n2 != null && jDBCException.getErrorCode() == n2.intValue();
                if (bl) {
                    return true;
                }
                throw jDBCException;
            }
        }
        return false;
    }

    private void runUserStartup() throws SQLException {
        Parcel parcel;
        ResponseParcel responseParcel;
        TDPacket tDPacket = this.createPacket(1);
        int n = this.getRequestNum();
        this.initPacketForRequest(tDPacket, (byte)5, n);
        String string = this.getSerializeDeserializeCharset();
        OptionsParcel optionsParcel = new OptionsParcel(string, this);
        optionsParcel.setDBCFunction((byte)69);
        optionsParcel.setReturnStatementInfo(this.isStatementInfoSupported());
        if (this.isLargeDecimalAndBigIntSupported()) {
            optionsParcel.setMaxDecimalPrecision(this.getMaxDecimalPrecision());
        }
        if (this.areAPHResponsesSupported()) {
            optionsParcel.setAPHResponses((byte)89);
        }
        if (this.dynamicResultSetsSupported()) {
            optionsParcel.setDynamicResultSetAllowed(true);
            optionsParcel.setSPReturnResult(this.getSPReturnResult());
        }
        if (this.isArrayDataTypeSupported()) {
            optionsParcel.setArrayTransformOff((byte)89);
        }
        tDPacket.addParcel(optionsParcel);
        tDPacket.getBuffer().putShort((short)2);
        tDPacket.getBuffer().putShort((short)4);
        tDPacket.addToMsgLength(4);
        if (this.areAPHResponsesSupported()) {
            responseParcel = new BigResponseParcel(string, this.log);
            responseParcel.setMaxMsgSize(this.getMaxMessageSize(false, false));
        } else {
            responseParcel = new ResponseParcel(string, this.log);
        }
        tDPacket.addParcel(responseParcel);
        boolean bl = this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Execute", new Integer(3747));
        boolean bl2 = this.isAnsiMode() && this.transactionInProgress;
        boolean bl3 = bl;
        while (!bl3 && (parcel = tDPacket.nextParcel()) != null) {
            if (!(parcel instanceof EndRequestParcel)) continue;
            bl3 = true;
        }
        if (!bl3) {
            this.initPacketForRequest(tDPacket, (byte)6, n);
            parcel = new CancelParcel(this.log);
            tDPacket.addParcel(parcel);
            this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Continue/Cancel", null);
        }
        if (bl2) {
            this.executeSessionRequest("runUserStartup", false, "COMMIT WORK", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this.isJavaSPDefaultConnection()) {
                return;
            }
            this.cleanUpStatements();
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            this.log.debug("TDSession.close: logoff waiting for session lock");
            this.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                this.log.debug("TDSession.close: acquired session lock, beginning logoff");
                genericLogoffController.run();
                this.io.close();
            }
            finally {
                this.releaseSessionLock();
                this.log.debug("TDSession.close: logoff complete");
            }
        }
    }

    public ResponseTracker responseTracker() {
        return this.m_responseTracker;
    }

    public void setTransactionInProgress(boolean bl) {
        this.transactionInProgress = bl;
    }

    public LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public synchronized int getWritableLobId() {
        if (this.writableLobId < 0) {
            this.writableLobId = 0;
        }
        return this.writableLobId++;
    }

    public String getLobTempTable() {
        return this.urlParams.getLobTempTable();
    }

    public String getLogonSequenceNumber() {
        return this.logonSeqNumParcel == null ? "" : String.valueOf(this.logonSeqNumParcel.getLogonSequenceNumber());
    }

    public String getAMPCount() {
        return this.configRsp == null ? "" : String.valueOf(this.configRsp.getAMPCount());
    }

    public String getLogLevel() {
        return this.getLog().getLogLevel();
    }

    public String setLogLevel(String string) {
        this.getLog().setLogLevel(string);
        return "";
    }

    public boolean shouldSendAnsiDate() {
        return this.isStatementInfoRequestSupported() && this.m_bUseAnsiDate;
    }

    public String useAnsiDate() {
        this.m_bUseAnsiDate = true;
        return "";
    }

    public String useIntegerDate() {
        this.m_bUseAnsiDate = false;
        return "";
    }

    public String getSessionNumber() {
        return this.io != null ? String.valueOf(this.io.getSessionNum()) : "";
    }

    public String getSocketInfo() {
        return this.io != null ? this.io.toString() : "";
    }

    public TDNetworkIOIF getIO() throws JDBCException {
        if (this.io == null) {
            this.io = new TDNetworkIOIF(this);
        }
        return this.io;
    }

    public int getSessionNum() {
        return this.io.getSessionNum();
    }

    public void setSessionNum(int n) {
        this.io.setSessionNum(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDResultSet executeSessionRequest(String string, boolean bl, String string2, boolean bl2) throws SQLException {
        TDStatement tDStatement = (TDStatement)((Object)this.createStatement(1003, 1007, 1));
        try {
            if (bl2) {
                this.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            }
            try {
                TDResultSet tDResultSet;
                if (this.log.canLog(1)) {
                    this.log.info(string + ": " + string2);
                }
                StatementController statementController = new StatementController(tDStatement, this, string2);
                statementController.setMode(bl ? (byte)66 : 69);
                statementController.setResultTypeExpected(bl ? 2 : 1);
                tDStatement.setUseKeepResponse(false);
                statementController.run();
                TDResultSet tDResultSet2 = tDResultSet = bl ? tDStatement.getResults().getResult().getResultSet() : null;
                if (tDResultSet != null) {
                    tDResultSet.setMetadataRS(true);
                }
                TDResultSet tDResultSet3 = tDResultSet;
                if (bl2) {
                    this.releaseSessionLock();
                }
                return tDResultSet3;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    this.releaseSessionLock();
                }
                throw throwable;
            }
        }
        finally {
            if (!bl) {
                tDStatement.close();
            }
        }
    }

    public boolean uncheckedGetAutoCommit() {
        return this.bAutoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.bAutoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.doCommit("setAutoCommit", true, null);
        this.bAutoCommit = bl;
    }

    public void commit() throws SQLException {
        this.doCommit("commit", true, null);
    }

    private void doCommit(String string, boolean bl, TDStatement tDStatement) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isAnsiMode()) {
            if (this.transactionInProgress) {
                this.executeSessionRequest(string, false, "COMMIT WORK", bl);
            }
        } else {
            while (this.transactionInProgress) {
                this.executeSessionRequest(string, false, "ET", bl);
            }
        }
        this.closeCursorsAtCommitResultSets(tDStatement, bl);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    public void rollback() throws SQLException {
        block4: {
            try {
                if (this.isAnsiMode()) {
                    this.executeSessionRequest("rollback", false, "ROLLBACK WORK", true);
                } else {
                    this.executeSessionRequest("rollback", false, "ABORT", true);
                }
            }
            catch (JDBCException jDBCException) {
                if (jDBCException.getErrorCode() == 3514) break block4;
                throw jDBCException;
            }
        }
    }

    public void beforeExecuteStatement() throws SQLException {
        if (!(this.isAnsiMode() || this.bAutoCommit || this.transactionInProgress)) {
            this.executeSessionRequest("beforeExecuteStatement", false, "BT", false);
        }
    }

    public void afterExecuteStatement(TDStatement tDStatement) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.bAutoCommit) {
            this.doCommit("afterExecuteStatement", false, tDStatement);
        }
    }

    public void acquireSessionLock(Mutex.AcquireCallback acquireCallback) throws SQLException {
        this.sessionLock.acquire(acquireCallback);
        if (this.isClosed()) {
            this.sessionLock.release();
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    public void releaseSessionLock() {
        this.sessionLock.release();
    }

    public boolean isAphSupported() {
        return this.configRsp.getAPHSupport();
    }

    public boolean useCheckWorkload() {
        return this.configRsp.isCheckWorkloadSupported() && (this.urlParams.isGoverned() || this.configRsp.isFailFastSupported());
    }

    public boolean isPositioningSupported() {
        return this.configRsp.getPositioningSupport();
    }

    public boolean isStatementPositioningSupported() {
        return this.configRsp.getStatementPositioningSupport();
    }

    public boolean areAPHResponsesSupported() {
        return this.configRsp.getAPHResponseSupport();
    }

    public boolean generatedKeysSupported() {
        return this.configRsp.getGeneratedKeysSupport();
    }

    public boolean dynamicResultSetsSupported() {
        return this.configRsp.isDynamicResultSetsSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerDeferredLob(DeferredLob deferredLob) {
        Map map = this.m_mapDeferredLobs;
        synchronized (map) {
            ++this.m_nDeferredLobToken;
            this.m_mapDeferredLobs.put(new Integer(this.m_nDeferredLobToken), deferredLob);
            return this.m_nDeferredLobToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredLob unregisterDeferredLob(int n) {
        Map map = this.m_mapDeferredLobs;
        synchronized (map) {
            return (DeferredLob)this.m_mapDeferredLobs.remove(new Integer(n));
        }
    }

    public void setEncryptPassword(boolean bl) {
        this.encryptPassword = bl;
    }

    public boolean getEncryptPassword() {
        return this.encryptPassword;
    }

    public void setTeraEncrypt(GenericTeraEncrypt genericTeraEncrypt) {
        this.myEncrypt = genericTeraEncrypt;
    }

    public GenericTeraEncrypt getTeraEncrypt() {
        return this.myEncrypt;
    }

    public AuthMechanism getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMechanism authMechanism) {
        this.authMethod = authMechanism;
    }

    public boolean serverHasAuthMechs() {
        return this.serverAuthMechs.size() > 0;
    }

    public LogonInformation getLogonInformation() {
        return this.logonInformation;
    }

    public void setServerDefaultAuthMethodOid(Oid oid) {
        this.serverDefaultAuthMethodOid = oid;
    }

    public Oid getServerDefaultAuthMethodOid() {
        return this.serverDefaultAuthMethodOid;
    }

    public void addServerAuthMech(AuthMechanism authMechanism) {
        this.serverAuthMechs.add(authMechanism);
    }

    public ArrayList getServerAuthMechs() {
        return this.serverAuthMechs;
    }

    public void setSSOSupported(boolean bl) {
        this.SSOSupported = bl;
    }

    public boolean getSSOSupported() {
        return this.SSOSupported;
    }

    public void setUsingClientDefaultMech(boolean bl) {
        this.usingClientDefaultMech = bl;
    }

    public boolean getUsingClientDefaultMech() {
        return this.usingClientDefaultMech;
    }

    public boolean arraySupported() {
        return this.configRsp.getArraySupport();
    }

    public boolean outParamArgSupported() {
        return this.configRsp.getOutParamArgSupport();
    }

    public boolean isLargeDecimalAndBigIntSupported() {
        return this.configRsp.isLargeDecimalAndBigIntSupported();
    }

    public byte getMaxDecimalPrecision() {
        if (this.configRsp.isLargeDecimalAndBigIntSupported()) {
            return 38;
        }
        return 18;
    }

    public short getMaximumNumberOfSegments() {
        return this.configRsp.getMaximumNumberOfSegments();
    }

    public int getMaximumSegmentSize() {
        return this.configRsp.getMaximumSegmentSize();
    }

    public byte getTdSessionCharSetCode() throws JDBCException {
        return this.configRsp.getTDCharSetCodeFromName(this.urlParams.getCharSet());
    }

    public int getCompatDBS() {
        return this.urlParams.getCompatDBS();
    }

    public int getCompatIsAutoInc() {
        return this.urlParams.getCompatIsAutoInc();
    }

    public int getCompatIsCurrency() {
        return this.urlParams.getCompatIsCurrency();
    }

    public int getCompatIsSigned() {
        return this.urlParams.getCompatIsSigned();
    }

    public int getCompatIsSearch() {
        return this.urlParams.getCompatIsSearch();
    }

    public String getCompatGetSchema() {
        return this.urlParams.getCompatGetSchema();
    }

    public String getCompatGetTable() {
        return this.urlParams.getCompatGetTable();
    }

    public String getlogmech() {
        return this.urlParams.getLogMech();
    }

    public String getlogdata() {
        return this.urlParams.getLogData();
    }

    public boolean getEncryptData() {
        return this.urlParams.getEncryptData();
    }

    public int getCompatIsReadOnly() {
        return this.urlParams.getCompatIsReadOnly();
    }

    public int getCompatIsWritable() {
        return this.urlParams.getCompatIsWritable();
    }

    public int getCompatIsDefWrit() {
        return this.urlParams.getCompatIsDefWrit();
    }

    public void setLogonSequenceNumberParcel(LogonSequenceNumberParcel logonSequenceNumberParcel) {
        this.logonSeqNumParcel = logonSequenceNumberParcel;
    }

    public void setAssignRspParcel(AssignRspParcel assignRspParcel) {
        this.assignRsp = assignRspParcel;
    }

    public String getTeradataDatabaseVersion() {
        String string;
        String string2;
        if (this.configRsp.getTeradataDatabaseRelease() != null) {
            string2 = this.configRsp.getTeradataDatabaseRelease();
            string = this.configRsp.getTeradataDatabaseVersion();
        } else {
            string2 = this.assignRsp.getDBSRelease();
            string = this.assignRsp.getDBSVersion();
        }
        if (string.startsWith("0")) {
            string = string2.substring(0, 3) + string;
        }
        return "Teradata Database " + string;
    }

    public void setTransactionIsolation(int n) throws JDBCException, SQLException {
        boolean bl;
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ396", n);
            }
        }
        n = this.getMappedTransactionLevel(n);
        switch (n) {
            case 8: {
                string = "SR";
                break;
            }
            case 2: {
                string = "RC";
                break;
            }
            case 1: {
                string = "RU";
                break;
            }
            case 4: {
                string = "RR";
            }
        }
        boolean bl2 = bl = n == this.configRsp.getSupportedTransactionIsolationLevels();
        if (bl) {
            return;
        }
        String string2 = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + string;
        if (this.isAnsiMode()) {
            string2 = string2 + ";COMMIT WORK";
        }
        this.executeSessionRequest("setTransactionIsolation", false, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() throws SQLException {
        TDResultSet tDResultSet = this.executeSessionRequest("getTransactionIsolation", true, "HELP SESSION", true);
        try {
            if (tDResultSet.next() && tDResultSet.getMetaData().getColumnCount() >= 42) {
                String string = String.valueOf(tDResultSet.getObject(42)).trim();
                if ("SR".equals(string)) {
                    int n = 8;
                    return n;
                }
                if ("RC".equals(string)) {
                    int n = 2;
                    return n;
                }
                if ("RU".equals(string)) {
                    int n = 1;
                    return n;
                }
                if ("RR".equals(string)) {
                    int n = 4;
                    return n;
                }
            }
            int n = this.configRsp.getTransactionIsolationDefault();
            return n;
        }
        finally {
            tDResultSet.close();
        }
    }

    private int getMappedTransactionLevel(int n) {
        while (n < 8) {
            if ((n & this.configRsp.getSupportedTransactionIsolationLevels()) != 0) {
                return n;
            }
            n *= 2;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerStatement(TDStatement tDStatement) {
        if (this.cleanUpStatementsStarted) {
            return false;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.statementList == null) {
                this.statementList = new Vector();
            }
            if (!this.statementList.contains(tDStatement)) {
                this.statementList.addElement(tDStatement);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStatement(TDStatement tDStatement) {
        if (this.cleanUpStatementsStarted) {
            return;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.statementList == null) {
                this.statementList = new Vector();
            }
            this.statementList.removeElement(tDStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpStatements() throws SQLException {
        TDSession tDSession = this;
        synchronized (tDSession) {
            this.cleanUpStatementsStarted = true;
            if (this.statementList != null) {
                TDStatement tDStatement;
                Enumeration enumeration = this.statementList.elements();
                while (enumeration.hasMoreElements()) {
                    tDStatement = (TDStatement)enumeration.nextElement();
                    int n = tDStatement.getState();
                    tDStatement.cancel();
                }
                enumeration = this.statementList.elements();
                while (enumeration.hasMoreElements()) {
                    tDStatement = (TDStatement)enumeration.nextElement();
                    tDStatement.close();
                }
                this.statementList = null;
            }
        }
    }

    public boolean isCleanUpStatementsStarted() {
        return this.cleanUpStatementsStarted;
    }

    public boolean isUTF_CredentialSupported() {
        return this.UTF_CredentialSupported;
    }

    public void setUTF_CredentialSupported(boolean bl) {
        this.UTF_CredentialSupported = bl;
    }

    public boolean isStatementInfoRequestSupported() {
        return this.configRsp.isStatementInfoRequestSupported() && this.urlParams.sipSupport();
    }

    public boolean supportsPasswordChange() {
        return this.needNewPassword && this.urlParams.getNewPassword() != null && this.urlParams.getNewPassword().length() > 0 && !this.urlParams.isJavaSPDefaultConnection();
    }

    public void setNeedNewPassword(boolean bl) {
        this.needNewPassword = bl;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.urlParams.isJavaSPDefaultConnection();
    }

    public byte getSPReturnResult() {
        return this.m_spReturnResult;
    }

    public void setSPReturnResult(byte by) {
        this.m_spReturnResult = by;
    }

    public boolean isUDTTransformOffSupported() {
        return this.configRsp.isUDTTransformOffSupported() && this.isStatementInfoSupported();
    }

    public boolean isPeriodAsStructSupported() {
        return this.configRsp.isPeriodAsStructSupported() && this.isStatementInfoSupported();
    }

    public boolean isArrayDataTypeSupported() {
        return this.configRsp.isArrayDataTypeSupported() && this.isStatementInfoSupported();
    }

    public boolean isXMLDataTypeSupported() {
        return this.configRsp.isXMLSupported() && this.isStatementInfoSupported();
    }

    public boolean isNumberDataTypeSupported() {
        return this.configRsp.isNumberDataTypeSupported() && this.isStatementInfoSupported();
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return false;
    }

    public void setCatalog(String string) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return "";
    }

    public static Map copyAndVerifyTypeMap(Map map) throws SQLException {
        if (map == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ683");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(map);
        Iterator iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k instanceof String && v instanceof Class) {
                Class clazz;
                if (!(class$java$sql$SQLData == null ? TDSession.class$("java.sql.SQLData") : class$java$sql$SQLData).isAssignableFrom(clazz = (Class)v)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ684", clazz.getName());
                }
                try {
                    clazz.getConstructor(new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ685", clazz.getName());
                    jDBCException.initCause(noSuchMethodException);
                    throw jDBCException;
                }
            }
            throw ErrorFactory.makeDriverJDBCException("TJ686", k != null ? k.getClass().getName() : null, v != null ? v.getClass().getName() : null);
        }
        return linkedHashMap;
    }

    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return new LinkedHashMap(this.m_typeMap);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        this.m_typeMap = TDSession.copyAndVerifyTypeMap(map);
    }

    public void setHoldability(int n) throws SQLException {
        this.m_nHoldabilityForSubsequentStatements = TDSession.validateHoldability(n);
    }

    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.m_nHoldabilityForSubsequentStatements;
    }

    public static int validateHoldability(int n) throws JDBCException {
        if (n == 2 || n == 1) {
            return n;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ493", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCloseCursorsAtCommitStatements(TDStatement tDStatement) {
        if (tDStatement.getResultSetHoldability() != 2) {
            return;
        }
        List list = this.m_listCloseCursorsAtCommitStatements;
        synchronized (list) {
            Iterator iterator = this.m_listCloseCursorsAtCommitStatements.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                TDStatement tDStatement2 = (TDStatement)weakReference.get();
                if (tDStatement2 != null) continue;
                iterator.remove();
            }
            this.m_listCloseCursorsAtCommitStatements.add(new WeakReference<TDStatement>(tDStatement));
            if (this.log.canLog(0)) {
                this.log.debug("addToCloseCursorsAtCommitStatements: m_listCloseCursorsAtCommitStatements=" + this.m_listCloseCursorsAtCommitStatements);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursorsAtCommitResultSets(TDStatement tDStatement, boolean bl) throws SQLException {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.m_listCloseCursorsAtCommitStatements;
        synchronized (object2) {
            object = this.m_listCloseCursorsAtCommitStatements.iterator();
            while (object.hasNext()) {
                WeakReference weakReference = (WeakReference)object.next();
                TDStatement tDStatement2 = (TDStatement)weakReference.get();
                if (tDStatement2 == null || tDStatement2 == tDStatement) continue;
                arrayList.addAll(tDStatement2.getResults().getAllResultSets());
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (TDResultSet)object2.next();
            ((TDResultSet)object).close(bl);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setSavepoint");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setSavepoint");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "rollback");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "releaseSavepoint");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return (Statement)((Object)this.constructStatement(n, n2, n3));
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructPreparedStatement(string, n, n2, n3, null, linkedHashMap);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructCallableStatement(string, n, n2, n3, linkedHashMap);
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 2) {
            return this.prepareStatement(string);
        }
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(n, this.generatedKeysSupported()));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(nArray, this.generatedKeysSupported()));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(stringArray, this.generatedKeysSupported()));
    }

    private PreparedStatement preparedGenKeyStatement(String string, GeneratedKeysRequest generatedKeysRequest) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructPreparedStatement(string, 1003, 1007, this.m_nHoldabilityForSubsequentStatements, generatedKeysRequest, linkedHashMap);
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (!this.isUDTTransformOffSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ636");
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ644");
        }
        if (objectArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ637");
        }
        return new ClientStruct(string, objectArray);
    }

    public Clob createClob() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "createClob");
    }

    public Blob createBlob() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "createBlob");
    }

    public boolean isValid(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "isValid");
    }

    public String getClientInfo(String string) throws SQLException {
        return this.getClientInfo().getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        ResultSet resultSet = (ResultSet)((Object)this.executeSessionRequest("getClientInfo", true, "HELP SESSION", true));
        try {
            if (resultSet.next()) {
                String[] stringArray = Utility.parseQueryBand(Utility.getQueryBandFromHelpSessionResultSet(resultSet));
                Utility.tokenizeQueryBand(properties, stringArray[1]);
                Utility.tokenizeQueryBand(properties, stringArray[0]);
            }
        }
        finally {
            resultSet.close();
        }
        return properties;
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return new ClientArray(this, string, objectArray);
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public abstract TeraResultSetMetaData constructResultSetMetaData() throws SQLException;

    public abstract TDResultSet constructResultSet(TeraResultSetMetaData var1, int var2, Statement var3, RowFetchController var4, Log var5) throws SQLException;

    public abstract SQLInput constructSQLInput(Object[] var1, int[] var2, int[] var3, String[] var4, Map var5, Class var6);

    public abstract TeraSQLOutput constructSQLOutput(TDPreparedStatement var1, FullContentMetadataItem[] var2, int var3, Class var4);

    public abstract ParameterMetaData constructParameterMetaData(TDPreparedStatement var1) throws SQLException;

    protected abstract TDStatement constructStatement(int var1, int var2, int var3) throws SQLException;

    protected abstract PreparedStatement constructPreparedStatement(String var1, int var2, int var3, int var4, GeneratedKeysRequest var5, Map var6) throws SQLException;

    protected abstract CallableStatement constructCallableStatement(String var1, int var2, int var3, int var4, Map var5) throws SQLException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

