/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class ClobAsciiStream
extends LobStream {
    protected String charSet;
    protected byte[] byteData;
    protected int index = 0;
    protected int remaining = 0;

    public ClobAsciiStream(TDSession tDSession, byte[] byArray, short s, long l) {
        super(tDSession, byArray, s, l);
        this.charSet = tDSession.getSerializeDeserializeCharset();
    }

    public synchronized int read() throws IOException {
        if (this.remaining == 0 && (this.byteData = this.getNewByteBuff()) == null) {
            return -1;
        }
        --this.remaining;
        ++this.amountRead;
        return this.byteData[this.index++];
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        for (int i = n2; i > 0; i -= n3) {
            n3 = this.readBytes(byArray, n + n4, n2 - n4);
            if (n3 == -1) {
                return n4 > 0 ? n4 : -1;
            }
            n4 += n3;
        }
        return n4;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0 && (this.byteData = this.getNewByteBuff()) == null) {
            return -1;
        }
        int n3 = n2 > this.remaining ? this.remaining : n2;
        System.arraycopy(this.byteData, this.index, byArray, n, n3);
        this.index += n3;
        this.remaining -= n3;
        this.amountRead += (long)n3;
        return n3;
    }

    private byte[] getNewByteBuff() throws IOException {
        byte[] byArray = null;
        try {
            this.initStream();
            String string = this.lobData.readClobString(this.charSet);
            if (string != null) {
                byArray = string.getBytes("ASCII");
                this.remaining = byArray.length;
                this.index = 0;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
        return byArray;
    }

    public synchronized String getSubString(long l, int n) throws SQLException {
        byte[] byArray = super.getBytes(l, n);
        try {
            String string = new String(byArray, 0, byArray.length, this.charSet);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", this.charSet);
        }
    }
}

