/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import java.io.IOException;
import java.sql.SQLException;

public class ClobCharacterStream
extends LobStream {
    private String charSet;
    private String stringData;
    private int index = 0;
    private int remaining = 0;

    public ClobCharacterStream(TDSession tDSession, byte[] byArray, short s, long l) {
        super(tDSession, byArray, s, l);
        this.charSet = s == 860 || s == 861 ? "UTF8" : tDSession.getSerializeDeserializeCharset();
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        for (int i = n2; i > 0; i -= n3) {
            n3 = this.readStringData(cArray, n + n4, n2 - n4);
            if (n3 == -1) {
                return n4 > 0 ? n4 : -1;
            }
            n4 += n3;
        }
        return n4;
    }

    private int readStringData(char[] cArray, int n, int n2) throws IOException {
        if (this.remaining <= 0 && (this.stringData = this.getNewString()) == null) {
            return -1;
        }
        int n3 = n2 > this.remaining ? this.remaining : n2;
        this.stringData.getChars(this.index, this.index + n3, cArray, n);
        this.index += n3;
        this.remaining -= n3;
        return n3;
    }

    public int readChar() throws IOException {
        if (this.remaining <= 0 && (this.stringData = this.getNewString()) == null) {
            return -1;
        }
        --this.remaining;
        return this.stringData.charAt(this.index++);
    }

    private String getNewString() throws IOException {
        String string = null;
        try {
            this.initStream();
            string = this.lobData.readClobString(this.charSet);
            if (string != null) {
                this.index = 0;
                this.remaining = string.length();
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
        return string;
    }
}

