/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringTokenizer;

public class ConvertNoArgScalarFunction
extends ConvertScalarFunction {
    public String processTokens(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions, Map map) throws SQLException {
        if ("CURDATE".equals(string)) {
            return this.createNativeSQL(string, "CURRENT_DATE", stringTokenizer);
        }
        if ("CURTIME".equals(string)) {
            return this.createNativeSQL(string, "CURRENT_TIME(0)", stringTokenizer);
        }
        if ("NOW".equals(string)) {
            return this.createNativeSQL(string, "CURRENT_TIMESTAMP(0)", stringTokenizer);
        }
        if ("PI".equals(string)) {
            return this.createNativeSQL(string, "3.14159265358979323", stringTokenizer);
        }
        if ("DATABASE".equals(string)) {
            return this.createNativeSQL(string, "DATABASE", stringTokenizer);
        }
        if ("USER".equals(string)) {
            return this.createNativeSQL(string, "USER", stringTokenizer);
        }
        if ("TERADATA_LOGON_SEQUENCE_NUMBER".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.getLogonSequenceNumber(), stringTokenizer);
        }
        if ("TERADATA_AMP_COUNT".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.getAMPCount(), stringTokenizer);
        }
        if ("TERADATA_GETLOGLEVEL".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.getLogLevel(), stringTokenizer);
        }
        if ("TERADATA_USEANSIDATE".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.useAnsiDate(), stringTokenizer);
        }
        if ("TERADATA_USEINTEGERDATE".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.useIntegerDate(), stringTokenizer);
        }
        if ("TERADATA_SESSION_NUMBER".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.getSessionNumber(), stringTokenizer);
        }
        if ("TERADATA_SOCKET_INFO".equals(string)) {
            return this.createNativeSQL(string, localEscapeFunctions.getSocketInfo(), stringTokenizer);
        }
        if ("TERADATA_UNTRUSTED".equals(string)) {
            if (map != null) {
                map.put("TERADATA_UNTRUSTED", "");
            }
            return this.createNativeSQL(string, "", stringTokenizer);
        }
        if ("TERADATA_NOPREPARE".equals(string)) {
            if (map != null) {
                map.put("TERADATA_NOPREPARE", "");
            }
            return this.createNativeSQL(string, "", stringTokenizer);
        }
        if ("TERADATA_FAILFAST".equals(string)) {
            if (map != null) {
                map.put("TERADATA_FAILFAST", "");
            }
            return this.createNativeSQL(string, "", stringTokenizer);
        }
        return null;
    }

    private String createNativeSQL(String string, String string2, StringTokenizer stringTokenizer) throws SQLException {
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (" \t\n\r\f".indexOf(string3) != -1 || "(".equals(string3) || ")".equals(string3)) continue;
            n += string3.length();
        }
        if (n != 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ377", string);
        }
        return string2;
    }
}

