/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class LanHeader {
    private byte version = (byte)3;
    private byte msgType = 1;
    private byte kind;
    private short highOrderMessageLength;
    private byte byteVar;
    private short wordVar;
    private short lowOrderMessageLength;
    private int correlationTag;
    private int sessionNo;
    private byte[] authentication = new byte[8];
    private int requestNo;
    private byte unionGTW;
    private byte hostCharSet;
    private TDPacketStream buffer = new TDPacketStream(52);
    private int msgLength;
    public static final byte COPVERSION = 3;
    public static final byte COPCLASSREQUEST = 1;
    public static final byte COPCLASSRESPONSE = 2;
    public static final int COPENCRYPTFLAG = 128;
    public static final byte COPKINDASSIGN = 1;
    public static final byte COPKINDREASSIGN = 2;
    public static final byte COPKINDCONNECT = 3;
    public static final byte COPKINDRECONNECT = 4;
    public static final byte COPKINDSTART = 5;
    public static final byte COPKINDCONTINUE = 6;
    public static final byte COPKINDABORT = 7;
    public static final byte COPKINDLOGOFF = 8;
    public static final byte COPKINDTEST = 9;
    public static final byte COPKINDCFG = 10;
    public static final byte COPKINDAUTHMETHODS = 11;
    public static final byte COPKINDSSOREQ = 12;
    public static final byte COPKINDELICITDATA = 13;
    public static final byte COPKINDELICITFILE = 13;
    public static final byte COPENCRYPTION_ON = 1;
    public static final byte COPENCRYPTION_OFF = 0;
    public static final byte COPFORMATINTERNAL = 0;
    public static final byte COPFORMATIBM = 3;
    public static final byte COPFORMATHONEYWELL = 4;
    public static final byte COPFORMATATT3B2 = 7;
    public static final byte COPFORMATPC = 8;
    public static final byte COPFORMATVAX = 9;
    public static final byte COPFORMATUTS = 10;
    public static final byte COPDONTCHECKTRANS = 0;
    public static final byte COPCHECKTRANS = 1;
    public static final byte COPDISCARDTEST = 0;
    public static final byte COPYTESTECHO = 1;
    public static final int TRANSACTION_MASK = 1;
    public static final byte COPNULLBYTEVAR = 0;
    public static final int COPCAPABILITY_GSS = 4;
    public static final int COPCAPABILITY_ENCRYPT = 8;
    public static final byte COPNOTINTRANS = 0;
    public static final byte COPINTRANS = 1;
    public static final short LANHEADERLENGTH = 52;
    public static final int ENCRYPTLEN = 28;

    public LanHeader() {
        this.buffer.put(0, this.version);
        this.buffer.put(1, this.msgType);
    }

    public LanHeader(TDPacketStream tDPacketStream) throws SQLException {
        this();
        this.setLanHeaderValues(tDPacketStream);
    }

    public void setLanHeaderValues(TDPacketStream tDPacketStream) throws SQLException {
        tDPacketStream.getStream(this.buffer, 0, 52);
        this.version = tDPacketStream.get();
        this.msgType = tDPacketStream.get();
        this.kind = tDPacketStream.get();
        this.highOrderMessageLength = tDPacketStream.getShort();
        this.byteVar = tDPacketStream.get();
        this.wordVar = tDPacketStream.getShort();
        this.lowOrderMessageLength = tDPacketStream.getShort();
        tDPacketStream.position(tDPacketStream.position() + 6);
        this.correlationTag = tDPacketStream.getInt();
        this.sessionNo = tDPacketStream.getInt();
        for (int i = 0; i < this.authentication.length; ++i) {
            this.authentication[i] = tDPacketStream.get();
        }
        this.requestNo = tDPacketStream.getInt();
        this.unionGTW = tDPacketStream.get();
        this.hostCharSet = tDPacketStream.get();
        tDPacketStream.position(tDPacketStream.position() + 14);
        this.msgLength = this.calculateMsgLength();
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte by) {
        this.version = by;
        this.buffer.put(0, by);
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public void setMsgType(byte by) {
        this.msgType = by;
        this.buffer.put(1, by);
    }

    public byte getKind() {
        return this.kind;
    }

    public void setKind(byte by) {
        this.kind = by;
        this.buffer.put(2, by);
    }

    public byte getByteVar() {
        return this.byteVar;
    }

    public void setByteVar(byte by) {
        this.byteVar = by;
        this.buffer.put(5, by);
    }

    public int getSessionNo() {
        return this.sessionNo;
    }

    public void setSessionNo(int n) {
        this.sessionNo = n;
        this.buffer.putInt(20, n);
    }

    public int getRequestNo() {
        return this.requestNo;
    }

    public void setRequestNo(int n) {
        this.requestNo = n;
        this.buffer.putInt(32, n);
    }

    public byte getHostCharSet() {
        return this.hostCharSet;
    }

    public void setHostCharSet(byte by) {
        this.hostCharSet = by;
        this.buffer.put(37, by);
    }

    public TDPacketStream toStream() throws JDBCException {
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        return this.buffer;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(short s) {
        this.setMsgLength(UnsignedConversions.convertUnsignedShort(s));
    }

    public void setMsgLength(int n) {
        byte[] byArray = new byte[4];
        this.msgLength = n;
        ByteConverter.putInt(byArray, 0, this.msgLength);
        this.highOrderMessageLength = ByteConverter.getShort(byArray, 0);
        this.lowOrderMessageLength = ByteConverter.getShort(byArray, 2);
        this.buffer.putShort(8, this.lowOrderMessageLength);
        this.buffer.putShort(3, this.highOrderMessageLength);
    }

    public byte[] getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(byte[] byArray) {
        this.authentication = byArray;
        this.buffer.position(24);
        this.buffer.put(byArray);
    }

    public void setAuthentication(long l) {
        this.buffer.position(24);
        this.buffer.putLong(l);
    }

    public boolean getEncryption() {
        return (this.unionGTW & 4) == 4;
    }

    public int getCorrelationTag() {
        return this.correlationTag;
    }

    public void setCorrelationTag(int n) {
        this.correlationTag = n;
        this.buffer.putInt(16, n);
    }

    public void addToMsgLength(short s) {
        this.msgLength += s;
        this.setMsgLength(this.msgLength);
    }

    public void addToMsgLength(int n) {
        this.msgLength += n;
        this.setMsgLength(this.msgLength);
    }

    private int calculateMsgLength() {
        byte[] byArray = new byte[4];
        ByteConverter.putShort(byArray, 0, this.highOrderMessageLength);
        ByteConverter.putShort(byArray, 2, this.lowOrderMessageLength);
        return ByteConverter.getInt(byArray, 0);
    }

    public void setEncrypted() {
        byte by = (byte)(this.msgType | 0x80);
        this.setMsgType(by);
    }

    public void setClassType(byte by) {
        this.msgType = by;
        this.buffer.put(1, this.msgType);
    }

    public boolean inTransaction() {
        return (this.byteVar & 1) != 0;
    }
}

