/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TDNetworkIOIF {
    private String m_sOriginalHostName;
    private boolean m_bClosedJavaSPDefaultConnection;
    private Socket socket = null;
    private OutputStream outStream;
    private InputStream inStream;
    private Mutex readLock;
    private Mutex writeLock;
    private int sessionNum;
    private final String m_sConnectionID = Integer.toHexString(System.identityHashCode(this));
    private int m_tcp_concurrent = 3;
    private int m_tcp_contimeout = 10000;
    private long m_tcp_conwait = 1000L;
    private long m_result_connecttime = 0L;
    private long m_result_connecttotaltime = 0L;
    private int m_result_connectattempts = 0;
    private int m_result_connectfailures = 0;
    private boolean m_bReconnectInProgress;
    private GenericTeradataConnection m_con;
    protected Log log;
    private static Map sm_mapConnectFailures = Collections.synchronizedMap(new HashMap());
    private static Map sm_map = new HashMap();
    private static final int GET_TCP_KEEPALIVE = 1;
    private static final int GET_TCP_NODELAY = 2;
    private static final int GET_TCP_RECEIVE = 3;
    private static final int GET_TCP_SEND = 4;
    private static final int GET_TCP_LINGER = 5;
    private static final int GET_TCP_TRAFFIC = 6;
    private static final String[] MESSAGE_KIND = new String[]{null, "Assign", "Reassign", "Connect", "Reconnect", "Start", "Continue", "Abort", "Logoff", "Test", "Config", "AuthMethods", "SSO", "Elicit"};
    private static final String[] MESSAGE_CLASS = new String[]{null, "request", "response"};

    public TDNetworkIOIF(GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        this.m_con = genericTeradataConnection;
        this.log = genericTeradataConnection.getLog();
        this.m_sOriginalHostName = genericTeradataConnection.getMachineName();
        this.createSocketConnection();
        this.readLock = new Mutex("IO ReadLock", this.log);
        this.writeLock = new Mutex("IO WriteLock", this.log);
    }

    private void createSocketConnection() throws JDBCException {
        String string = this.m_con.getURLParameters().getCopDiscovery() ? "cop" : null;
        try {
            this.socket = this.connectToHost(this.m_con, string);
            this.outStream = this.socket.getOutputStream();
            this.inStream = this.socket.getInputStream();
        }
        catch (Throwable throwable) {
            this.close();
            throw ErrorAnalyzer.analyzeIoError("Connection to " + this.m_sOriginalHostName, this, throwable, false, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Completed connection: " + this);
        }
    }

    public TDNetworkIOIF(OutputStream outputStream, InputStream inputStream, Log log) throws JDBCException {
        this.log = log;
        this.outStream = outputStream;
        this.inStream = inputStream;
        this.socket = null;
        this.readLock = new Mutex("IO ReadLock", log);
        this.writeLock = new Mutex("IO WriteLock", log);
    }

    private static int randomNumber(int n, int n2) {
        int n3 = n2 - n + 1;
        return (int)(Math.random() * (double)n3) % n3 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connectToHost(GenericTeradataConnection genericTeradataConnection, String string) throws IOException, JDBCException {
        Iterator iterator;
        long l;
        int n;
        Cloneable cloneable;
        Object object;
        Object object2;
        LinkedHashSet<InetSocketAddress> linkedHashSet;
        int n2;
        Lookup lookup;
        Object object3;
        Integer n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        boolean bl2;
        boolean bl3;
        Log log;
        long l2;
        int n7;
        String string2;
        block58: {
            string2 = genericTeradataConnection.getMachineName();
            n7 = genericTeradataConnection.getMachinePort();
            l2 = genericTeradataConnection.getURLParameters().getConnectFailureTTL();
            log = genericTeradataConnection.getLog();
            bl3 = false;
            bl2 = false;
            n6 = 65156;
            n5 = 65156;
            bl = true;
            n4 = 10;
            n3 = null;
            String string3 = genericTeradataConnection.getURLParameters().getTCP();
            if (string3 != null) {
                object3 = string3.toUpperCase().trim().split("[+]");
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    if (object3[i].equals("KEEPALIVE")) {
                        bl3 = true;
                        continue;
                    }
                    if (object3[i].equals("NODELAY")) {
                        bl2 = true;
                        continue;
                    }
                    if (object3[i].startsWith("RECEIVE")) {
                        n6 = Integer.parseInt(((String)object3[i]).substring("RECEIVE".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("SEND")) {
                        n5 = Integer.parseInt(((String)object3[i]).substring("SEND".length()));
                        continue;
                    }
                    if (((String)object3[i]).equals("NOLINGER")) {
                        bl = false;
                        continue;
                    }
                    if (((String)object3[i]).startsWith("LINGER")) {
                        n4 = Integer.parseInt(((String)object3[i]).substring("LINGER".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("TRAFFIC")) {
                        n3 = new Integer(((String)object3[i]).substring("TRAFFIC".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("CONCURRENT")) {
                        this.m_tcp_concurrent = Integer.parseInt(((String)object3[i]).substring("CONCURRENT".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("CONTIMEOUT")) {
                        this.m_tcp_contimeout = Integer.parseInt(((String)object3[i]).substring("CONTIMEOUT".length()));
                        continue;
                    }
                    if (!((String)object3[i]).startsWith("CONWAIT")) continue;
                    this.m_tcp_conwait = Long.parseLong(((String)object3[i]).substring("CONWAIT".length()));
                }
            }
            if (this.m_tcp_concurrent <= 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ654", string2, "concurrent", String.valueOf(this.m_tcp_concurrent));
            }
            if (this.m_tcp_contimeout < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string2, "contimeout", String.valueOf(this.m_tcp_contimeout));
            }
            if (this.m_tcp_conwait < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string2, "conwait", String.valueOf(this.m_tcp_conwait));
            }
            object3 = new ArrayList();
            lookup = new Lookup(genericTeradataConnection, string2);
            if (lookup.isLiteralIpAddress()) {
                ((ArrayList)object3).add(lookup.getAddresses());
            } else if (string != null) {
                n2 = string2.indexOf(46);
                linkedHashSet = n2 < 0 ? string2 : string2.substring(0, n2);
                object2 = n2 < 0 ? "" : string2.substring(n2);
                try {
                    int n8 = 1;
                    while (true) {
                        String string4 = (String)((Object)linkedHashSet) + string + n8 + (String)object2;
                        ((ArrayList)object3).add(new Lookup(genericTeradataConnection, string4).getAddresses());
                        ++n8;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (log.isDebugEnabled()) {
                        log.debug("TDNetworkIOIF.connectToHost: caught " + unknownHostException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!log.isDebugEnabled()) break block58;
                    log.debug("TDNetworkIOIF.connectToHost: caught " + securityException);
                }
            }
        }
        if (((ArrayList)object3).size() == 0) {
            ((ArrayList)object3).add(lookup.getAddresses());
        }
        n2 = TDNetworkIOIF.randomNumber(0, ((ArrayList)object3).size() - 1);
        linkedHashSet = sm_map;
        synchronized (linkedHashSet) {
            object2 = (Integer)sm_map.get(string2);
            if (object2 != null) {
                n2 = ((Integer)object2 + 1) % ((ArrayList)object3).size();
            }
            sm_map.put(string2, new Integer(n2));
        }
        Collections.rotate(object3, -n2);
        if (log.isDebugEnabled()) {
            log.debug("Before connect loop: sm_mapConnectFailures=" + sm_mapConnectFailures);
        }
        linkedHashSet = new LinkedHashSet<InetSocketAddress>();
        long l3 = System.currentTimeMillis();
        IOException iOException = null;
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            InetAddress[] inetAddressArray = (InetAddress[])((ArrayList)object3).get(i);
            for (int j = 0; j < inetAddressArray.length; ++j) {
                object = new InetSocketAddress(inetAddressArray[j], n7);
                genericTeradataConnection.checkRemainingLoginTime();
                cloneable = (Date)sm_mapConnectFailures.get(object);
                if (cloneable != null) {
                    long l4 = ((Date)cloneable).getTime();
                    int n9 = n = l4 <= l3 ? 1 : 0;
                    if (n != 0) {
                        boolean bl4;
                        l = l4 + l2 * 1000L;
                        boolean bl5 = bl4 = l3 < l;
                        if (bl4) {
                            if (!log.canLog(2)) continue;
                            log.timing("Fail-fast connection attempt skipped due to failure at " + cloneable + ", " + object + " will become usable at " + new Date(l));
                            continue;
                        }
                    }
                }
                linkedHashSet.add((InetSocketAddress)object);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("setAddresses=" + linkedHashSet);
        }
        Iterator iterator2 = linkedHashSet.iterator();
        this.m_result_connectattempts = 0;
        long l5 = System.currentTimeMillis();
        object = null;
        cloneable = new ArrayList();
        try {
            Iterator iterator3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                WorkerThreadList workerThreadList = new WorkerThreadList();
                while (object == null && (iterator2.hasNext() || cloneable.size() > 0)) {
                    Object object4;
                    Object object5;
                    n = genericTeradataConnection.checkRemainingLoginTime();
                    if (cloneable.size() < this.m_tcp_concurrent && iterator2.hasNext()) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)iterator2.next();
                        ++this.m_result_connectattempts;
                        if (log.canLog(2)) {
                            log.timing("Attempting connection " + this.m_result_connectattempts + " to " + inetSocketAddress);
                        }
                        int n10 = n == 0 && this.m_tcp_contimeout != 0 ? this.m_tcp_contimeout : (n != 0 && this.m_tcp_contimeout == 0 ? n : Math.min(n, this.m_tcp_contimeout));
                        object5 = new Socket();
                        ((Socket)object5).setKeepAlive(bl3);
                        ((Socket)object5).setTcpNoDelay(bl2);
                        ((Socket)object5).setReceiveBufferSize(n6);
                        ((Socket)object5).setSendBufferSize(n5);
                        ((Socket)object5).setSoLinger(bl, n4);
                        if (n3 != null) {
                            ((Socket)object5).setTrafficClass(n3);
                        }
                        arrayList.add(object5);
                        object4 = new ConnectThread((Socket)object5, inetSocketAddress, n10, workerThreadList);
                        cloneable.add(object4);
                        ((Thread)object4).setDaemon(true);
                        ((Thread)object4).start();
                    }
                    l = cloneable.size() < this.m_tcp_concurrent && iterator2.hasNext() ? this.m_tcp_conwait : 0L;
                    object5 = workerThreadList.waitForThreads(l);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        ConnectThread connectThread = (ConnectThread)object4.next();
                        cloneable.remove(connectThread);
                        long l6 = System.currentTimeMillis();
                        TDNetworkIOIF.waitForThreadDeath(connectThread);
                        if (log.canLog(2)) {
                            log.timing("Connection attempt to " + connectThread.m_isa + " with timeout " + connectThread.m_nTimeoutMs + " ms took " + connectThread.m_nElapsedTime + " ms and " + (connectThread.m_ex != null ? "failed" : (object == null ? "succeeded" : "succeeded but was discarded")) + ", waiting for thread took " + (System.currentTimeMillis() - l6) + " ms");
                        }
                        if (connectThread.m_ex == null) {
                            if (object != null) continue;
                            object = connectThread.m_socket;
                            this.m_result_connecttime = connectThread.m_nElapsedTime;
                            continue;
                        }
                        ++this.m_result_connectfailures;
                        sm_mapConnectFailures.put(connectThread.m_isa, connectThread.m_dateFailure);
                        if (connectThread.m_ex instanceof IOException) {
                            iOException = (IOException)connectThread.m_ex;
                        } else {
                            iOException = new IOException(connectThread.m_ex.toString());
                            iOException.initCause(connectThread.m_ex);
                        }
                        arrayList.remove(connectThread.m_socket);
                        try {
                            connectThread.m_socket.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                Object var40_49 = null;
                iterator3 = arrayList.iterator();
            }
            catch (Throwable throwable) {
                Object var40_50 = null;
                Iterator iterator4 = arrayList.iterator();
                while (iterator4.hasNext()) {
                    Socket socket = (Socket)iterator4.next();
                    if (socket == object) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException3) {}
                }
                throw throwable;
            }
            while (iterator3.hasNext()) {
                Socket socket = (Socket)iterator3.next();
                if (socket == object) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException4) {}
            }
            Object var45_58 = null;
            iterator = cloneable.iterator();
        }
        catch (Throwable throwable) {
            Object var45_59 = null;
            Iterator iterator5 = cloneable.iterator();
            while (iterator5.hasNext()) {
                ConnectThread connectThread = (ConnectThread)iterator5.next();
                long l7 = System.currentTimeMillis();
                TDNetworkIOIF.waitForThreadDeath(connectThread);
                if (!log.canLog(2)) continue;
                log.timing("Discarded connection attempt to " + connectThread.m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l7) + " ms");
            }
            throw throwable;
        }
        while (iterator.hasNext()) {
            ConnectThread connectThread = (ConnectThread)iterator.next();
            long l8 = System.currentTimeMillis();
            TDNetworkIOIF.waitForThreadDeath(connectThread);
            if (!log.canLog(2)) continue;
            log.timing("Discarded connection attempt to " + connectThread.m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l8) + " ms");
        }
        this.m_result_connecttotaltime = System.currentTimeMillis() - l5;
        if (object != null) {
            return object;
        }
        if (iOException == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ635", String.valueOf(l2));
        }
        throw iOException;
    }

    public String toString() {
        return (this.isJavaSPDefaultConnection() ? "jdbc:default:connection" : "socket orig=" + this.m_sOriginalHostName) + (this.socket != null ? " local=" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + " remote=" + this.socket.getInetAddress() + ":" + this.socket.getPort() + " keepalive=" + this.getTcpOption(1) + " nodelay=" + this.getTcpOption(2) + " receive=" + this.getTcpOption(3) + " send=" + this.getTcpOption(4) + " linger=" + this.getTcpOption(5) + " traffic=" + this.getTcpOption(6) + " concurrent=" + this.m_tcp_concurrent + " contimeout=" + this.m_tcp_contimeout + " conwait=" + this.m_tcp_conwait + " connecttime=" + this.m_result_connecttime + " connecttotaltime=" + this.m_result_connecttotaltime + " connectattempts=" + this.m_result_connectattempts + " connectfailures=" + this.m_result_connectfailures + " failurecache=" + sm_mapConnectFailures : "") + " cid=" + this.m_sConnectionID + " sess=" + this.sessionNum;
    }

    private String getTcpOption(int n) {
        try {
            switch (n) {
                case 1: {
                    return String.valueOf(this.socket.getKeepAlive());
                }
                case 2: {
                    return String.valueOf(this.socket.getTcpNoDelay());
                }
                case 3: {
                    return String.valueOf(this.socket.getReceiveBufferSize());
                }
                case 4: {
                    return String.valueOf(this.socket.getSendBufferSize());
                }
                case 5: {
                    return String.valueOf(this.socket.getSoLinger());
                }
                case 6: {
                    return String.valueOf(this.socket.getTrafficClass());
                }
            }
            throw new IllegalArgumentException("Invalid value specified for nDesiredOption");
        }
        catch (SocketException socketException) {
            return "unavailable";
        }
    }

    public String getOriginalHostName() {
        return this.m_sOriginalHostName;
    }

    public InetAddress getRemoteAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    public int getRemotePort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public InetAddress getLocalAddress() {
        return this.socket != null ? this.socket.getLocalAddress() : null;
    }

    public int getLocalPort() {
        return this.socket != null ? this.socket.getLocalPort() : 0;
    }

    public String getConnectionID() {
        return this.m_sConnectionID;
    }

    public int getSessionNum() {
        return this.sessionNum;
    }

    public void setSessionNum(int n) {
        this.sessionNum = n;
    }

    public int read(BufferContainer bufferContainer, int n, boolean bl) throws IOException, SQLException {
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        }
        int n2 = 0;
        long l = System.currentTimeMillis();
        byte[] byArray = bufferContainer.getBuffer();
        int n3 = 1;
        while (true) {
            Object var15_11;
            int n4 = 0;
            try {
                int n5;
                boolean bl2;
                boolean bl3;
                int n6;
                while (n2 < 52 && (n6 = this.inStream.read(byArray, n2, 52 - n2)) != -1) {
                    n2 += n6;
                }
                if (n2 < 52) {
                    if (!bl) {
                        this.log.error("Read message " + n3 + ": Incomplete LAN message header: read " + n2 + " bytes");
                        if (n2 > 0) {
                            this.log.debugPartialByteArray("Incomplete response message header", byArray, 0, n2);
                        }
                    }
                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ324"), n2));
                }
                n6 = (UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 3)) << 16) + UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 8));
                n4 = 52 + n6;
                boolean bl4 = bl3 = n4 > byArray.length && n4 <= 0x500000;
                if (bl3) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    if (this.log.canLog(1)) {
                        this.log.info("Read message " + n3 + ": resizing buffer from " + byArray.length + " bytes to " + byArray2.length + " bytes");
                    }
                    byArray = byArray2;
                    bufferContainer.setBuffer(byArray);
                }
                boolean bl5 = bl2 = n4 > byArray.length;
                if (bl2) {
                    this.log.error("Read message " + n3 + ": Bad response message header with invalid message length of " + n4 + " bytes");
                    this.log.debugPartialByteArray("Bad response message header message dump", byArray, 0, 52);
                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ325"), n4));
                }
                while (n2 < n4 && (n5 = this.inStream.read(byArray, n2, n4 - n2)) != -1) {
                    n2 += n5;
                }
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
                n5 = n2;
                var15_11 = null;
                if (this.log.canLog(2)) {
                    this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray) + "message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                }
                return n5;
            }
            catch (IOException iOException) {
                try {
                    block29: {
                        if (iOException instanceof SocketException && iOException.getMessage().equals("Read timed out") || iOException instanceof InterruptedIOException) {
                            if (!bl) {
                                this.log.info("Read message " + n3 + ", " + n2 + (n4 > 0 ? " of " + n4 : "") + " bytes, timed out: " + iOException);
                                if (n2 > 0) {
                                    this.log.debugPartialByteArray("Timed out message header message dump", byArray, 0, Math.min(n2, 52));
                                }
                            }
                            if (n2 > 0) {
                                if (n3 < 2) {
                                    var15_11 = null;
                                    if (this.log.canLog(2)) {
                                        this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray) + "message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                                    }
                                }
                                if (!bl) {
                                    this.log.error("Read message " + n3 + " timed out after partial read; closing socket due to: " + iOException);
                                }
                                this.close();
                                IOException iOException2 = new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ625"), n2));
                                iOException2.initCause(iOException);
                                throw iOException2;
                            }
                            try {
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                                break block29;
                            }
                            catch (IOException iOException3) {
                                if (!bl) {
                                    this.log.error("Read message " + n3 + " reset socket timeout failed: " + iOException3);
                                }
                                break block29;
                            }
                        }
                        if (!bl) {
                            this.processReconnect(iOException);
                            this.log.error("Read message " + n3 + " failed; closing socket due to: " + iOException);
                        }
                        this.close();
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    var15_11 = null;
                    if (this.log.canLog(2)) {
                        this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray) + "message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                    throw throwable;
                }
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.log.canLog(0)) {
            this.log.debug("writing " + n2 + " bytes");
        }
        long l = System.currentTimeMillis();
        try {
            this.outStream.write(byArray, n, n2);
            this.outStream.flush();
            Object var7_5 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + TDNetworkIOIF.messageTitle(byArray) + "message, " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + TDNetworkIOIF.messageTitle(byArray) + "message, " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
            throw throwable;
        }
    }

    private static String messageTitle(byte[] byArray) {
        boolean bl = byArray.length >= 52;
        String string = bl ? TDNetworkIOIF.nameOf(MESSAGE_KIND, byArray[2]) : null;
        String string2 = bl ? TDNetworkIOIF.nameOf(MESSAGE_CLASS, byArray[1] & 0x7F) : null;
        return string != null && string2 != null ? string + " " + string2 + " " : "";
    }

    private static String nameOf(String[] stringArray, int n) {
        return n >= 0 && n < stringArray.length ? stringArray[n] : null;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.m_sOriginalHostName == null;
    }

    public boolean isClosed() {
        return this.isJavaSPDefaultConnection() ? this.m_bClosedJavaSPDefaultConnection : this.socket == null || this.socket.isClosed();
    }

    public void close() {
        if (this.isJavaSPDefaultConnection()) {
            this.m_bClosedJavaSPDefaultConnection = true;
            return;
        }
        this.closeSocket(false);
    }

    private void closeSocket(boolean bl) {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                try {
                    this.socket.setSoLinger(true, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void acquireReadLock() throws JDBCException {
        this.readLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void acquireWriteLock() throws JDBCException {
        this.writeLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void releaseReadLock() {
        this.readLock.release();
    }

    public void releaseWriteLock() {
        this.writeLock.release();
    }

    public Log getLog() {
        return this.log;
    }

    private static void waitForThreadDeath(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void processReconnect(IOException iOException) throws SQLException {
        if (this.isJavaSPDefaultConnection()) {
            return;
        }
        if (!this.m_con.isReconnectEnabled()) {
            return;
        }
        if (this.m_bReconnectInProgress) {
            return;
        }
        this.m_bReconnectInProgress = true;
        try {
            Object object;
            Object object2;
            int n;
            URLParameters uRLParameters;
            int n2;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Read message failed; will attempt to reconnect after closing socket due to: " + iOException);
            }
            if ((n2 = (uRLParameters = this.m_con.getURLParameters()).getReconnectCount()) == 0) {
                n2 = 11;
            }
            if ((n = uRLParameters.getReconnectInterval()) == 0) {
                n = 30;
            }
            int n3 = 1;
            while (true) {
                block24: {
                    this.closeSocket(true);
                    if (n3 > 1) {
                        if (this.log.canLog(2)) {
                            this.log.timing("Reconnect attempt " + n3 + " of " + n2 + " waiting " + n + " seconds for connection: " + this);
                        }
                        Utility.sleepForSeconds(n);
                    }
                    this.log.error("Reconnect attempt " + n3 + " of " + n2 + " for connection: " + this);
                    try {
                        this.createSocketConnection();
                    }
                    catch (SQLException sQLException) {
                        if (n3 == n2) {
                            throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException);
                        }
                        break block24;
                    }
                    object2 = new GenericLogonController.Reconnect();
                    ((GenericLogonController.Reconnect)object2).nAuthenticationNonce = this.m_con.readAuthenticationNonce();
                    ((GenericLogonController.Reconnect)object2).nRequestNumber = this.m_con.getCurrentRequestNum();
                    object = new GenericLogonController(this.m_con.getLogonInformation(), this.m_con);
                    ((GenericLogonController)object).setReconnect((GenericLogonController.Reconnect)object2);
                    try {
                        ((GenericLogonController)object).run();
                        break;
                    }
                    catch (SQLException sQLException) {
                        this.close();
                        if (n3 != n2 && sQLException.getCause() instanceof SocketException) break block24;
                        throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException);
                    }
                }
                ++n3;
            }
            TDPacket tDPacket = this.m_con.createPacket(1);
            try {
                tDPacket.getBuffer().readStream(this.m_con.getIO(), this.m_con.getTeraEncrypt(), false, 1000, true);
            }
            catch (JDBCException jDBCException) {
                this.close();
                throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, jDBCException);
            }
            tDPacket.initParcelFactory(this.m_con);
            this.log.debug(tDPacket.getBuffer());
            object2 = null;
            block14: while ((object2 = tDPacket.nextParcel()) != null) {
                switch (((Parcel)object2).getFlavor()) {
                    case 12: {
                        continue block14;
                    }
                    case 9: {
                        object = (FailureParcel)object2;
                        throw TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object).getMsg(), ((ErrorParcel)object).getCode()));
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)object2;
                        throw TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode()));
                    }
                }
                throw TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object2).getFlavor())));
            }
            throw TDNetworkIOIF.makeReconnectException("TJ591", iOException, null);
        }
        catch (Throwable throwable) {
            this.m_bReconnectInProgress = false;
            throw throwable;
        }
    }

    private static SQLException makeReconnectException(String string, IOException iOException, SQLException sQLException) {
        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException(string);
        jDBCException.initCause(iOException);
        if (sQLException != null) {
            jDBCException.setNextException(sQLException);
        }
        return jDBCException;
    }

    public static class WorkerThreadList {
        private List m_listCompletedThreads = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List waitForThreads(long l) {
            boolean bl = false;
            try {
                long l2 = System.currentTimeMillis();
                while (this.m_listCompletedThreads.isEmpty()) {
                    long l3;
                    if (l == 0L) {
                        l3 = 0L;
                    } else {
                        long l4 = l2 + l;
                        l3 = l4 - System.currentTimeMillis();
                        if (l3 <= 0L) break;
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                List list = this.m_listCompletedThreads;
                this.m_listCompletedThreads = new ArrayList();
                List list2 = list;
                return list2;
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public synchronized void reportCompletion(Thread thread) {
            this.m_listCompletedThreads.add(thread);
            this.notify();
        }
    }

    public static class ConnectThread
    extends Thread {
        public Socket m_socket;
        public InetSocketAddress m_isa;
        public int m_nTimeoutMs;
        private WorkerThreadList m_workerThreadList;
        public Throwable m_ex;
        public Date m_dateFailure;
        public long m_nElapsedTime;

        public ConnectThread(Socket socket, InetSocketAddress inetSocketAddress, int n, WorkerThreadList workerThreadList) {
            this.m_socket = socket;
            this.m_isa = inetSocketAddress;
            this.m_nTimeoutMs = n;
            this.m_workerThreadList = workerThreadList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            try {
                this.m_socket.connect(this.m_isa, this.m_nTimeoutMs);
            }
            catch (Throwable throwable) {
                this.m_ex = throwable;
                this.m_dateFailure = new Date();
            }
            finally {
                this.m_nElapsedTime = System.currentTimeMillis() - l;
            }
            this.m_workerThreadList.reportCompletion(this);
        }
    }

    public static class Lookup {
        private InetAddress[] m_aAddrs;
        private UnknownHostException m_exUnk;
        private SecurityException m_exSec;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup(GenericTeradataConnection genericTeradataConnection, String string) throws JDBCException {
            block9: {
                this.m_aAddrs = null;
                this.m_exUnk = null;
                this.m_exSec = null;
                genericTeradataConnection.checkRemainingLoginTime();
                long l = System.currentTimeMillis();
                try {
                    try {
                        this.m_aAddrs = InetAddress.getAllByName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.m_exUnk = unknownHostException;
                        Object var7_5 = null;
                        if (genericTeradataConnection.getLog().canLog(2)) {
                            genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                        break block9;
                    }
                    catch (SecurityException securityException) {
                        this.m_exSec = securityException;
                        Object var7_6 = null;
                        if (genericTeradataConnection.getLog().canLog(2)) {
                            genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                    }
                    Object var7_4 = null;
                    if (genericTeradataConnection.getLog().canLog(2)) {
                        genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (genericTeradataConnection.getLog().canLog(2)) {
                        genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                    throw throwable;
                }
            }
        }

        public boolean isLiteralIpAddress() {
            return this.m_aAddrs != null && this.m_aAddrs.length > 0 && this.m_aAddrs[0].toString().startsWith("/");
        }

        public InetAddress[] getAddresses() throws UnknownHostException, SecurityException {
            if (this.m_exUnk != null) {
                throw this.m_exUnk;
            }
            if (this.m_exSec != null) {
                throw this.m_exSec;
            }
            return this.m_aAddrs;
        }
    }
}

