/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.LanHeader;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacketEncrypt;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.SQLException;

public class TDPacketStream
implements BufferContainer {
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    protected byte[] streamBuffer;
    final int offset = 0;

    public TDPacketStream(int n) {
        this.streamBuffer = new byte[n];
        this.limit = n;
        this.capacity = n;
    }

    public byte[] getBuffer() {
        return this.streamBuffer;
    }

    public void setBuffer(byte[] byArray) {
        this.streamBuffer = byArray;
        this.limit = byArray.length;
        this.capacity = byArray.length;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final TDPacketStream position(int n) {
        if (n > this.limit || n < 0) {
            throw new IllegalArgumentException();
        }
        this.position = n;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final TDPacketStream limit(int n) {
        if (n > this.capacity || n < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = n;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public final TDPacketStream mark() {
        this.mark = this.position;
        return this;
    }

    public final TDPacketStream reset() {
        if (this.mark < 0) {
            throw new RuntimeException();
        }
        this.position = this.mark;
        return this;
    }

    public final TDPacketStream clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final TDPacketStream flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final TDPacketStream rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    final int nextGetIndex() throws SQLException {
        if (this.position >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", 1, this.limit, this.position);
        }
        return this.position++;
    }

    final int nextGetIndex(int n) throws SQLException {
        if (this.position + n > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", n, this.limit, this.position);
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int nextPutIndex() {
        if (this.position >= this.limit) {
            throw new RuntimeException();
        }
        return this.position++;
    }

    final int nextPutIndex(int n) {
        if (this.position + n > this.limit) {
            throw new RuntimeException();
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int checkGetIndex(int n) throws SQLException {
        if (n < 0 || n >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", 1, this.limit, n);
        }
        return n;
    }

    final int checkGetIndex(int n, int n2) throws SQLException {
        if (n < 0 || n + n2 > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", n2, this.limit, n);
        }
        return n;
    }

    final int checkIndex(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int checkIndex(int n, int n2) {
        if (n < 0 || n + n2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int markValue() {
        return this.mark;
    }

    static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected int ix(int n) {
        return n + 0;
    }

    public byte get() throws SQLException {
        return this.streamBuffer[this.ix(this.nextGetIndex())];
    }

    public byte get(int n) throws SQLException {
        return this.streamBuffer[this.ix(this.checkGetIndex(n))];
    }

    public TDPacketStream get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public TDPacketStream get(byte[] byArray, int n, int n2) {
        TDPacketStream.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new RuntimeException();
        }
        System.arraycopy(this.streamBuffer, this.ix(this.position()), byArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    public TDPacketStream put(byte by) {
        this.streamBuffer[this.ix((int)this.nextPutIndex())] = by;
        return this;
    }

    public TDPacketStream put(int n, byte by) {
        this.streamBuffer[this.ix((int)this.checkIndex((int)n))] = by;
        return this;
    }

    public TDPacketStream put(byte[] byArray, int n, int n2) {
        TDPacketStream.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new RuntimeException();
        }
        System.arraycopy(byArray, n, this.streamBuffer, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    public TDPacketStream putStream(TDPacketStream tDPacketStream) {
        if (tDPacketStream == this) {
            throw new IllegalArgumentException();
        }
        TDPacketStream tDPacketStream2 = tDPacketStream;
        int n = tDPacketStream2.remaining();
        if (n > this.remaining()) {
            throw new RuntimeException();
        }
        System.arraycopy(tDPacketStream2.streamBuffer, tDPacketStream2.ix(tDPacketStream2.position()), this.streamBuffer, this.ix(this.position()), n);
        tDPacketStream2.position(tDPacketStream2.position() + n);
        this.position(this.position() + n);
        return this;
    }

    public int putInputStream(InputStream inputStream, int n) throws IOException {
        if (n > this.remaining()) {
            throw new RuntimeException();
        }
        int n2 = inputStream.read(this.streamBuffer, this.position, n);
        if (n2 == -1) {
            n2 = 0;
        }
        this.position(this.position() + n2);
        return n2;
    }

    public TDPacketStream getStream(TDPacketStream tDPacketStream, int n, int n2) {
        if (tDPacketStream == this) {
            throw new IllegalArgumentException();
        }
        TDPacketStream tDPacketStream2 = tDPacketStream;
        if (n2 > this.remaining()) {
            throw new RuntimeException();
        }
        System.arraycopy(this.streamBuffer, this.position(), tDPacketStream2.streamBuffer, 0, n2);
        return this;
    }

    byte _get(int n) {
        return this.streamBuffer[n];
    }

    void _put(int n, byte by) {
        this.streamBuffer[n] = by;
    }

    public char getChar() throws SQLException {
        return ByteConverter.getChar(this.streamBuffer, this.ix(this.nextGetIndex(2)));
    }

    public char getChar(int n) throws SQLException {
        return ByteConverter.getChar(this.streamBuffer, this.ix(this.checkGetIndex(n, 2)));
    }

    public TDPacketStream putChar(char c) {
        ByteConverter.putChar(this.streamBuffer, this.ix(this.nextPutIndex(2)), c);
        return this;
    }

    public TDPacketStream putChar(int n, char c) {
        ByteConverter.putChar(this.streamBuffer, this.ix(this.checkIndex(n, 2)), c);
        return this;
    }

    public short getShort() throws SQLException {
        return ByteConverter.getShort(this.streamBuffer, this.ix(this.nextGetIndex(2)));
    }

    public short getShort(int n) throws SQLException {
        return ByteConverter.getShort(this.streamBuffer, this.ix(this.checkGetIndex(n, 2)));
    }

    public TDPacketStream putShort(short s) {
        ByteConverter.putShort(this.streamBuffer, this.ix(this.nextPutIndex(2)), s);
        return this;
    }

    public TDPacketStream putShort(int n, short s) {
        ByteConverter.putShort(this.streamBuffer, this.ix(this.checkIndex(n, 2)), s);
        return this;
    }

    public int getInt() throws SQLException {
        return ByteConverter.getInt(this.streamBuffer, this.ix(this.nextGetIndex(4)));
    }

    public int getUnsignedShort() throws SQLException {
        return ByteConverter.getUnsignedShort(this.streamBuffer, this.ix(this.nextGetIndex(2)));
    }

    public int getInt(int n) throws SQLException {
        return ByteConverter.getInt(this.streamBuffer, this.ix(this.checkGetIndex(n, 4)));
    }

    public TDPacketStream putInt(int n) {
        ByteConverter.putInt(this.streamBuffer, this.ix(this.nextPutIndex(4)), n);
        return this;
    }

    public TDPacketStream putInt(int n, int n2) {
        ByteConverter.putInt(this.streamBuffer, this.ix(this.checkIndex(n, 4)), n2);
        return this;
    }

    public long getLong() throws SQLException {
        return ByteConverter.getLong(this.streamBuffer, this.ix(this.nextGetIndex(8)));
    }

    public long getLong(int n) throws SQLException {
        return ByteConverter.getLong(this.streamBuffer, this.ix(this.checkGetIndex(n, 8)));
    }

    public BigInteger getUnsignedLong() throws SQLException {
        return ByteConverter.getUnsignedLong(this.streamBuffer, this.ix(this.nextGetIndex(8)));
    }

    public TDPacketStream putLong(long l) {
        ByteConverter.putLong(this.streamBuffer, this.ix(this.nextPutIndex(8)), l);
        return this;
    }

    public TDPacketStream putLong(int n, long l) {
        ByteConverter.putLong(this.streamBuffer, this.ix(this.checkIndex(n, 8)), l);
        return this;
    }

    public float getFloat() throws SQLException {
        return ByteConverter.getFloat(this.streamBuffer, this.ix(this.nextGetIndex(4)));
    }

    public float getFloat(int n) throws SQLException {
        return ByteConverter.getFloat(this.streamBuffer, this.ix(this.checkGetIndex(n, 4)));
    }

    public TDPacketStream putFloat(float f) {
        ByteConverter.putFloat(this.streamBuffer, this.ix(this.nextPutIndex(4)), f);
        return this;
    }

    public TDPacketStream putFloat(int n, float f) {
        ByteConverter.putFloat(this.streamBuffer, this.ix(this.checkIndex(n, 4)), f);
        return this;
    }

    public double getDouble() throws SQLException {
        return ByteConverter.getDouble(this.streamBuffer, this.ix(this.nextGetIndex(8)));
    }

    public double getDouble(int n) throws SQLException {
        return ByteConverter.getDouble(this.streamBuffer, this.ix(this.checkGetIndex(n, 8)));
    }

    public TDPacketStream putDouble(double d) {
        ByteConverter.putDouble(this.streamBuffer, this.ix(this.nextPutIndex(8)), d);
        return this;
    }

    public TDPacketStream putDouble(int n, double d) {
        ByteConverter.putDouble(this.streamBuffer, this.ix(this.checkIndex(n, 8)), d);
        return this;
    }

    public BigInteger get16ByteBigInteger() throws SQLException {
        return ByteConverter.get16ByteBigInteger(this.streamBuffer, this.ix(this.nextGetIndex(16)));
    }

    public String getString(int n, String string) throws SQLException {
        try {
            return new String(this.streamBuffer, this.ix(this.nextGetIndex(n)), n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ492", String.valueOf(n), string);
            jDBCException.initCause(unsupportedEncodingException);
            throw jDBCException;
        }
    }

    public String getString(int n, int n2, String string) throws SQLException, UnsupportedEncodingException {
        return new String(this.streamBuffer, this.ix(this.checkGetIndex(n, n2)), n2, string);
    }

    public TDPacketStream putString(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        return this.put(byArray);
    }

    public final TDPacketStream put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public void writeStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt) throws JDBCException {
        this.writeStream(tDNetworkIOIF, tDPacketEncrypt, false);
    }

    public void writeStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt, boolean bl) throws JDBCException {
        this.writeStream(tDNetworkIOIF, tDPacketEncrypt, bl, true);
    }

    public void writeStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt, boolean bl, boolean bl2) throws JDBCException {
        try {
            int n = this.encryptIt(tDPacketEncrypt, this.limit);
            if (n != this.limit) {
                this.limit = n;
            }
            tDNetworkIOIF.getLog().debugPartialByteArray("Raw packet transmit", this.streamBuffer, 0, this.limit);
            tDNetworkIOIF.write(this.streamBuffer, 0, this.limit);
        }
        catch (Throwable throwable) {
            throw ErrorAnalyzer.analyzeIoError("Packet transmit", tDNetworkIOIF, throwable, bl, bl2);
        }
    }

    public void readStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt) throws JDBCException {
        this.readStream(tDNetworkIOIF, tDPacketEncrypt, false, 0, true);
    }

    public void readStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt, boolean bl) throws JDBCException {
        this.readStream(tDNetworkIOIF, tDPacketEncrypt, bl, 0, true);
    }

    public void readStream(TDNetworkIOIF tDNetworkIOIF, TDPacketEncrypt tDPacketEncrypt, boolean bl, int n, boolean bl2) throws JDBCException {
        this.clear();
        try {
            int n2 = tDNetworkIOIF.read(this, n, bl);
            this.limit(n2);
            tDNetworkIOIF.getLog().debugPartialByteArray("Raw packet receive", this.streamBuffer, 0, this.limit);
            n2 = this.decryptIt(tDPacketEncrypt, n2);
            this.limit(n2);
            this.position = 0;
        }
        catch (Throwable throwable) {
            throw ErrorAnalyzer.analyzeIoError("Packet receive", tDNetworkIOIF, throwable, bl, bl2);
        }
    }

    public void expand(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.streamBuffer, 0, byArray, 0, n > this.limit ? this.limit : n);
        this.streamBuffer = byArray;
        this.capacity = n;
    }

    public void expand() {
        this.expand(this.capacity * 2);
    }

    public void expand(byte[] byArray) {
        System.arraycopy(this.streamBuffer, 0, byArray, 0, byArray.length > this.limit ? this.limit : byArray.length);
        this.streamBuffer = byArray;
        this.capacity = byArray.length;
    }

    public void setMsgLength(int n) {
        byte[] byArray = new byte[4];
        ByteConverter.putInt(byArray, 0, n);
        short s = ByteConverter.getShort(byArray, 0);
        short s2 = ByteConverter.getShort(byArray, 2);
        this.putShort(8, s2);
        this.putShort(3, s);
    }

    private int decryptIt(TDPacketEncrypt tDPacketEncrypt, int n) throws SQLException {
        if (n < 2 || (this.streamBuffer[1] & 0x80) == 0) {
            return n;
        }
        this.streamBuffer[1] = (byte)(this.streamBuffer[1] - 128);
        TDPacketEncrypt tDPacketEncrypt2 = tDPacketEncrypt;
        if (tDPacketEncrypt2 == null) {
            return n;
        }
        LanHeader lanHeader = new LanHeader(this);
        int n2 = lanHeader.getMsgLength();
        int n3 = n2 + 28;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.streamBuffer, 24, byArray, 0, n3);
        byte[] byArray2 = tDPacketEncrypt2.decrypt(byArray, 0, byArray.length);
        int n4 = byArray2.length - 28;
        this.setMsgLength(n4);
        System.arraycopy(byArray2, 0, this.streamBuffer, 24, byArray2.length);
        return byArray2.length + 52 - 28;
    }

    private int encryptIt(TDPacketEncrypt tDPacketEncrypt, int n) throws SQLException {
        if (n < 2 || (this.streamBuffer[1] & 0x80) == 0) {
            return n;
        }
        TDPacketEncrypt tDPacketEncrypt2 = tDPacketEncrypt;
        if (tDPacketEncrypt2 == null) {
            return n;
        }
        LanHeader lanHeader = new LanHeader(this);
        int n2 = lanHeader.getMsgLength();
        int n3 = n2 + 28;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.streamBuffer, 24, byArray, 0, n3);
        byte[] byArray2 = tDPacketEncrypt2.encrypt(byArray, 0, byArray.length);
        int n4 = byArray2.length - 28;
        this.setMsgLength(n4);
        int n5 = n4 + 52;
        if (this.streamBuffer.length < n5) {
            byte[] byArray3 = new byte[24];
            System.arraycopy(this.streamBuffer, 0, byArray3, 0, byArray3.length);
            this.streamBuffer = new byte[n5];
            System.arraycopy(byArray3, 0, this.streamBuffer, 0, byArray3.length);
        }
        System.arraycopy(byArray2, 0, this.streamBuffer, 24, byArray2.length);
        return byArray2.length + 52 - 28;
    }
}

