/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.TimeZone;

public class ClientAttributesParcel
extends Parcel {
    private static final short PCLCLIATT_HOSTNAME = 7;
    private static final short PCLCLIATT_PROCTHRID = 8;
    private static final short PCLCLIATT_SYSUSERID = 9;
    private static final short PCLCLIATT_PROGNAME = 10;
    private static final short PCLCLIATT_OSNAME = 11;
    private static final short PCLCLIATT_VMNAME = 22;
    private static final short PCLCLIATT_CLIENTKIND = 28;
    private static final short PCLCLIATT_CLIENTVERSION = 29;
    private static final short PCLCLIATT_ClIENTATTRIBUTESEX = 30;
    private static final short PCLCLIATT_CLIENT_IPADDR_BY_CLIENT = 31;
    private static final short PCLCLIATT_CLIENT_PORT_BY_CLIENT = 32;
    private static final short PCLCLIATT_SERVER_IPADDR_BY_CLIENT = 33;
    private static final short PCLCLIATT_SERVER_PORT_BY_CLIENT = 34;
    private static final short PCLCLIATT_COP_SUFFIXED_HOST_NAME = 45;
    private static final short PCLCLIATT_END = Short.MAX_VALUE;

    public ClientAttributesParcel(Log log, GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        super(log);
        Object object;
        byte by = genericTeradataConnection.getTdSessionCharSetCode();
        String string = genericTeradataConnection.getSerializeDeserializeCharset();
        TDNetworkIOIF tDNetworkIOIF = genericTeradataConnection.getIO();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = tDNetworkIOIF.getOriginalHostName() + (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported() ? "" : ";" + tDNetworkIOIF.getRemoteAddress() + ":" + tDNetworkIOIF.getRemotePort());
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)7, (String)object);
            String string2 = ClientAttributesParcel.getJVMProcessID();
            if (string2 != null) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)8, string2);
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)9, System.getProperty("user.name"));
            String string3 = ClientAttributesParcel.getJavaProgramName();
            if (string3 != null) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)10, string3);
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)11, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
            String string4 = System.getProperty("java.vm.info");
            if (string4 != null) {
                string4 = string4.replaceAll("\\s+", " ").trim();
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)22, System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " " + string4);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)28, "J");
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)29, Const.DRIVER_VERSION);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)30, "JAVA=" + System.getProperty("java.version") + ";MEM=" + Runtime.getRuntime().maxMemory() + ";TZ=" + TDPreparedStatement.formatTimeZone(TimeZone.getDefault()) + ";CID=" + tDNetworkIOIF.getConnectionID() + ";TYPE=" + genericTeradataConnection.getURLParameters().getType() + ";GOV=" + (genericTeradataConnection.getURLParameters().isGoverned() ? "Y" : "N") + ";SCS=" + genericTeradataConnection.getURLParameters().getCharSet() + ";CCS=" + genericTeradataConnection.getSerializeDeserializeCharset() + ";LOB=" + (genericTeradataConnection.isLobSupported() ? "Y" : "N") + ";SIP=" + (genericTeradataConnection.isStatementInfoSupported() ? "Y" : "N") + ";TM=" + (genericTeradataConnection.isAnsiMode() ? "A" : "T") + ";ENC=" + (genericTeradataConnection.getEncryptData() ? "Y" : "N") + ";");
            if (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported()) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)31, tDNetworkIOIF.getLocalAddress().getHostAddress());
                dataOutputStream.writeShort(32);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getLocalPort());
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)33, tDNetworkIOIF.getRemoteAddress().getHostAddress());
                dataOutputStream.writeShort(34);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getRemotePort());
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, string, (short)45, tDNetworkIOIF.getRemoteAddress().getHostName());
            }
            dataOutputStream.writeShort(Short.MAX_VALUE);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw ErrorAnalyzer.analyzeIoError("ClientAttributesParcel construction", tDNetworkIOIF, iOException, false, false);
        }
        object = byteArrayOutputStream.toByteArray();
        this.setFlavor((short)189);
        this.setLength(this.headerLength() + ((Object)object).length);
        this.createBuffer(this.getLength());
        this.parcelHeaderToStream();
        this.buffer.put((byte[])object);
        this.buffer.rewind();
    }

    public TDPacketStream toStream() throws JDBCException {
        return this.buffer;
    }

    private static void serializeStringAttribute(DataOutputStream dataOutputStream, byte by, String string, short s, String string2) throws JDBCException, IOException {
        byte[] byArray;
        if (string2 == null) {
            return;
        }
        if (string2.length() > 500) {
            string2 = string2.substring(500);
        }
        try {
            byArray = string2.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.toString());
            jDBCException.initCause(unsupportedEncodingException);
            throw jDBCException;
        }
        dataOutputStream.writeShort(s);
        dataOutputStream.writeShort(1 + byArray.length);
        dataOutputStream.writeByte(by);
        dataOutputStream.write(byArray);
    }

    public static String getJVMProcessID() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getRuntimeMXBean", null);
            Class<?> clazz2 = Class.forName("java.lang.management.RuntimeMXBean");
            Method method2 = clazz2.getMethod("getName", null);
            Object object = method.invoke(null, (Object[])null);
            Object object2 = method2.invoke(object, (Object[])null);
            if (object2 instanceof String) {
                return (String)object2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getJavaProgramName() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        return stackTraceElementArray != null && stackTraceElementArray.length > 0 && stackTraceElementArray[stackTraceElementArray.length - 1] != null ? stackTraceElementArray[stackTraceElementArray.length - 1].toString() : null;
    }
}

