/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;

public class ConnectParcel
extends Parcel {
    private String partitionName;
    private int logonSequenceNumber;
    private short function;
    private short unusedPad;

    public ConnectParcel(Log log) {
        this("ASCII", log);
    }

    public ConnectParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)88);
        this.setLength(28);
        this.createBuffer(28);
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String string) {
        StringBuffer stringBuffer = new StringBuffer("                ");
        stringBuffer.replace(0, string.length(), string);
        this.partitionName = stringBuffer.toString();
    }

    public int getLogonSequenceNumber() {
        return this.logonSequenceNumber;
    }

    public void setLogonSequenceNumber(int n) {
        this.logonSequenceNumber = n;
    }

    public short getFunction() {
        return this.function;
    }

    public void setFunction(short s) {
        this.function = s;
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        try {
            this.buffer.putString(this.partitionName, this.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.getMessage());
        }
        this.buffer.putInt(this.logonSequenceNumber);
        this.buffer.putShort(this.function);
        this.buffer.putShort(this.unusedPad);
        this.buffer.rewind();
        return this.buffer;
    }
}

