/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;

public class DataParcel
extends Parcel {
    private boolean dataParcelInfoNeedsLength = false;
    private byte[] bytes = null;

    public DataParcel(String string, Log log, String string2, boolean bl) throws JDBCException {
        super(string, log);
        this.setFlavor((short)3);
        this.dataParcelInfoNeedsLength = bl;
        try {
            this.bytes = string2.getBytes(this.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.getMessage());
        }
        if (bl) {
            this.setLength(this.bytes.length + 4 + 2);
        } else {
            this.setLength(this.bytes.length + 4);
        }
        this.createBuffer(this.getLength());
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        if (this.dataParcelInfoNeedsLength) {
            this.buffer.putShort((short)this.bytes.length);
        }
        this.buffer.put(this.bytes);
        this.buffer.flip();
        return this.buffer;
    }
}

