/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.LimitedContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class FullContentMetadataItem
extends LimitedContentMetadataItem {
    public static final byte YES = 89;
    public static final byte NO = 78;
    public static final byte UNKNOWN = 85;
    public static final byte IN = 73;
    public static final byte BOTH = 66;
    public static final byte OUT = 79;
    private String databaseName = "";
    private String procedureOrTableName = "";
    private String columnOrParameterName = "";
    private short columnPositionInTable;
    private String asClauseName = "";
    private String title = "";
    private String format = "";
    private String defaultValue = "";
    private byte isIdentityColumn;
    private byte isDefinitelyWritable;
    private byte isNullable;
    private byte mayBeNull;
    private byte isSearchable;
    private byte isWritable;
    private short udtIndicator;
    private String udtTypeName = "";
    private String dataTypeMiscInfo = "";
    private byte charsetCode;
    private long maxNumberOfCharacters;
    private byte isCaseSensitive;
    private byte isSigned;
    private byte isKeyColumn;
    private byte isUnique;
    private byte isExpression;
    private byte isSortable;
    private byte sPParameterDirection;
    private short m_nStructDepth;
    private byte m_byIsTemporal;
    private String m_sAttributeName = "";
    private short m_nServerDataType;
    private short m_nArrayNumberOfDimensions;
    private int[] m_anArrayMaxCardinalities;
    private int[] m_anArrayLowerBounds;
    private ArrayList m_listAttributeMetadata = new ArrayList();

    public FullContentMetadataItem(short s, short s2, short s3) {
        super(s, s2, s3);
    }

    public void extractData(TDPacketStream tDPacketStream, String string) throws SQLException {
        int n;
        int n2 = tDPacketStream.position();
        int n3 = n2 + this.getItemLength();
        this.databaseName = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.procedureOrTableName = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.columnOrParameterName = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.columnPositionInTable = tDPacketStream.getShort();
        this.asClauseName = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.title = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.format = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.defaultValue = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.isIdentityColumn = tDPacketStream.get();
        this.isDefinitelyWritable = tDPacketStream.get();
        this.isNullable = tDPacketStream.get();
        this.mayBeNull = tDPacketStream.get();
        this.isSearchable = tDPacketStream.get();
        this.isWritable = tDPacketStream.get();
        this.dataType = tDPacketStream.getShort();
        this.udtIndicator = tDPacketStream.getShort();
        this.udtTypeName = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.dataTypeMiscInfo = tDPacketStream.getString(tDPacketStream.getShort(), string);
        this.maxDataLengthInBytes = tDPacketStream.getLong();
        this.totalNumberOfDigits = tDPacketStream.getShort();
        this.numberOfIntervalDigits = tDPacketStream.getShort();
        this.numberOfFractionalDigits = tDPacketStream.getShort();
        this.charsetCode = tDPacketStream.get();
        this.maxNumberOfCharacters = tDPacketStream.getLong();
        this.isCaseSensitive = tDPacketStream.get();
        this.isSigned = tDPacketStream.get();
        this.isKeyColumn = tDPacketStream.get();
        this.isUnique = tDPacketStream.get();
        this.isExpression = tDPacketStream.get();
        this.isSortable = tDPacketStream.get();
        this.sPParameterDirection = tDPacketStream.get();
        int n4 = n3 - tDPacketStream.position();
        if (n4 >= 7) {
            this.m_nStructDepth = tDPacketStream.getShort();
            this.m_byIsTemporal = tDPacketStream.get();
            n = tDPacketStream.getShort();
            this.m_sAttributeName = tDPacketStream.getString(n, string);
            this.m_nServerDataType = tDPacketStream.getShort();
        }
        if ((n4 = n3 - tDPacketStream.position()) >= 2) {
            this.m_nArrayNumberOfDimensions = tDPacketStream.getShort();
            this.m_anArrayMaxCardinalities = new int[this.m_nArrayNumberOfDimensions];
            for (n = 0; n < this.m_nArrayNumberOfDimensions; ++n) {
                this.m_anArrayMaxCardinalities[n] = tDPacketStream.getInt();
            }
            this.m_anArrayLowerBounds = new int[this.m_nArrayNumberOfDimensions];
            for (n = 0; n < this.m_nArrayNumberOfDimensions; ++n) {
                this.m_anArrayLowerBounds[n] = tDPacketStream.getInt();
            }
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "databaseName             : " + this.databaseName + Log.LINE_SEP;
        string = string + "procedureOrTableName     : " + this.procedureOrTableName + Log.LINE_SEP;
        string = string + "columnOrParameterName    : " + this.columnOrParameterName + Log.LINE_SEP;
        string = string + "columnPositionInTable    : " + this.columnPositionInTable + Log.LINE_SEP;
        string = string + "asClauseName             : " + this.asClauseName + Log.LINE_SEP;
        string = string + "title                    : " + this.title + Log.LINE_SEP;
        string = string + "format                   : " + this.format + Log.LINE_SEP;
        string = string + "defaultValue             : " + this.defaultValue + Log.LINE_SEP;
        string = string + "isIdentityColumn         : " + (char)this.isIdentityColumn + Log.LINE_SEP;
        string = string + "isDefinitelyWritable     : " + (char)this.isDefinitelyWritable + Log.LINE_SEP;
        string = string + "isNullable               : " + (char)this.isNullable + Log.LINE_SEP;
        string = string + "mayBeNull                : " + (char)this.mayBeNull + Log.LINE_SEP;
        string = string + "isSearchable             : " + (char)this.isSearchable + Log.LINE_SEP;
        string = string + "isWritable               : " + (char)this.isWritable + Log.LINE_SEP;
        string = string + "udtIndicator             : " + this.udtIndicator + Log.LINE_SEP;
        string = string + "udtTypeName              : " + this.udtTypeName + Log.LINE_SEP;
        string = string + "dataTypeMiscInfo         : " + this.dataTypeMiscInfo + Log.LINE_SEP;
        string = string + "charsetCode              : " + this.charsetCode + Log.LINE_SEP;
        string = string + "maxNumberOfCharacters    : " + this.maxNumberOfCharacters + Log.LINE_SEP;
        string = string + "isCaseSensitive          : " + (char)this.isCaseSensitive + Log.LINE_SEP;
        string = string + "isSigned                 : " + (char)this.isSigned + Log.LINE_SEP;
        string = string + "isKeyColumn              : " + (char)this.isKeyColumn + Log.LINE_SEP;
        string = string + "isUnique                 : " + (char)this.isUnique + Log.LINE_SEP;
        string = string + "isExpression             : " + (char)this.isExpression + Log.LINE_SEP;
        string = string + "isSortable               : " + (char)this.isSortable + Log.LINE_SEP;
        string = string + "SPParameterDirection     : " + (char)this.sPParameterDirection + Log.LINE_SEP;
        string = string + "structDepth              : " + this.m_nStructDepth + Log.LINE_SEP;
        string = string + "isTemporal               : " + this.m_byIsTemporal + Log.LINE_SEP;
        string = string + "attributeName            : " + this.m_sAttributeName + Log.LINE_SEP;
        string = string + "serverDataType           : " + this.m_nServerDataType + Log.LINE_SEP;
        string = string + "arrayNumberOfDimensions  : " + this.m_nArrayNumberOfDimensions + Log.LINE_SEP;
        string = string + "arrayMaxCardinalities    : " + (!this.isArray() || this.m_nArrayNumberOfDimensions == 0 ? "" : this.intArrayToString(this.m_anArrayMaxCardinalities)) + Log.LINE_SEP;
        string = string + "arrayLowerBounds         : " + (!this.isArray() || this.m_nArrayNumberOfDimensions == 0 ? "" : this.intArrayToString(this.m_anArrayLowerBounds)) + Log.LINE_SEP;
        if (this.isStruct() || this.isArray()) {
            int n = this.m_nStructDepth + 1;
            char[] cArray = new char[n];
            char[] cArray2 = new char[n];
            Arrays.fill(cArray, '>');
            Arrays.fill(cArray2, '<');
            string = string + Log.LINE_SEP + cArray + " Begin " + (this.isStruct() ? "Attributes" : "Array's Base Type") + " with " + this.m_listAttributeMetadata.size() + " items at depth " + n + Log.LINE_SEP + Log.LINE_SEP;
            Iterator iterator = this.m_listAttributeMetadata.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next().toString() + Log.LINE_SEP;
            }
            string = string + Log.LINE_SEP + cArray2 + " End of " + (this.isStruct() ? "Attributes" : "Array's Base Type") + " " + n + Log.LINE_SEP + Log.LINE_SEP;
        }
        return string;
    }

    private String intArrayToString(int[] nArray) {
        String string = "";
        for (int i = 1; nArray != null && i <= nArray.length; ++i) {
            string = string + (i == 1 ? "" : ", ") + nArray[i - 1] + (i == nArray.length ? Log.LINE_SEP : "");
        }
        return string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getProcedureOrTableName() {
        return this.procedureOrTableName;
    }

    public void setProcedureOrTableName(String string) {
        this.procedureOrTableName = string;
    }

    public String getColumnOrParameterName() {
        return this.columnOrParameterName;
    }

    public void setColumnOrParameterName(String string) {
        this.columnOrParameterName = string;
    }

    public short getColumnPositionInTable() {
        return this.columnPositionInTable;
    }

    public void setColumnPositionInTable(short s) {
        this.columnPositionInTable = s;
    }

    public String getAsClauseName() {
        return this.asClauseName;
    }

    public void setAsClauseName(String string) {
        this.asClauseName = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getCustomerVisibleColumnName() {
        if (this.asClauseName.length() > 0) {
            return this.asClauseName;
        }
        if (this.columnOrParameterName.length() > 0) {
            return this.columnOrParameterName;
        }
        return this.title;
    }

    public String getCustomerVisibleColumnTypeName() {
        if (this.m_nServerDataType != 0) {
            return JDBC4Constants.getTDTypeName(this.m_nServerDataType);
        }
        if ((this.udtIndicator != 0 || this.isArray()) && this.udtTypeName.length() != 0) {
            return this.udtTypeName;
        }
        return JDBC4Constants.getTDTypeName(this.dataType);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public byte isIdentityColumn() {
        return this.isIdentityColumn;
    }

    public void setIsIdentityColumn(byte by) {
        this.isIdentityColumn = by;
    }

    public byte isDefinitelyWritable() {
        return this.isDefinitelyWritable;
    }

    public void setIsDefinitelyWritable(byte by) {
        this.isDefinitelyWritable = by;
    }

    public byte isNullable() {
        return this.isNullable;
    }

    public void setIsNullable(byte by) {
        this.isNullable = by;
    }

    public byte getMayBeNull() {
        return this.mayBeNull;
    }

    public void setMayBeNull(byte by) {
        this.mayBeNull = by;
    }

    public byte isSearchable() {
        return this.isSearchable;
    }

    public void setIsSearchable(byte by) {
        this.isSearchable = by;
    }

    public byte isWritable() {
        return this.isWritable;
    }

    public void setIsWritable(byte by) {
        this.isWritable = by;
    }

    public short getUdtIndicator() {
        return this.udtIndicator;
    }

    public void setUdtIndicator(short s) {
        this.udtIndicator = s;
    }

    public String getUdtTypeName() {
        return this.udtTypeName;
    }

    public void setUdtTypeName(String string) {
        this.udtTypeName = string;
    }

    public String getDataTypeMiscInfo() {
        return this.dataTypeMiscInfo;
    }

    public void setDataTypeMiscInfo(String string) {
        this.dataTypeMiscInfo = string;
    }

    public byte getCharsetCode() {
        return this.charsetCode;
    }

    public void setCharsetCode(byte by) {
        this.charsetCode = by;
    }

    public long getMaxNumberOfCharacters() {
        return this.maxNumberOfCharacters;
    }

    public void setMaxNumberOfCharacters(long l) {
        this.maxNumberOfCharacters = l;
    }

    public byte isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setIsCaseSensitive(byte by) {
        this.isCaseSensitive = by;
    }

    public byte getColumnExtInfo() {
        return this.isCaseSensitive == 89 ? (byte)1 : 0;
    }

    public byte isSigned() {
        return this.isSigned;
    }

    public void setIsSigned(byte by) {
        this.isSigned = by;
    }

    public byte isKeyColumn() {
        return this.isKeyColumn;
    }

    public void setIsKeyColumn(byte by) {
        this.isKeyColumn = by;
    }

    public byte isUnique() {
        return this.isUnique;
    }

    public void setIsUnique(byte by) {
        this.isUnique = by;
    }

    public byte isExpression() {
        return this.isExpression;
    }

    public void setIsExpression(byte by) {
        this.isExpression = by;
    }

    public byte isSortable() {
        return this.isSortable;
    }

    public void setIsSortable(byte by) {
        this.isSortable = by;
    }

    public byte getSPParameterDirection() {
        return this.sPParameterDirection;
    }

    public boolean isDistinct() {
        return this.udtIndicator == 2;
    }

    public boolean isStruct() {
        return JDBC4Constants.getTDBasicType(this.dataType) == 440;
    }

    public short getStructDepth() {
        return this.m_nStructDepth;
    }

    public byte isTemporal() {
        return this.m_byIsTemporal;
    }

    public String getAttributeName() {
        return this.m_sAttributeName;
    }

    public short getServerDataType() {
        return this.m_nServerDataType;
    }

    public ArrayList getAttributeItemList() {
        return this.m_listAttributeMetadata;
    }

    public void addAttributeItem(FullContentMetadataItem fullContentMetadataItem) {
        this.m_listAttributeMetadata.add(fullContentMetadataItem);
    }

    public FullContentMetadataItem[] getAttributeItemArray() {
        return this.m_listAttributeMetadata.toArray(new FullContentMetadataItem[0]);
    }

    public int getNumberOfArrayDimensions() {
        return this.m_nArrayNumberOfDimensions;
    }

    public int[] getArrayMaxCardinalities() {
        return this.m_anArrayMaxCardinalities;
    }

    public boolean isArray() {
        return JDBC4Constants.getTDBasicType(this.dataType) == 504 || JDBC4Constants.getTDBasicType(this.dataType) == 508;
    }
}

