/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class IndicDataParcel
extends Parcel {
    private ParameterProperties.ParameterSet m_parameterSet;
    private byte[] nullIndicatorBits;
    public static final int LENGTH = 4;

    public IndicDataParcel(Log log) {
        this("ASCII", log);
    }

    public IndicDataParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)68);
    }

    public IndicDataParcel(int n, Log log) {
        this(n, "ASCII", log);
    }

    public IndicDataParcel(int n, String string, Log log) {
        super(string, log);
        this.setFlavor((short)68);
        this.setLength(n + 4);
        this.createBuffer(n + 4);
    }

    public void setParameters(ParameterProperties.ParameterSet parameterSet) {
        this.m_parameterSet = parameterSet;
    }

    public void setNullIndicatorBits(byte[] byArray) {
        this.nullIndicatorBits = byArray;
    }

    public TDPacketStream toStream() throws JDBCException {
        if (this.buffer == null) {
            this.createBuffer(this.getLength());
        }
        super.toStream();
        this.buffer.put(this.nullIndicatorBits);
        IndicDataParcel.putPreparedParams(this.buffer, this.m_parameterSet);
        this.buffer.flip();
        return this.buffer;
    }

    private static void putPreparedParams(TDPacketStream tDPacketStream, ParameterProperties.ParameterSet parameterSet) {
        for (int i = 1; parameterSet != null && i <= parameterSet.getNumberOfParamValues(); ++i) {
            if (parameterSet.getParamType(i) == 2) continue;
            if (parameterSet.isArray(i)) {
                short s = parameterSet.getAttributeParamSet(i).getArrayDataSize();
                tDPacketStream.putShort(s);
                if (!parameterSet.isNullValue(i)) {
                    tDPacketStream.putInt(parameterSet.getAttributeParamSet(i).getNumberOfParamValues());
                    tDPacketStream.put(parameterSet.getAttributeParamSet(i).getNullIndicatorBits());
                }
            }
            if (parameterSet.isStruct(i) || parameterSet.isArray(i)) {
                IndicDataParcel.putPreparedParams(tDPacketStream, parameterSet.getAttributeParamSet(i));
                continue;
            }
            tDPacketStream.put(parameterSet.getBinaryValue(i));
        }
    }
}

