/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class OptionsParcel
extends Parcel {
    private byte requestMode = (byte)73;
    private byte dBCFunction = (byte)66;
    private byte lobSelect = 0;
    private byte clobTranslate = 0;
    private byte aphResponses = 0;
    private byte returnStatementInfo = 0;
    private byte m_byUDTTransformsOff = 0;
    private byte maxDecimalPrecision = 0;
    private byte generatedKeys = 0;
    private byte dynamicResultSetsAllowed = 0;
    private byte spReturnResult = 0;
    private byte m_byReturnPeriodsAsStructs = 0;
    private byte m_byReturnExtendedObjectNames = 0;
    private byte m_byTrustMode = 0;
    private byte m_byStatementIndependence = 0;
    private byte m_byArrayTransformOff = 0;
    private byte m_byXMLDataFormat = 0;
    private byte m_byFailFast = 0;
    public static final byte RS_RETURNED_TO_SENDER = 0;
    public static final byte RS_RETURNED_TO_CLIENT = 1;
    public static final byte RS_RETURNED_TO_CALLER = 2;
    public static final byte RS_RETURNED_TO_CLIENT_AND_SP = 3;
    public static final byte RS_RETURNED_TO_CALLER_AND_SP = 4;
    public static final byte B_MODE = 66;
    public static final byte E_MODE = 69;
    public static final byte P_MODE = 80;
    public static final byte S_MODE = 83;
    public static final byte INLINE = 73;
    public static final byte STATIC = 83;
    public static final byte USE_CALLSP_RESP = 67;
    public static final byte LOCATOR = 76;
    public static final byte LOCKED = 76;
    public static final byte UNLOCKED = 85;
    public static final byte INDIC = 73;
    public static final byte MULTIPART_INDIC = 77;
    public static final byte APH_RESPONSES_OK = 89;
    public static final byte GENKEY_ROW = 82;
    public static final byte GENKEY_COL = 67;
    public static final byte UDT_TRANSFORMS_OFF = 89;
    public static final byte RETURN_PERIODS_AS_STRUCTS = 89;
    public static final byte TRUSTED_SQL_REQUEST = 89;
    public static final byte UNTRUSTED_SQL_REQUEST = 78;
    public static final byte STMT_INDEPENDENCE_ON = 89;
    public static final byte STMT_INDEPENDENCE_OFF = 78;
    public static final byte ARRAY_TRANSFORMS_OFF = 89;
    public static final byte XML_TEXT_FORMAT = 67;
    public static final byte XML_BINARY_FORMAT = 66;
    public static final byte FAIL_FAST_ON = 89;
    public static final byte FAIL_FAST_OFF = 78;

    protected OptionsParcel(String string, TDSession tDSession, boolean bl) {
        super(string, tDSession.getLog());
        this.setFlavor(bl ? (short)-32683 : 85);
        this.setAltHeader(bl);
        this.setLength(OptionsParcel.standardOptionsParcelLength(tDSession) + (bl ? 4 : 0));
        this.createBuffer(this.getLength());
        this.m_byReturnExtendedObjectNames = tDSession.isExtObjectNameParcelSupported() ? (byte)1 : 0;
    }

    public OptionsParcel(String string, TDSession tDSession) {
        this(string, tDSession, false);
    }

    public static int standardOptionsParcelLength(TDSession tDSession) {
        int n = 10;
        if (tDSession.dynamicResultSetsSupported()) {
            n = 11;
        }
        if (tDSession.isExtObjectNameParcelSupported() || tDSession.isPeriodAsStructSupported() || tDSession.getConfigResponse().isTrustedSQLSupported() || tDSession.getConfigResponse().isStatementIndependenceSupported()) {
            n = 15;
        }
        if (tDSession.isArrayDataTypeSupported()) {
            n = 16;
        }
        if (tDSession.isXMLDataTypeSupported() || tDSession.getConfigResponse().isFailFastSupported()) {
            n = 18;
        }
        return 4 + n;
    }

    public void setDBCFunction(byte by) {
        this.dBCFunction = by;
    }

    public void setRequestMode(byte by) {
        this.requestMode = by;
    }

    public void setLobSelect(byte by) {
        this.lobSelect = by;
    }

    public void setClobTranslate(byte by) {
        this.clobTranslate = by;
    }

    public void setAPHResponses(byte by) {
        this.aphResponses = by;
    }

    public void setGenKeyType(byte by) {
        this.generatedKeys = by;
    }

    public void setMaxDecimalPrecision(byte by) {
        this.maxDecimalPrecision = by;
    }

    public void setReturnStatementInfo(boolean bl) {
        this.returnStatementInfo = (byte)(bl ? 89 : 0);
    }

    public void setDynamicResultSetAllowed(boolean bl) {
        this.dynamicResultSetsAllowed = (byte)(bl ? 89 : 0);
    }

    public void setSPReturnResult(byte by) {
        this.spReturnResult = by;
    }

    public void setUDTTransformsOff(byte by) {
        this.m_byUDTTransformsOff = by;
    }

    public void setReturnPeriodsAsStructs(byte by) {
        this.m_byReturnPeriodsAsStructs = by;
    }

    public void setTrustMode(byte by) {
        this.m_byTrustMode = by;
    }

    public void setStatementIndependence(byte by) {
        this.m_byStatementIndependence = by;
    }

    public void setArrayTransformOff(byte by) {
        this.m_byArrayTransformOff = by;
    }

    public void setXMLDataFormat(byte by) {
        this.m_byXMLDataFormat = by;
    }

    public void setFailFast(byte by) {
        this.m_byFailFast = by;
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        this.buffer.put(this.requestMode);
        this.buffer.put(this.dBCFunction);
        this.buffer.put(this.lobSelect);
        this.buffer.put(this.clobTranslate);
        this.buffer.put(this.aphResponses);
        this.buffer.put(this.returnStatementInfo);
        this.buffer.put(this.m_byUDTTransformsOff);
        this.buffer.put(this.maxDecimalPrecision);
        this.buffer.put(this.generatedKeys);
        this.buffer.put(this.dynamicResultSetsAllowed);
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.spReturnResult);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byReturnPeriodsAsStructs);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byReturnExtendedObjectNames);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byTrustMode);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byStatementIndependence);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byArrayTransformOff);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byXMLDataFormat);
        }
        if (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put(this.m_byFailFast);
        }
        while (this.buffer.position() < this.buffer.capacity()) {
            this.buffer.put((byte)0);
        }
        this.buffer.flip();
        return this.buffer;
    }
}

